/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IBoundary;
import org.xmind.core.ICloneData;
import org.xmind.core.ICommentManager;
import org.xmind.core.IIdentifiable;
import org.xmind.core.IManifest;
import org.xmind.core.IMeta;
import org.xmind.core.INotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.IResourceRef;
import org.xmind.core.IRevisionRepository;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.CloneData;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.plain.Boundary;
import org.xmind.core.plain.CommentManager;
import org.xmind.core.plain.HtmlNotesContent;
import org.xmind.core.plain.Manifest;
import org.xmind.core.plain.MarkerSheet;
import org.xmind.core.plain.Meta;
import org.xmind.core.plain.PlainNotesContent;
import org.xmind.core.plain.Relationship;
import org.xmind.core.plain.ResourceRef;
import org.xmind.core.plain.RevisionRepository;
import org.xmind.core.plain.Sheet;
import org.xmind.core.plain.StyleSheet;
import org.xmind.core.plain.Summary;
import org.xmind.core.plain.Topic;
import org.xmind.core.plain.WorkbookExtensionManager;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.CloneHandler;
import org.xmind.core.util.ObjectRefManager;
import org.xmind.core.util.ObjectRegistry;

public class Workbook
implements IWorkbook,
ICoreEventSource,
ICoreEventSource2 {
    private final IStorage storage;
    private final String version;
    private final List<Sheet> sheets;
    private final Manifest manifest;
    private final ObjectRegistry objectRegistry;
    private final CoreEventSupport eventSupport;
    private final ObjectRefManager objectRefManager;
    private final StyleSheet styleSheet;
    private final MarkerSheet markerSheet;
    private final Meta meta;
    private final RevisionRepository revisionRepository;
    private final CommentManager commentManager;
    private final WorkbookExtensionManager extensionManager;
    private long modifiedTime;
    private String modifiedBy;

    public Workbook() {
        this(null, null, false, null);
    }

    public Workbook(IStorage storage, String version, boolean bare, String attachmentPathPrefix) {
        this.storage = storage == null ? new ByteArrayStorage() : storage;
        this.version = version;
        this.sheets = new ArrayList<Sheet>();
        this.manifest = new Manifest(this, attachmentPathPrefix);
        this.objectRegistry = new ObjectRegistry();
        this.eventSupport = new CoreEventSupport();
        this.objectRefManager = new ObjectRefManager(this, (ICoreEventSupport)this.eventSupport);
        this.styleSheet = new StyleSheet(this.objectRegistry, (ICoreEventSupport)this.eventSupport, this.manifest);
        this.markerSheet = new MarkerSheet(this.objectRegistry, (ICoreEventSupport)this.eventSupport, this.manifest);
        this.meta = new Meta(this);
        this.revisionRepository = new RevisionRepository(this);
        this.commentManager = new CommentManager(this);
        this.extensionManager = new WorkbookExtensionManager(this);
        this.modifiedTime = 0L;
        this.modifiedBy = null;
        if (!bare && this.sheets.isEmpty()) {
            this.addSheet(this.createSheet());
        }
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public ObjectRegistry getObjectRegistry() {
        return this.objectRegistry;
    }

    public CoreEventSupport getCoreEventSupport() {
        return this.eventSupport;
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.eventSupport.registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IStorage.class.equals(adapter)) {
            return adapter.cast(this.storage);
        }
        if (ICoreEventSupport.class.equals(adapter)) {
            return adapter.cast(this.eventSupport);
        }
        if (ObjectRefManager.class.equals(adapter)) {
            return adapter.cast(this.objectRefManager);
        }
        if (IWorkbookExtensionManager.class.equals(adapter)) {
            return adapter.cast(this.extensionManager);
        }
        return null;
    }

    public long getModifiedTime() {
        return this.modifiedTime;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModificationInfo(long modifiedTime, String modifiedBy) {
        long oldModifiedTime = this.modifiedTime;
        if (modifiedTime == oldModifiedTime) {
            return;
        }
        this.modifiedTime = modifiedTime;
        this.modifiedBy = modifiedBy;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "modifyTime", (Object)oldModifiedTime, (Object)modifiedTime);
    }

    public ITopic createTopic() {
        return new Topic(this, this.objectRegistry.createUniqueId());
    }

    public ISheet createSheet() {
        return new Sheet(this, this.objectRegistry.createUniqueId(), false);
    }

    public IRelationship createRelationship(IRelationshipEnd end1, IRelationshipEnd end2) {
        Relationship r = new Relationship(this, this.objectRegistry.createUniqueId());
        if (end1 != null) {
            r.setEnd1Id(end1.getId());
        }
        if (end2 != null) {
            r.setEnd2Id(end2.getId());
        }
        return r;
    }

    public IRelationship createRelationship() {
        return new Relationship(this, this.objectRegistry.createUniqueId());
    }

    public IBoundary createBoundary() {
        return new Boundary(this, this.objectRegistry.createUniqueId());
    }

    public ISummary createSummary() {
        return new Summary(this, this.objectRegistry.createUniqueId());
    }

    public List<ISheet> getSheets() {
        return Collections.unmodifiableList(this.sheets);
    }

    public ISheet getPrimarySheet() {
        return this.sheets.isEmpty() ? null : this.sheets.get(0);
    }

    public void addSheet(ISheet sheet) {
        this.addSheet(sheet, -1);
    }

    public void addSheet(ISheet sheet, int index) {
        if (sheet == null || !(sheet instanceof Sheet) || sheet.getOwnedWorkbook() != this) {
            throw new IllegalArgumentException();
        }
        Sheet childSheet = (Sheet)sheet;
        if (index < 0) {
            this.sheets.add(childSheet);
            index = this.sheets.size() - 1;
        } else {
            this.sheets.add(index, childSheet);
        }
        childSheet.onParented();
        this.getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)this, "sheetAdd", (Object)childSheet, index);
    }

    public void removeSheet(ISheet sheet) {
        if (sheet == null || !(sheet instanceof Sheet) || sheet.getOwnedWorkbook() != this) {
            throw new IllegalArgumentException();
        }
        Sheet childSheet = (Sheet)sheet;
        int index = this.sheets.indexOf(childSheet);
        if (index < 0) {
            return;
        }
        childSheet.onOrphan();
        this.sheets.remove(childSheet);
        this.getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)this, "sheetRemove", (Object)childSheet, index);
    }

    public void moveSheet(int sourceIndex, int targetIndex) {
        if (sourceIndex < 0 || sourceIndex == targetIndex) {
            return;
        }
        if (sourceIndex >= this.sheets.size()) {
            return;
        }
        Sheet childSheet = this.sheets.get(sourceIndex);
        if (targetIndex >= 0 && targetIndex < this.sheets.size()) {
            this.sheets.remove(sourceIndex);
            this.sheets.add(targetIndex, childSheet);
        }
        childSheet.onParented();
        this.getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)this, "sheetMove", (Object)childSheet, sourceIndex);
    }

    public Object getElementById(String id) {
        return this.objectRegistry.get(id);
    }

    public Object findElement(String id, IAdaptable source) {
        return this.objectRegistry.get(id);
    }

    public ITopic findTopic(String id) {
        return this.findTopic(id, null);
    }

    public ITopic findTopic(String id, IAdaptable source) {
        IIdentifiable obj = this.objectRegistry.get(id);
        if (obj == null || !(obj instanceof ITopic)) {
            return null;
        }
        return (ITopic)obj;
    }

    public IStyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public IManifest getManifest() {
        return this.manifest;
    }

    public IMeta getMeta() {
        return this.meta;
    }

    public IMarkerSheet getMarkerSheet() {
        return this.markerSheet;
    }

    public INotesContent createNotesContent(String format) {
        if ("html".equals(format)) {
            return new HtmlNotesContent(this, format);
        }
        return new PlainNotesContent(this, format);
    }

    public String getVersion() {
        return this.version;
    }

    public ICloneData clone(Collection<? extends Object> sources) {
        CloneData mapper = new CloneData(sources, null);
        for (Object object : sources) {
            Workbook sourceWorkbook = object instanceof IWorkbookComponent ? ((IWorkbookComponent)object).getOwnedWorkbook() : this;
            CloneHandler handler = new CloneHandler((ICloneData)mapper).withWorkbooks((IWorkbook)sourceWorkbook, (IWorkbook)this);
            try {
                mapper.put(object, handler.cloneObject(object));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return mapper;
    }

    public ITopic cloneTopic(ITopic topic) {
        return (ITopic)this.clone(Arrays.asList(topic)).get((Object)topic);
    }

    public IAdaptable importElement(IAdaptable source) {
        return null;
    }

    public IResourceRef createResourceRef(String resourceType, String resourceId) {
        return new ResourceRef(this, resourceType, resourceId);
    }

    public void save() throws IOException, CoreException {
        throw new UnsupportedOperationException();
    }

    public void save(String file) throws IOException, CoreException {
        throw new UnsupportedOperationException();
    }

    public void save(OutputStream output) throws IOException, CoreException {
        throw new UnsupportedOperationException();
    }

    public void save(IOutputTarget target) throws IOException, CoreException {
        throw new UnsupportedOperationException();
    }

    public String getFile() {
        throw new UnsupportedOperationException();
    }

    public void setFile(String file) {
        throw new UnsupportedOperationException();
    }

    public void setTempStorage(IStorage storage) {
        throw new UnsupportedOperationException();
    }

    public IStorage getTempStorage() {
        throw new UnsupportedOperationException();
    }

    public void setTempLocation(String tempLocation) {
        throw new UnsupportedOperationException();
    }

    public String getTempLocation() {
        throw new UnsupportedOperationException();
    }

    public void saveTemp() throws IOException, CoreException {
    }

    public void setPassword(String password) {
    }

    public String getPassword() {
        return null;
    }

    public IRevisionRepository getRevisionRepository() {
        return this.revisionRepository;
    }

    public ICommentManager getCommentManager() {
        return this.commentManager;
    }

    public static boolean isOrphanWorkbookComponent(Object obj) {
        return !(obj instanceof IWorkbookComponent) || ((IWorkbookComponent)obj).isOrphan();
    }

    public ICoreEventRegistration registerOnceCoreEventListener(String eventType, ICoreEventListener listener) {
        return this.eventSupport.registerOnceCoreEventListener((ICoreEventSource)this, eventType, listener);
    }

    public boolean hasOnceListeners(String eventType) {
        return this.eventSupport.hasOnceListeners((ICoreEventSource)this, eventType);
    }
}

