/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicPath;
import org.xmind.core.IWorkbook;
import org.xmind.core.plain.Sheet;
import org.xmind.core.plain.Topic;

public class TopicPath
implements ITopicPath {
    private Topic topic;

    public TopicPath(Topic topic) {
        this.topic = topic;
    }

    public List<Object> toList() {
        Sheet sheet;
        ArrayList<Object> list = new ArrayList<Object>();
        TopicPathIterator topicIt = new TopicPathIterator();
        Topic rootTopic = null;
        while (topicIt.hasNext()) {
            Topic t = (Topic)topicIt.next();
            list.add(t);
            rootTopic = t;
        }
        if (rootTopic != null && (sheet = rootTopic.getParentSheet()) != null) {
            list.add(sheet);
            IWorkbook workbook = sheet.getParent();
            if (workbook != null) {
                list.add(workbook);
            }
        }
        Collections.reverse(list);
        return list;
    }

    public List<ITopic> toTopicList() {
        TopicPathIterator topicIt = new TopicPathIterator();
        ArrayList<ITopic> list = new ArrayList<ITopic>();
        while (topicIt.hasNext()) {
            list.add((ITopic)topicIt.next());
        }
        Collections.reverse(list);
        return list;
    }

    public IWorkbook getWorkbook() {
        Sheet sheet;
        TopicPathIterator topicIt = new TopicPathIterator();
        Topic rootTopic = null;
        while (topicIt.hasNext()) {
            rootTopic = (Topic)topicIt.next();
        }
        if (rootTopic != null && (sheet = rootTopic.getParentSheet()) != null) {
            return sheet.getParent();
        }
        return null;
    }

    public ISheet getSheet() {
        TopicPathIterator topicIt = new TopicPathIterator();
        Topic rootTopic = null;
        while (topicIt.hasNext()) {
            rootTopic = (Topic)topicIt.next();
        }
        if (rootTopic != null) {
            return rootTopic.getParentSheet();
        }
        return null;
    }

    public ITopic getRootTopic() {
        Sheet sheet;
        TopicPathIterator topicIt = new TopicPathIterator();
        Topic rootTopic = null;
        while (topicIt.hasNext()) {
            rootTopic = (Topic)topicIt.next();
        }
        if (rootTopic != null && (sheet = rootTopic.getParentSheet()) != null) {
            return rootTopic;
        }
        return null;
    }

    public boolean contains(ITopic topic) {
        if (topic == null) {
            return false;
        }
        TopicPathIterator topicIt = new TopicPathIterator();
        while (topicIt.hasNext()) {
            if (!topic.equals(topicIt.hasNext())) continue;
            return true;
        }
        return false;
    }

    public boolean isDescendentOf(ITopic ancestor) {
        if (ancestor == null) {
            return true;
        }
        TopicPathIterator topicIt = new TopicPathIterator();
        while (topicIt.hasNext()) {
            Topic t = (Topic)topicIt.next();
            if (!ancestor.equals(t)) continue;
            return t != this.topic;
        }
        return false;
    }

    private class TopicPathIterator
    implements Iterator<Topic> {
        private Topic nextTopic;

        private TopicPathIterator() {
            this.nextTopic = TopicPath.this.topic;
        }

        private Topic findNextTopic(Topic t) {
            return t.getParentTopic();
        }

        @Override
        public boolean hasNext() {
            return this.nextTopic != null;
        }

        @Override
        public Topic next() {
            Topic n = this.nextTopic;
            if (n == null) {
                throw new NoSuchElementException();
            }
            this.nextTopic = this.findNextTopic(n);
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

