/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.plain.StyleSheet;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.Property;

public class Style
implements IStyle,
ICoreEventSource {
    private StyleSheet owner;
    private String type;
    private String id;
    private String groupName;
    private Map<String, String> properties;
    private String name;
    private Map<String, String> defaultStyleIds;

    public Style(StyleSheet owner, String type, String id) {
        this.owner = owner;
        this.type = type;
        this.id = id;
        this.groupName = null;
        this.properties = new HashMap<String, String>();
        this.name = null;
        this.defaultStyleIds = new HashMap<String, String>();
        owner.getObjectRegistry().register(this);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.owner.getCoreEventSupport();
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.owner.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void setProperty(String key, String value) {
        String oldValue;
        if (key == null) {
            throw new IllegalArgumentException("The argument 'key' is null");
        }
        if (value == null ? (oldValue = this.properties.remove(key)) == null : value.equals(oldValue = this.properties.put(key, value))) {
            return;
        }
        this.getCoreEventSupport().dispatchTargetValueChange((ICoreEventSource)this, "property", (Object)key, (Object)oldValue, (Object)value);
    }

    public Iterator<Property> properties() {
        final Iterator<Map.Entry<String, String>> it = this.properties.entrySet().iterator();
        return new Iterator<Property>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Property next() {
                Map.Entry entry = (Map.Entry)it.next();
                return new Property((String)entry.getKey(), (String)entry.getValue());
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }
        };
    }

    public int size() {
        if (!this.defaultStyleIds.isEmpty()) {
            return this.defaultStyleIds.size();
        }
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty() && this.defaultStyleIds.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        if (name == oldName || name != null && name.equals(oldName)) {
            return;
        }
        this.name = name;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "name", (Object)oldName, (Object)name);
    }

    public IStyleSheet getOwnedStyleSheet() {
        return this.owner;
    }

    public String getType() {
        return this.type;
    }

    public Iterator<Property> defaultStyles() {
        final Iterator<Map.Entry<String, String>> it = this.defaultStyleIds.entrySet().iterator();
        return new Iterator<Property>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Property next() {
                Map.Entry e = (Map.Entry)it.next();
                return new Property((String)e.getKey(), (String)e.getValue());
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }
        };
    }

    public String getDefaultStyleId(String styleFamily) {
        return styleFamily == null ? null : this.defaultStyleIds.get(styleFamily);
    }

    public IStyle getDefaultStyle(String styleFamily) {
        return this.getDefaultStyleById(this.getDefaultStyleId(styleFamily));
    }

    public IStyle getDefaultStyleById(String styleId) {
        return styleId == null ? null : this.owner.findStyle(styleId);
    }

    public void setDefaultStyleId(String styleFamily, String styleId) {
        String oldStyleId;
        if (styleFamily == null) {
            throw new IllegalArgumentException("The argument 'styleFamily' is null");
        }
        if (styleId == null ? (oldStyleId = this.defaultStyleIds.remove(styleFamily)) == null : styleId.equals(oldStyleId = this.defaultStyleIds.put(styleFamily, styleId))) {
            return;
        }
    }
}

