/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xmind.core.IIdentifiable;
import org.xmind.core.ILegend;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISheetSetting;
import org.xmind.core.ISheetSettings;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.legacy.LabelRefCounterProxy;
import org.xmind.core.internal.legacy.MarkerRefCounterProxy;
import org.xmind.core.plain.Legend;
import org.xmind.core.plain.Relationship;
import org.xmind.core.plain.SheetSettings;
import org.xmind.core.plain.Topic;
import org.xmind.core.plain.Workbook;
import org.xmind.core.style.IStyle;
import org.xmind.core.util.ILabelRefCounter;
import org.xmind.core.util.IMarkerRefCounter;

public class Sheet
implements ISheet,
ICoreEventSource {
    private final Workbook ownerWorkbook;
    private final String id;
    private boolean orphan;
    private String titleText;
    private Topic rootTopic;
    private String styleId;
    private String themeId;
    private final Set<Relationship> relationships;
    private final Legend legend;
    private final SheetSettings settings;
    private long modificationTime;
    private String modifiedBy;
    private final MarkerRefCounterProxy markerRefCounter;
    private final LabelRefCounterProxy labelRefCounter;

    public Sheet(Workbook ownerWorkbook, String id, boolean bare) {
        this.ownerWorkbook = ownerWorkbook;
        this.id = id;
        this.orphan = true;
        this.titleText = null;
        this.rootTopic = null;
        this.styleId = null;
        this.themeId = null;
        this.relationships = new HashSet<Relationship>();
        this.legend = new Legend(this);
        this.settings = new SheetSettings(this);
        this.modifiedBy = null;
        this.modificationTime = 0L;
        this.markerRefCounter = new MarkerRefCounterProxy(ownerWorkbook, this);
        this.labelRefCounter = new LabelRefCounterProxy(ownerWorkbook, this);
        if (!bare) {
            this.replaceRootTopic(ownerWorkbook.createTopic());
        }
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownerWorkbook.getCoreEventSupport();
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.ownerWorkbook.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public String getId() {
        return this.id;
    }

    public void setTitleText(String titleText) {
        String oldTitleText = this.titleText;
        if (oldTitleText == titleText || oldTitleText != null && oldTitleText.equals(titleText)) {
            return;
        }
        this.titleText = titleText;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "titleText", (Object)oldTitleText, (Object)titleText);
    }

    public String getTitleText() {
        return this.titleText == null ? "" : this.titleText;
    }

    public boolean hasTitle() {
        return this.titleText != null;
    }

    public Workbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (ITopic.class.equals(adapter)) {
            return adapter.cast(this.getRootTopic());
        }
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (IMarkerRefCounter.class.equals(adapter)) {
            return adapter.cast(this.markerRefCounter);
        }
        if (ILabelRefCounter.class.equals(adapter)) {
            return adapter.cast(this.labelRefCounter);
        }
        return null;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        String oldStyleId = this.styleId;
        if (styleId == oldStyleId || styleId != null && styleId.equals(oldStyleId)) {
            return;
        }
        this.styleId = styleId;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "style", (Object)oldStyleId, (Object)styleId);
    }

    public String getStyleType() {
        return "map";
    }

    public long getModifiedTime() {
        return this.modificationTime;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public ITopic getRootTopic() {
        return this.rootTopic;
    }

    public void replaceRootTopic(ITopic rootTopic) {
        if (rootTopic == null || !(rootTopic instanceof Topic) || rootTopic.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        Topic newRootTopic = (Topic)rootTopic;
        Topic oldRootTopic = this.rootTopic;
        if (newRootTopic == oldRootTopic || newRootTopic != null && newRootTopic.equals(oldRootTopic)) {
            return;
        }
        if (oldRootTopic != null) {
            if (!this.isOrphan()) {
                oldRootTopic.onOrphan();
            }
            oldRootTopic.setParent(null, null, null);
        }
        this.rootTopic = newRootTopic;
        if (newRootTopic != null) {
            newRootTopic.setParent(this, null, "root");
            if (!this.isOrphan()) {
                newRootTopic.onParented();
            }
        }
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "rootTopic", (Object)oldRootTopic, (Object)rootTopic);
    }

    public int getIndex() {
        return this.orphan ? -1 : this.ownerWorkbook.getSheets().indexOf(this);
    }

    public IWorkbook getParent() {
        return this.isOrphan() ? null : this.ownerWorkbook;
    }

    public Set<IRelationship> getRelationships() {
        return Collections.unmodifiableSet(this.relationships);
    }

    public void addRelationship(IRelationship relationship) {
        if (relationship == null || !(relationship instanceof Relationship) || relationship.getOwnedWorkbook() != this.ownerWorkbook) {
            throw new IllegalArgumentException();
        }
        Relationship r = (Relationship)relationship;
        if (!this.relationships.add(r)) {
            return;
        }
        r.setParent(this);
        if (!this.isOrphan()) {
            r.onParented();
        }
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "relationshipAdd", (Object)r);
    }

    public void removeRelationship(IRelationship relationship) {
        if (relationship == null || !(relationship instanceof Relationship) || relationship.getOwnedWorkbook() != this.ownerWorkbook) {
            throw new IllegalArgumentException();
        }
        Relationship r = (Relationship)relationship;
        if (!this.relationships.contains(r)) {
            return;
        }
        if (!this.isOrphan()) {
            r.onOrphan();
        }
        r.setParent(null);
        this.relationships.remove(r);
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "relationshipRemove", (Object)r);
    }

    public IStyle getTheme() {
        return this.themeId == null ? null : this.getOwnedWorkbook().getStyleSheet().findStyle(this.themeId);
    }

    public String getThemeId() {
        return this.themeId;
    }

    public void setThemeId(String themeId) {
        String oldThemeId = this.themeId;
        if (themeId == oldThemeId || themeId != null && themeId.equals(oldThemeId)) {
            return;
        }
        this.themeId = themeId;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "themeId", (Object)oldThemeId, (Object)themeId);
    }

    public ILegend getLegend() {
        return this.legend;
    }

    public ISheetSetting getSetting() {
        throw new UnsupportedOperationException();
    }

    public ISheetSettings getSettings() {
        return this.settings;
    }

    protected void onParented() {
        this.orphan = false;
        this.ownerWorkbook.getObjectRegistry().register(this);
        if (this.rootTopic != null) {
            this.rootTopic.onParented();
        }
        for (Relationship r : this.relationships) {
            r.onParented();
        }
        this.settings.onParented();
    }

    protected void onOrphan() {
        this.settings.onOrphan();
        for (Relationship r : this.relationships) {
            r.onOrphan();
        }
        if (this.rootTopic != null) {
            this.rootTopic.onOrphan();
        }
        this.ownerWorkbook.getObjectRegistry().unregister((IIdentifiable)this);
        this.orphan = true;
    }
}

