/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.brainstorm.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.ui.internal.brainstorm.BrainstormMessages;
import org.xmind.ui.util.MindMapUtils;

public class SortMenu
extends MenuManager
implements ISelectionAction {
    private IGraphicalViewer viewer;

    public SortMenu(IGraphicalViewer viewer) {
        super(BrainstormMessages.SortMenu_Sort, "org.xmind.ui.brainstorm.sortMenu");
        this.viewer = viewer;
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SortMenu.this.fillMenu();
            }
        });
    }

    private void fillMenu() {
        this.add((IAction)new SortAction("org.xmind.ui.sort_title"));
        this.add((IAction)new SortAction("org.xmind.ui.sort_priority"));
        this.add((IAction)new SortAction("org.xmind.ui.sort_modified"));
    }

    public void setSelection(ISelection selection) {
        this.setVisible(MindMapUtils.isSingleTopic((ISelection)selection));
    }

    private class SortAction
    extends Action {
        private String sortId;

        public SortAction(String sortId) {
            this.sortId = sortId;
            if ("org.xmind.ui.sort_title".equals(sortId)) {
                this.setId("org.xmind.ui.sort_title");
                this.setText(BrainstormMessages.SortByTitle_text);
                this.setToolTipText(BrainstormMessages.SortByTitle_toolTip);
            } else if ("org.xmind.ui.sort_priority".equals(sortId)) {
                this.setId("org.xmind.ui.sort_priority");
                this.setText(BrainstormMessages.SortByPriority_text);
                this.setToolTipText(BrainstormMessages.SortByPriority_toolTip);
            } else if ("org.xmind.ui.sort_modified".equals(sortId)) {
                this.setId("org.xmind.ui.sort_modified");
                this.setText(BrainstormMessages.SortByModifiedTime_text);
                this.setToolTipText(BrainstormMessages.SortByModifiedTime_toolTip);
            }
        }

        public void run() {
            if (SortMenu.this.viewer == null) {
                return;
            }
            EditDomain domain = SortMenu.this.viewer.getEditDomain();
            if (domain == null) {
                return;
            }
            domain.handleRequest(new Request("sort").setViewer((IViewer)SortMenu.this.viewer).setParameter("comparand", (Object)this.sortId));
        }
    }
}

