/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.xmind.core.net.IDataStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyStore
implements IDataStore {
    private Properties properties;

    public PropertyStore(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean has(String key) {
        return this.properties.containsKey(key);
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.properties.getProperty(key));
    }

    public long getLong(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception exception) {}
        }
        return 0L;
    }

    public int getInt(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    public double getDouble(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception exception) {}
        }
        return 0.0;
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object key : this.properties.keySet()) {
            map.put(key, this.properties.get(key));
        }
        return map;
    }

    public List<IDataStore> getChildren(String key) {
        return EMPTY.getChildren(key);
    }
}

