/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.search.workbooks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.resource.ImageDescriptor;
import org.xmind.ui.internal.search.workbooks.ISearchResultItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SearchResultItem
implements ISearchResultItem {
    private static final Collection<ISearchResultItem> EMPTY_CHILDREN = Collections.emptySet();
    private ISearchResultItem parent;
    private Object object;
    private String title;
    private int[] highlights;
    private Collection<ISearchResultItem> children;
    private String description;
    private String text;
    private ImageDescriptor imageDescriptor;

    public SearchResultItem(ISearchResultItem parent, Object object) {
        this.parent = parent;
        this.object = object;
    }

    @Override
    public void addChild(ISearchResultItem child) {
        if (this.children == null) {
            this.children = new ArrayList<ISearchResultItem>();
        }
        this.children.add(child);
    }

    @Override
    public Collection<ISearchResultItem> getChildren() {
        return this.children == null ? EMPTY_CHILDREN : this.children;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int[] getHighlights() {
        return this.highlights;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public ISearchResultItem getParent() {
        return this.parent;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    protected void setDescription(String description) {
        this.description = description;
        this.updateText();
    }

    protected void setHighlights(int[] highlights) {
        this.highlights = highlights;
    }

    protected void setTitle(String title) {
        this.title = title;
        this.updateText();
    }

    protected void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    private void updateText() {
        this.text = this.title != null && this.description != null ? String.valueOf(this.title) + " " + this.description : (this.title == null ? this.description : this.title);
    }

    @Override
    public boolean reveal() {
        return this.reveal(this);
    }

    protected boolean reveal(ISearchResultItem item) {
        if (this.getParent() != null) {
            return ((SearchResultItem)this.getParent()).reveal(item);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SearchResultItem)) {
            return false;
        }
        SearchResultItem that = (SearchResultItem)obj;
        return this.object == that.object || this.object != null && this.object.equals(that.object);
    }

    public String toString() {
        return this.text;
    }
}

