/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.RGB;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerVariation;
import org.xmind.ui.internal.svgsupport.SVGImageData;
import org.xmind.ui.internal.svgsupport.SVGReference;
import org.xmind.ui.resources.ImageUtils;
import org.xmind.ui.util.Logger;

public class MarkerImageDescriptor
extends ImageDescriptor {
    public static final String RESOURCE_URL_PREFIX = "platform:/plugin/org.xmind.ui.resources/markers/";
    private static ImageDescriptor ErrorImage = null;
    private IMarker marker;
    private IMarkerRef markerRef;
    private String markerId;
    private RGB background;
    private boolean createByStream = true;
    private int maxWidth;
    private int maxHeigh;

    protected MarkerImageDescriptor(IMarker marker, int maxWidth, int maxHeigh) {
        this.marker = marker;
        this.markerRef = null;
        this.markerId = marker.getId();
        this.maxWidth = maxWidth;
        this.maxHeigh = maxHeigh;
    }

    protected MarkerImageDescriptor(IMarkerRef markerRef, int maxWidth, int maxHeigh) {
        this.marker = null;
        this.markerRef = markerRef;
        this.markerId = markerRef.getMarkerId();
        this.maxWidth = maxWidth;
        this.maxHeigh = maxHeigh;
    }

    public Image createImage(boolean returnMissingImageOnError, Device device) {
        Image image = null;
        try {
            image = new Image(device, new ImageDataProvider(){

                public ImageData getImageData(int zoom) {
                    return MarkerImageDescriptor.this.getImageData(zoom);
                }
            });
        }
        catch (SWTException e) {
            if (e.code != 40) {
                throw e;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (image == null && returnMissingImageOnError) {
            try {
                image = new Image(device, DEFAULT_IMAGE_DATA);
            }
            catch (SWTException sWTException) {
                return null;
            }
        }
        return image;
    }

    public ImageData getImageData() {
        boolean createImageDataByStream;
        String svgPath = this.getMarker() == null ? null : this.getMarker().getSVGPath();
        boolean bl = createImageDataByStream = this.createByStream || svgPath == null || "".equals(svgPath);
        if (createImageDataByStream) {
            return this.createImageDataByStream(100);
        }
        return this.createImageDataBySVG(100);
    }

    private ImageData getImageData(int zoom) {
        if (zoom > 100) {
            boolean createImageDataByStream;
            String svgPath = this.getMarker() == null ? null : this.getMarker().getSVGPath();
            boolean bl = createImageDataByStream = this.createByStream || svgPath == null || "".equals(svgPath);
            if (createImageDataByStream) {
                return this.createImageDataByStream(200);
            }
            return this.createImageDataBySVG(200);
        }
        return this.getImageData();
    }

    private ImageData createImageDataBySVG(int zoom) {
        int width = zoom / 100 * this.maxWidth;
        int height = zoom / 100 * this.maxHeigh;
        String filePath = RESOURCE_URL_PREFIX + this.getMarker().getSVGPath();
        SVGImageData data = new SVGReference(filePath).getSVGData();
        return data.createImage(new Dimension(width, height), this.background);
    }

    private ImageData createImageDataByStream(int zoom) {
        ImageData result;
        block13: {
            InputStream in = this.getStream(zoom);
            result = null;
            if (in != null) {
                try {
                    try {
                        result = new ImageData(in);
                        result = this.performScale(result);
                    }
                    catch (SWTException e) {
                        Logger.log(e, "Unable to create image from marker: [" + this.markerId + "] " + (this.marker != null ? this.marker.getResourcePath() : ""));
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (result == null) {
            result = MarkerImageDescriptor.getErrorImage().getImageData();
        }
        return result;
    }

    private ImageData performScale(ImageData result) {
        if (this.maxWidth >= 0 || this.maxHeigh >= 0) {
            boolean shouldScaleHeight;
            double hScale = (double)result.width / (double)this.maxWidth;
            double vScale = (double)result.height / (double)this.maxHeigh;
            boolean shouldScaleWidth = hScale > 1.0;
            boolean bl = shouldScaleHeight = vScale > 1.0;
            if (shouldScaleWidth || shouldScaleHeight) {
                int h;
                int w;
                if (hScale > vScale) {
                    w = this.maxWidth;
                    h = (int)((double)result.height / hScale);
                    if (h == 0) {
                        h = 1;
                    }
                } else {
                    w = (int)((double)result.width / vScale);
                    h = this.maxHeigh;
                    if (w == 0) {
                        w = 1;
                    }
                }
                result = result.scaledTo(w, h);
            }
        }
        return result;
    }

    private IMarker getMarker() {
        if (this.marker == null && this.markerRef != null) {
            return this.markerRef.getMarker();
        }
        return this.marker;
    }

    private InputStream getStream(int zoom) {
        IMarker m = this.getMarker();
        if (m == null) {
            return null;
        }
        IMarkerResource res = m.getResource();
        if (res == null) {
            return null;
        }
        IMarkerVariation variation = this.getMarkerVariation(res);
        InputStream in = null;
        try {
            if (variation == null) {
                in = res.openInputStream(zoom);
            } else {
                in = res.openInputStream(variation, zoom);
                if (in == null) {
                    in = res.openInputStream(zoom);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (in == null) {
            return null;
        }
        return new BufferedInputStream(in);
    }

    private IMarkerVariation getMarkerVariation(IMarkerResource res) {
        for (IMarkerVariation variation : res.getVariations()) {
            if (!variation.isApplicable(this.maxWidth, this.maxHeigh)) continue;
            return variation;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MarkerImageDescriptor)) {
            return false;
        }
        MarkerImageDescriptor that = (MarkerImageDescriptor)((Object)obj);
        if (!(this.maxWidth < 0 ? that.maxWidth < 0 : this.maxWidth == that.maxWidth) || (this.maxHeigh < 0 ? that.maxHeigh >= 0 : this.maxHeigh != that.maxHeigh)) {
            return false;
        }
        IMarker thisMarker = this.getMarker();
        return thisMarker != null && thisMarker.equals(that.getMarker());
    }

    public int hashCode() {
        return this.markerId.hashCode();
    }

    public String toString() {
        return "MarkerImageDescriptor(marker=" + this.markerId + ")";
    }

    private static ImageDescriptor getErrorImage() {
        if (ErrorImage == null) {
            ErrorImage = ImageUtils.createErrorImage((int)16, (int)16);
        }
        return ErrorImage;
    }

    public static ImageDescriptor createFromMarker(IMarker marker) {
        if (marker == null) {
            return MarkerImageDescriptor.getErrorImage();
        }
        return new MarkerImageDescriptor(marker, -1, -1);
    }

    public static ImageDescriptor createFromMarkerRef(IMarkerRef markerRef) {
        if (markerRef == null) {
            return MarkerImageDescriptor.getErrorImage();
        }
        return new MarkerImageDescriptor(markerRef, -1, -1);
    }

    public static ImageDescriptor createFromMarker(IMarker marker, int maxWidth, int maxHeigh) {
        if (marker == null) {
            return MarkerImageDescriptor.getErrorImage();
        }
        return new MarkerImageDescriptor(marker, maxWidth, maxHeigh);
    }

    public static ImageDescriptor createFromMarker(IMarker marker, int maxWidth, int maxHeigh, RGB background) {
        MarkerImageDescriptor descriptor = (MarkerImageDescriptor)MarkerImageDescriptor.createFromMarker(marker, maxWidth, maxHeigh);
        descriptor.setBackground(background);
        return descriptor;
    }

    public static ImageDescriptor createFromMarker(IMarker marker, int maxWidth, int maxHeigh, boolean createByStream) {
        if (createByStream) {
            return MarkerImageDescriptor.createFromMarker(marker, maxWidth, maxHeigh);
        }
        MarkerImageDescriptor descriptor = (MarkerImageDescriptor)MarkerImageDescriptor.createFromMarker(marker, maxWidth, maxHeigh);
        descriptor.setCreateByStream(createByStream);
        return descriptor;
    }

    public static ImageDescriptor createFromMarkerRef(IMarkerRef markerRef, int maxWidth, int maxHeigh) {
        if (markerRef == null) {
            return MarkerImageDescriptor.getErrorImage();
        }
        return new MarkerImageDescriptor(markerRef, maxWidth, maxHeigh);
    }

    private void setBackground(RGB background) {
        this.background = background;
    }

    private void setCreateByStream(boolean createByStream) {
        this.createByStream = createByStream;
    }
}

