/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.wizards.HtmlExporter;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.DocumentExportPageBase;
import org.xmind.ui.wizards.DocumentExportWizard;
import org.xmind.ui.wizards.IExporter;

public class HtmlExportWizard
extends DocumentExportWizard {
    private static final String DIALOG_SETTINGS_SECTION_ID = "org.xmind.ui.export.html";
    private static final String HTML_EXPORT_PAGE_NAME = "htmlExportPage";
    private static final List<String> EXTENSIONS = Arrays.asList(".html", ".htm");
    private static final String FILTER_HTML = "*.html;*.htm";
    private HtmlExportPage page;

    public HtmlExportWizard() {
        this.setWindowTitle(WizardMessages.HtmlExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(DIALOG_SETTINGS_SECTION_ID));
    }

    @Override
    protected void addValidPages() {
        this.page = new HtmlExportPage();
        this.addPage((IWizardPage)this.page);
    }

    @Override
    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    @Override
    protected IExporter createExporter() {
        IMindMap mindmap = this.getSourceMindMap();
        ITopic centralTopic = mindmap.getCentralTopic();
        ISheet sheet = mindmap.getSheet();
        HtmlExporter exporter = new HtmlExporter(sheet, centralTopic, this.getTargetPath(), centralTopic.getTitleText());
        exporter.setDialogSettings(this.getDialogSettings());
        exporter.init();
        return exporter;
    }

    @Override
    protected String getFormatName() {
        return WizardMessages.HtmlExportWizard_formatName;
    }

    @Override
    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && EXTENSIONS.contains(extension.toLowerCase());
    }

    @Override
    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + EXTENSIONS.get(0);
    }

    @Override
    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ExportToHtmlCount");
        super.doExport(monitor, display, parentShell);
    }

    private class HtmlExportPage
    extends DocumentExportPageBase {
        public HtmlExportPage() {
            super(HtmlExportWizard.HTML_EXPORT_PAGE_NAME, WizardMessages.HtmlExportPage_title);
            this.setDescription(WizardMessages.HtmlExportPage_description);
        }

        @Override
        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, WizardMessages.HtmlExportPage_FileDialog_HTMLFile);
            filterExtensions.add(0, HtmlExportWizard.FILTER_HTML);
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }
    }
}

