/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.internal.AttachmentImageDescriptor;
import org.xmind.ui.internal.views.InspectorSection;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.viewers.ImageListViewer;

public class ImageInspectorSection2
extends InspectorSection
implements ICoreEventListener {
    private static final String FILE_PROTOCOL = "file";
    private ICoreEventRegister register;
    private ImageListViewer list;
    List<ITopic> topicsWithImage;
    private List<ITopic> allTopics;

    public ImageInspectorSection2() {
        this.setTitle(NLS.bind((String)Messages.ImageInspectorSection_title, (Object)0));
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite composite = super.createContent(parent);
        this.list = new ImageListViewer(composite, 16);
        this.list.setContentProvider((IContentProvider)new InspectorSection.InspectorContentProvider(this));
        this.list.setLabelProvider((IBaseLabelProvider)new InspectorSection.InspectorLabelProvider(this));
        this.list.getControl().addListener(16, new Listener(){

            public void handleEvent(Event event) {
                ImageInspectorSection2.this.list.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        });
        return composite;
    }

    @Override
    protected void refreshImageList() {
        if (this.list == null || this.list.getControl() == null) {
            return;
        }
        if (this.list.getInput() != this.getContributingViewer()) {
            this.list.setInput((Object)this.getContributingViewer());
        }
        this.list.refresh();
        if (this.topicsWithImage != null) {
            this.setTitle(NLS.bind((String)Messages.ImageInspectorSection_title, (Object)this.topicsWithImage.size()));
        } else {
            this.setTitle(NLS.bind((String)Messages.ImageInspectorSection_title, (Object)0));
        }
        this.reflow();
    }

    @Override
    protected Object[] getAllPropertyContents(IGraphicalViewer viewer) {
        List<ITopic> topicsWithImage = null;
        List<ITopic> allTopics = null;
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet != null) {
            allTopics = this.getAllTopics();
            topicsWithImage = this.getTopicsWithImage(allTopics);
        }
        this.setLabelRef(topicsWithImage, allTopics);
        if (topicsWithImage != null) {
            return topicsWithImage.toArray();
        }
        return new Object[0];
    }

    private void setLabelRef(List<ITopic> topicsWithImage, List<ITopic> allTopics) {
        if (topicsWithImage == this.topicsWithImage && allTopics == this.allTopics) {
            return;
        }
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.topicsWithImage = topicsWithImage;
        this.allTopics = allTopics;
        if (allTopics != null) {
            this.register = new CoreEventRegister((Object)this.getCurrentWorkbook(), (ICoreEventListener)this);
            this.register.register("modifyTime");
        }
    }

    private List<ITopic> getTopicsWithImage(List<ITopic> all) {
        ArrayList<ITopic> topics = null;
        for (ITopic topic : all) {
            if (!this.hasImage(topic)) continue;
            if (topics == null) {
                topics = new ArrayList<ITopic>();
            }
            topics.add(topic);
        }
        return topics;
    }

    private boolean hasImage(ITopic topic) {
        return topic.getImage().getSource() != null;
    }

    @Override
    protected String getPropertyInspectorText(Object element) {
        return super.getPropertyInspectorText(element);
    }

    @Override
    protected Image getPropertyInspectorImage(Object element) {
        String source;
        if (element instanceof ITopic && (source = ((ITopic)element).getImage().getSource()) != null) {
            return this.getImage((ITopic)element, source);
        }
        return null;
    }

    private Image getImage(ITopic topic, String source) {
        ImageDescriptor imageDescriptor = null;
        if (HyperlinkUtils.isAttachmentURL((String)source)) {
            String path = HyperlinkUtils.toAttachmentPath((String)source);
            imageDescriptor = AttachmentImageDescriptor.createFromEntryPath(topic.getOwnedWorkbook(), path);
        } else {
            URL url = this.checkFileURL(source);
            if (url != null) {
                imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            }
        }
        if (imageDescriptor != null) {
            return imageDescriptor.createImage();
        }
        return null;
    }

    private URL checkFileURL(String source) {
        try {
            URL url = new URL(source);
            if (FILE_PROTOCOL.equalsIgnoreCase(url.getProtocol())) {
                return url;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    public void handleCoreEvent(CoreEvent event) {
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ImageInspectorSection2.this.refresh();
            }
        });
    }

    @Override
    protected void handleDispose() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
    }
}

