/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.gallery.ILabelDecorator;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.TemplateGroup;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;
import org.xmind.ui.internal.wizards.TemplateLabelProvider;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.ITemplateGroup;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.FloatingTextEditor;

public class TemplateResourceManagerViewer
extends ResourceManagerViewer {
    private static final int FRAME_WIDTH = 132;
    private static final int FRAME_HEIGHT = 72;
    private Font font;

    @Override
    public void createControl(Composite container) {
        super.createControl(container);
        this.font = container.getFont();
        this.setContentProvider((IContentProvider)new TemplateCategorizedContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TemplateCategorizedLabelProvider());
        EditDomain domain = new EditDomain();
        domain.installTool("select tool", (ITool)new ResourceManagerViewer.ResourceCategorizedSelectTool());
        this.setEditDomain(domain);
        this.initProperties();
        this.createControl(container, 64);
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setInput(TemplateGalleryCore.getInstance());
    }

    @Override
    protected void initProperties() {
        super.initProperties();
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(132, 72));
    }

    @Override
    protected void initNestedGalleryViewer(GalleryViewer galleryViewerer) {
        super.initNestedGalleryViewer(galleryViewerer);
        galleryViewerer.getEditDomain().installTool("edit tool", (ITool)new TemplateNameEditTool());
    }

    public void startEditing(ITemplate template) {
        Object input = this.getInput();
        if (input instanceof TemplateGalleryCore) {
            List groups = this.getCategories();
            for (ITemplateGroup group : groups) {
                if (!group.getTemplates().contains(template)) continue;
                GalleryViewer galleryViewer = this.getNestedViewer(group);
                EditDomain domain = galleryViewer.getEditDomain();
                ITool tool = domain.getDefaultTool();
                ((GallerySelectTool)tool).getStatus().setStatus(1, true);
                domain.handleRequest("edit", (IViewer)galleryViewer);
                break;
            }
        }
    }

    private boolean modifyTemplateName(ITemplate template, String newName) {
        if (template == null || newName == null || newName.equals("") || newName.equals(template.getName())) {
            return false;
        }
        List<ITemplate> userTemplates = MindMapUI.getResourceManager().getUserTemplates();
        for (ITemplate t : userTemplates) {
            if (!newName.equals(t.getName())) continue;
            return false;
        }
        URI uri = template.getSourceWorkbookURI();
        File sourceFile = URIUtil.toFile((URI)uri);
        String newPath = String.valueOf(sourceFile.getParent()) + System.getProperty("file.separator") + newName + FileUtils.getExtension((String)sourceFile.getAbsolutePath());
        sourceFile.renameTo(new File(newPath));
        ((TemplateCategorizedLabelProvider)this.getLabelProvider()).fireLabelProviderChanged(new LabelProviderChangedEvent(this.getLabelProvider(), (Object)template));
        return true;
    }

    protected GalleryViewer createNestedViewer() {
        return new TemplateGalleryViewer();
    }

    private static class TemplateCategorizedContentProvider
    implements ITreeContentProvider {
        private TemplateCategorizedContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TemplateGalleryCore) {
                return ((TemplateGalleryCore)inputElement).getElements().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TemplateGalleryCore) {
                return ((TemplateGalleryCore)parentElement).getElements().toArray();
            }
            if (parentElement instanceof ITemplateGroup) {
                return ((ITemplateGroup)parentElement).getTemplates().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            TemplateGalleryCore templatesGalleryCore = TemplateGalleryCore.getInstance();
            if (element instanceof ITemplate) {
                for (ITemplateGroup group : templatesGalleryCore.getElements()) {
                    if (!group.getTemplates().contains(element)) continue;
                    return group;
                }
            } else if (element instanceof List) {
                return TemplateGalleryCore.getInstance();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof List || element instanceof TemplateGalleryCore;
        }
    }

    private class TemplateCategorizedLabelProvider
    extends TemplateLabelProvider
    implements ILabelDecorator,
    IFontProvider {
        private TemplateCategorizedLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof ITemplateGroup) {
                return ((ITemplateGroup)element).getName();
            }
            return super.getText(element);
        }

        public IFigure decorateFigure(IFigure figure, Object element, IDecorationContext context) {
            List children = figure.getChildren();
            boolean needInitFigureContent = children.isEmpty();
            if (needInitFigureContent) {
                SizeableImageFigure contentFigure = new SizeableImageFigure(this.getImage(element));
                figure.add((IFigure)contentFigure);
                if (context != null) {
                    figure.setLayoutManager((LayoutManager)new ResourceManagerViewer.Layout(context));
                    boolean imageConstrained = Boolean.TRUE.equals(context.getProperty("constrained", (Object)false));
                    boolean imageStretched = Boolean.TRUE.equals(context.getProperty("stretched", (Object)false));
                    contentFigure.setConstrained(imageConstrained);
                    contentFigure.setStretched(imageStretched);
                }
            }
            return figure;
        }

        protected void fireLabelProviderChanged(LabelProviderChangedEvent event) {
            super.fireLabelProviderChanged(event);
            TemplateResourceManagerViewer.this.refresh();
        }

        public Font getFont(Object element) {
            FontData fontData = TemplateResourceManagerViewer.this.font.getFontData()[0];
            if (Util.isMac()) {
                fontData.setHeight(12);
            } else {
                fontData.setHeight(9);
            }
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData)fontData);
            return TemplateResourceManagerViewer.this.getResourceManager().createFont(fontDescriptor);
        }
    }

    static class TemplateGalleryCore {
        static final String SYSTEM_GROUP_NAME = MindMapMessages.TemplateResourceManagerViewer_SystemGroup_name;
        static final String USER_GROUP_NAME = MindMapMessages.TemplateResourceManagerViewer_UserGroup_name;
        private static TemplateGalleryCore instance = new TemplateGalleryCore();
        List<ITemplateGroup> groups = new ArrayList<ITemplateGroup>();

        public static TemplateGalleryCore getInstance() {
            return instance;
        }

        private TemplateGalleryCore() {
        }

        public List<ITemplateGroup> getElements() {
            this.groups.clear();
            IResourceManager resourceManager = MindMapUI.getResourceManager();
            this.groups.addAll(resourceManager.getSystemTemplateGroups());
            TemplateGroup userGroup = new TemplateGroup(USER_GROUP_NAME, resourceManager.getUserTemplates());
            if (!userGroup.getTemplates().isEmpty()) {
                this.groups.add(userGroup);
            }
            return this.groups;
        }

        public ITemplateGroup getGroupByName(String name) {
            for (ITemplateGroup group : this.groups) {
                if (!group.getName().equals(name)) continue;
                return group;
            }
            return null;
        }
    }

    private class TemplateGalleryViewer
    extends GalleryViewer {
        private TemplateGalleryViewer() {
        }

        protected boolean isTitleEditable(IPart p) {
            List<ITemplate> userTemplates = MindMapUI.getResourceManager().getUserTemplates();
            return userTemplates.contains(p.getModel());
        }
    }

    private class TemplateNameEditTool
    extends GalleryEditTool {
        private TemplateNameEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((ITemplate)source.getModel()).getName());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            ITemplate template = (ITemplate)source.getModel();
            if (template != null) {
                TemplateResourceManagerViewer.this.modifyTemplateName(template, document.get());
            }
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            this.getHelper().setPrefWidth(132);
        }
    }
}

