/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.tabfolder.MTabFolder;
import org.xmind.ui.tabfolder.MTabItem;
import org.xmind.ui.util.IStyleProvider;

public class ResourceManagerStyleProvider
implements IStyleProvider {
    private ResourceManager resourceManager;
    private Map<String, RGB> keyToRGB = new HashMap<String, RGB>();

    public ResourceManagerStyleProvider(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public Color getColor(Object widget, String key) {
        String defaultValue = null;
        if (widget instanceof MTabItem) {
            MTabItem item = (MTabItem)widget;
            if ("fill".equals(key) && (item.isSelected() || item.isPreselected())) {
                defaultValue = "#008EFC";
            } else if ("text".equals(key)) {
                defaultValue = item.isSelected() ? "#FFFFFF" : "#000000";
            }
        } else if (widget instanceof MTabFolder) {
            if ("tabBar".equals(key)) {
                defaultValue = "#FFFFFF";
            }
            if ("body".equals(key)) {
                defaultValue = "#F2F2F2";
            }
        }
        if (defaultValue != null) {
            RGB rgb = ColorUtils.toRGB(defaultValue);
            return (Color)this.resourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)rgb));
        }
        return null;
    }

    public int getAlpha(Object widget, String key, int defaultValue) {
        if (widget instanceof MTabItem) {
            MTabItem item = (MTabItem)widget;
            if ("fill".equals(key)) {
                if (item.isSelected()) {
                    return 255;
                }
                if (item.isPreselected()) {
                    return 19;
                }
            }
        }
        return defaultValue;
    }

    public Font getFont(Object widget, String key) {
        int fontHeight = Util.isMac() ? 12 : 8;
        if (widget instanceof MTabItem && "text".equals(key)) {
            return (Font)this.resourceManager.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().setHeight(fontHeight));
        }
        return null;
    }

    public int getWidth(Object widget, String key, int defaultValue) {
        if (widget instanceof MTabItem) {
            if ("image".equals(key)) {
                return 26;
            }
            if ("margin".equals(key)) {
                return 17;
            }
            if ("separator".equals(key)) {
                return 2;
            }
            if (key == null) {
                return 131;
            }
        }
        return defaultValue;
    }

    public int getHeight(Object widget, String key, int defaultValue) {
        if (widget instanceof MTabItem) {
            if ("image".equals(key)) {
                return 26;
            }
            if ("margin".equals(key)) {
                return 10;
            }
            if ("separator".equals(key)) {
                return 2;
            }
            if (key == null) {
                return 46;
            }
        }
        return defaultValue;
    }

    public int getPosition(Object widget, String key, int defaultValue) {
        if (widget instanceof MTabItem && "text".equals(key)) {
            return 131072;
        }
        if (widget instanceof MTabFolder && "tabBar".equals(key)) {
            return 16384;
        }
        return defaultValue;
    }

    public int getTextAlign(Object widget, String key, int defaultValue) {
        if (widget instanceof MTabItem && "textAlign".equals(key)) {
            return 16384;
        }
        return defaultValue;
    }

    public void setColor(String key, RGB value) {
        this.keyToRGB.put(key, value);
    }

    public boolean getVisibility(Object widget, String key, boolean defaultValue) {
        return defaultValue;
    }
}

