/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.print.multipage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.print.PrintConstants;
import org.xmind.ui.internal.print.PrintUtils;
import org.xmind.ui.internal.print.multipage.DialogSettingsDecorator;
import org.xmind.ui.internal.print.multipage.MultipageImagePreviewViewer;
import org.xmind.ui.internal.print.multipage.PrintDialogLayout;
import org.xmind.ui.internal.print.multipage.PrintMultipagePreviewImageCreator;
import org.xmind.ui.internal.print.multipage.PrintMultipageUtils;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.UnitConvertor;
import org.xmind.ui.viewers.SWTUtils;

public class MultipageSetupDialog
extends TrayDialog {
    private static final String SECTION_ID = "org.xmind.ui.print.multiPageSetupDialog";
    private static final int PREVIEW_DELAY = 1000;
    private static final int HIDE_DETAIL_ID = 2;
    private Display display;
    private IGraphicalEditorPage page;
    private IMindMap sourceMindMap;
    private IDialogSettings settings;
    private Composite leftButtonBar;
    private Button hideDetailsButton;
    private Label contentSectionLabel;
    private Composite contentSectionComposite;
    private Button currentMapRadio;
    private Button wholeWorkbookRadio;
    private Button backgroundCheck;
    private Button borderCheck;
    private Button showPlusCheck;
    private Button showMinusCheck;
    private Button landscapeRadio;
    private Button portraitRadio;
    private Map<String, Text> inputControls;
    private Combo unitChooser;
    private Map<String, IAction[]> actions;
    private Combo pagesChooser;
    private Composite multipageComposite;
    private Spinner widthPages;
    private Spinner heightPages;
    private Button pageLockCheck;
    private List<Control> hideControls = new ArrayList<Control>();
    private PrintMultipagePreviewImageCreator previewImageCreator;
    private GeneratePreviewJob generatePreviewJob;
    private MultipageImagePreviewViewer viewer;
    private boolean updating = false;
    private boolean modifyingText = false;
    private boolean isRefreshingPages = false;
    private ResourceManager resources;
    private Listener eventHandler = new Listener(){

        public void handleEvent(Event event) {
            MultipageSetupDialog.this.handleWidgetEvent(event);
        }
    };

    public MultipageSetupDialog(Shell parentShell, IGraphicalEditorPage page, IMindMap sourceMindMap) {
        super(parentShell);
        this.display = Display.getCurrent();
        this.page = page;
        this.sourceMindMap = sourceMindMap;
        this.settings = new DialogSettingsDecorator(MindMapUIPlugin.getDefault().getDialogSettings(SECTION_ID));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)newShell);
        newShell.setText(DialogMessages.PageSetupDialog_windowTitle);
    }

    public void create() {
        super.create();
        this.update(null);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getSettings();
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    public IDialogSettings getSettings() {
        return this.settings;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite1 = new Composite(parent, 0);
        composite1.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 0;
        composite1.setLayout((Layout)layout2);
        this.leftButtonBar = new Composite(composite1, 0);
        this.leftButtonBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout3 = new GridLayout(0, false);
        layout3.marginWidth = 12;
        layout3.marginHeight = 0;
        this.leftButtonBar.setLayout((Layout)layout3);
        Composite composite = new Composite(composite1, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(131072, 0x1000000, false, false);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.hideDetailsButton = this.createButton(this.leftButtonBar, 2, MindMapMessages.MultipageSetupDialog_HideDetails, false);
        this.hookWidget((Widget)this.hideDetailsButton, 13);
        super.createButtonsForButtonBar(parent);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = IDialogConstants.NEXT_LABEL;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void setButtonLayoutData(Button button) {
        if ((Integer)button.getData() == 2) {
            GridData data = new GridData(16384, 0x1000000, true, false);
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            org.eclipse.swt.graphics.Point minSize = button.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minSize.x);
            button.setLayoutData((Object)data);
        } else {
            super.setButtonLayoutData(button);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        PrintDialogLayout layout = new PrintDialogLayout(this.settings);
        layout.marginWidth = 20;
        layout.marginHeight = 20;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 20;
        container.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.minimumWidth = 510;
        container.setLayoutData((Object)layoutData);
        this.createSettingsPart(container);
        this.createPreviewPart(container);
        return container;
    }

    private void createSettingsPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        this.creatContentSection(composite);
        this.createPageSetupSection(composite);
        this.createShowPlusMinusIconsSection(composite);
        this.createOrientationSection(composite);
        this.createMarginsSection(composite);
        this.createHeaderFooterSection(composite);
        this.createPagesSection(composite);
    }

    private void creatContentSection(Composite parent) {
        this.contentSectionLabel = new Label(parent, 0);
        this.contentSectionLabel.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.contentSectionLabel.setFont(FontUtils.getBold((Font)this.contentSectionLabel.getFont()));
        this.contentSectionLabel.setText(MindMapMessages.MultipageSetupDialog_Content);
        this.contentSectionComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 15;
        this.contentSectionComposite.setLayout((Layout)layout);
        this.contentSectionComposite.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.currentMapRadio = new Button(this.contentSectionComposite, 16);
        this.currentMapRadio.setText(DialogMessages.PageSetupDialog_CurrentMap);
        this.currentMapRadio.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.currentMapRadio, 13);
        this.wholeWorkbookRadio = new Button(this.contentSectionComposite, 16);
        this.wholeWorkbookRadio.setText(DialogMessages.PageSetupDialog_WholeWorkbook);
        this.wholeWorkbookRadio.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.wholeWorkbookRadio, 13);
    }

    private void createPageSetupSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 128, false, false));
        label.setFont(FontUtils.getBold((Font)label.getFont()));
        label.setText(MindMapMessages.MultipageSetupDialog_PageSetup);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 20;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.backgroundCheck = new Button(composite, 32);
        this.backgroundCheck.setText(DialogMessages.PageSetupDialog_Background);
        this.backgroundCheck.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.hookWidget((Widget)this.backgroundCheck, 13);
        this.borderCheck = new Button(composite, 32);
        this.borderCheck.setText(DialogMessages.PageSetupDialog_Border);
        this.borderCheck.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.hookWidget((Widget)this.borderCheck, 13);
    }

    private void createShowPlusMinusIconsSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 128, false, false));
        label.setFont(FontUtils.getBold((Font)label.getFont()));
        label.setText(MindMapMessages.MultipageSetupDialog_Collapse_Expand);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.createShowPlusCheck(composite);
        this.createShowMinusCheck(composite);
        this.initPlusMinusCheckState();
        this.addHideControl((Control)label);
        this.addHideControl((Control)composite);
    }

    private void createShowPlusCheck(Composite parent) {
        this.showPlusCheck = this.createPlusMinusCheck(parent, MindMapMessages.MultipageSetupDialog_showPlusCheck_text, (Image)this.resources.get((DeviceResourceDescriptor)MindMapUI.getImages().get("plus.png", true)));
    }

    private void createShowMinusCheck(Composite parent) {
        this.showMinusCheck = this.createPlusMinusCheck(parent, MindMapMessages.MultipageSetupDialog_showMinusCheck_text, (Image)this.resources.get((DeviceResourceDescriptor)MindMapUI.getImages().get("minus.png", true)));
    }

    private Button createPlusMinusCheck(Composite parent, String text, Image image) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Button check = new Button(composite, 32);
        check.setBackground(composite.getBackground());
        check.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        check.setText(text);
        Label imageLabel = new Label(composite, 0);
        imageLabel.setBackground(composite.getBackground());
        imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        imageLabel.setImage(image);
        this.hookWidget((Widget)check, 13);
        return check;
    }

    private void initPlusMinusCheckState() {
        boolean plusVisible = this.getBoolean(this.getSettings(), "plusVisible", true);
        boolean minusVisible = this.getBoolean(this.getSettings(), "minusVisible", true);
        this.showPlusCheck.setSelection(plusVisible);
        this.showMinusCheck.setSelection(minusVisible);
    }

    private boolean getBoolean(IDialogSettings settings, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (settings.get(key) != null) {
            value = settings.getBoolean(key);
        }
        return value;
    }

    private void createOrientationSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 128, false, false));
        label.setFont(FontUtils.getBold((Font)label.getFont()));
        label.setText(MindMapMessages.MultipageSetupDialog_Orientation);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 20;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.landscapeRadio = new Button(composite, 16);
        this.landscapeRadio.setData((Object)2);
        this.landscapeRadio.setText(DialogMessages.PageSetupDialog_Landscape);
        this.landscapeRadio.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.hookWidget((Widget)this.landscapeRadio, 13);
        this.portraitRadio = new Button(composite, 16);
        this.portraitRadio.setData((Object)1);
        this.portraitRadio.setText(DialogMessages.PageSetupDialog_Portrait);
        this.portraitRadio.setLayoutData((Object)new GridData(16384, 4, false, false));
    }

    private void createMarginsSection(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(131072, 128, false, false);
        gridData.verticalIndent = 3;
        label.setLayoutData((Object)gridData);
        label.setFont(FontUtils.getBold((Font)label.getFont()));
        label.setText(MindMapMessages.MultipageSetupDialog_Margin);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 128, false, false));
        Composite leftComposite = new Composite(composite, 0);
        GridLayout layout1 = new GridLayout(2, false);
        layout1.marginHeight = 0;
        layout1.marginWidth = 0;
        leftComposite.setLayout((Layout)layout1);
        leftComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        Composite rightComposite = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        rightComposite.setLayout((Layout)layout2);
        rightComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.createMarginInput(leftComposite, "leftMargin", DialogMessages.PageSetupDialog_Left);
        this.createMarginInput(rightComposite, "rightMargin", DialogMessages.PageSetupDialog_Right);
        this.createMarginInput(leftComposite, "topMargin", DialogMessages.PageSetupDialog_Top);
        this.createMarginInput(rightComposite, "bottomMargin", DialogMessages.PageSetupDialog_Bottom);
        this.unitChooser = new Combo(composite, 2060);
        this.unitChooser.add(DialogMessages.PageSetupDialog_Inch);
        this.unitChooser.add(DialogMessages.PageSetupDialog_Millimeter);
        GridData unitLayoutData = new GridData(0x1000008, 4, true, false);
        unitLayoutData.horizontalSpan = 2;
        this.unitChooser.setLayoutData((Object)unitLayoutData);
        this.hookWidget((Widget)this.unitChooser, 13);
        this.addHideControl((Control)label);
        this.addHideControl((Control)composite);
    }

    private void createHeaderFooterSection(Composite parent) {
        Composite leftComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        leftComposite.setLayout((Layout)layout);
        leftComposite.setLayoutData((Object)new GridData(131072, 4, false, false));
        Label label = new Label(leftComposite, 0);
        GridData gridData = new GridData(131072, 128, false, true);
        gridData.verticalIndent = 2;
        label.setLayoutData((Object)gridData);
        label.setFont(FontUtils.getBold((Font)label.getFont()));
        label.setText(MindMapMessages.MultipageSetupDialog_Header);
        Label label2 = new Label(leftComposite, 0);
        GridData gridData2 = new GridData(131072, 128, false, true);
        gridData2.verticalIndent = 2;
        label2.setLayoutData((Object)gridData2);
        label2.setFont(FontUtils.getBold((Font)label.getFont()));
        label2.setText(MindMapMessages.MultipageSetupDialog_Footer);
        Composite rightComposite = new Composite(parent, 0);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.verticalSpacing = 5;
        rightComposite.setLayout((Layout)layout2);
        rightComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createHeaderSection(rightComposite);
        this.createFooterSection(rightComposite);
        this.addHideControl((Control)leftComposite);
        this.addHideControl((Control)rightComposite);
    }

    private void createPagesSection(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(131072, 128, false, false);
        gridData.verticalIndent = 3;
        label.setLayoutData((Object)gridData);
        label.setFont(FontUtils.getBold((Font)label.getFont()));
        label.setText(MindMapMessages.MultipageSetupDialog_Pages);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.pagesChooser = new Combo(composite, 2060);
        this.pagesChooser.add(MindMapMessages.MultipageSetupDialog_SinglePage);
        this.pagesChooser.add(MindMapMessages.MultipageSetupDialog_MultiplePages);
        GridData unitLayoutData = new GridData(4, 4, true, false);
        unitLayoutData.horizontalSpan = 2;
        this.pagesChooser.setLayoutData((Object)unitLayoutData);
        this.pagesChooser.setBackground(parent.getDisplay().getSystemColor(1));
        this.hookWidget((Widget)this.pagesChooser, 13);
        this.multipageComposite = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.horizontalSpacing = 10;
        layout2.verticalSpacing = 15;
        this.multipageComposite.setLayout((Layout)layout2);
        this.multipageComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.pageLockCheck = new Button(this.multipageComposite, 32);
        this.pageLockCheck.setText(MindMapMessages.MultipageSetupDialog_OptimalPagingEffect);
        GridData layoutData = new GridData(16384, 4, false, false);
        layoutData.horizontalSpan = 2;
        this.pageLockCheck.setLayoutData((Object)layoutData);
        this.hookWidget((Widget)this.pageLockCheck, 13);
        boolean isLinux = Util.isLinux();
        if (isLinux) {
            layout2.numColumns = 1;
            layoutData.horizontalSpan = 1;
        }
        this.widthPages = this.createChangePageSection(this.multipageComposite, MindMapMessages.MultipageSetupDialog_Horizontal);
        this.heightPages = this.createChangePageSection(this.multipageComposite, MindMapMessages.MultipageSetupDialog_Vertical);
    }

    private void createMarginInput(Composite parent, String key, String name) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText(name);
        nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Text input = this.createInputControl(parent, key, true);
        GridData gd = new GridData(0x1000008, 4, false, false);
        gd.widthHint = 45;
        input.setLayoutData((Object)gd);
    }

    private Text createInputControl(Composite parent, final String key, boolean numeric) {
        Text input = new Text(parent, 2052);
        input.setData((Object)key);
        if (numeric) {
            SWTUtils.makeNumeralInput((Control)input, (boolean)false, (boolean)true);
        }
        this.hookWidget((Widget)input, 24);
        this.hookWidget((Widget)input, 14);
        this.hookWidget((Widget)input, 15);
        if (numeric) {
            this.hookWidget((Widget)input, 1);
        }
        if (this.inputControls == null) {
            this.inputControls = new HashMap<String, Text>();
        }
        this.inputControls.put(key, input);
        input.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (MultipageSetupDialog.this.inputControls != null) {
                    MultipageSetupDialog.this.inputControls.remove(key);
                }
            }
        });
        return input;
    }

    private void createHeaderSection(Composite parent) {
        this.createHFSection(parent, DialogMessages.PageSetupDialog_Header, "headerAlign", "headerFont", "headerText");
    }

    private void createFooterSection(Composite parent) {
        this.createHFSection(parent, DialogMessages.PageSetupDialog_Footer, "footerAlign", "footerFont", "footerText");
    }

    private void createHFSection(Composite parent, String name, final String alignKey, String fontKey, String textKey) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        container.setLayout((Layout)layout);
        Text input = this.createInputControl(container, textKey, false);
        GridData inputLayoutData = new GridData(4, 4, true, false);
        inputLayoutData.horizontalSpan = 3;
        input.setLayoutData((Object)inputLayoutData);
        AlignAction leftAction = new AlignAction(alignKey, "left");
        AlignAction centerAction = new AlignAction(alignKey, "center");
        AlignAction rightAction = new AlignAction(alignKey, "right");
        ToolBarManager alignBar = new ToolBarManager(0x800000);
        alignBar.add((IAction)leftAction);
        alignBar.add((IAction)centerAction);
        alignBar.add((IAction)rightAction);
        alignBar.createControl(container);
        alignBar.getControl().setLayoutData((Object)new GridData(131072, 4, true, false));
        this.addActions(alignKey, new IAction[]{leftAction, centerAction, rightAction});
        alignBar.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MultipageSetupDialog.this.removeActions(alignKey);
            }
        });
        ToolBarManager fontBar = new ToolBarManager(0x800000);
        FontAction fontAction = new FontAction(fontKey);
        fontBar.add((IAction)fontAction);
        fontBar.createControl(container);
        fontBar.getControl().setLayoutData((Object)new GridData(131072, 4, false, false));
    }

    private void addActions(String key, IAction ... actions) {
        if (this.actions == null) {
            this.actions = new HashMap<String, IAction[]>();
        }
        this.actions.put(key, actions);
    }

    private void removeActions(String key) {
        if (this.actions != null) {
            this.actions.remove(key);
        }
    }

    private IAction[] getActions(String key) {
        return this.actions == null ? null : this.actions.get(key);
    }

    private Spinner createChangePageSection(Composite parent, String text) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(16384, 4, false, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label.setText(text);
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setDigits(0);
        spinner.setMinimum(1);
        spinner.setMaximum(100);
        spinner.setSelection(1);
        spinner.setIncrement(1);
        spinner.setPageIncrement(2);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        spinner.setLayoutData((Object)gridData);
        this.hookWidget((Widget)spinner, 24);
        return spinner;
    }

    private void addHideControl(Control hideControl) {
        this.hideControls.add(hideControl);
    }

    private void createPreviewPart(Composite parent) {
        this.viewer = new MultipageImagePreviewViewer(true);
        this.viewer.createControl(parent);
        this.viewer.getControl().setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)8));
    }

    private void hookWidget(Widget widget, int eventType) {
        widget.addListener(eventType, this.eventHandler);
    }

    private void handleWidgetEvent(Event event) {
        if (event.widget == this.hideDetailsButton) {
            boolean hideDetail = !this.getBoolean("hideDetails");
            this.setProperty("hideDetails", hideDetail);
        } else if (event.widget == this.currentMapRadio) {
            this.setProperty("contentWholeWorkbook", !this.currentMapRadio.getSelection());
        } else if (event.widget == this.wholeWorkbookRadio) {
            this.setProperty("contentWholeWorkbook", this.wholeWorkbookRadio.getSelection());
        } else if (event.widget == this.backgroundCheck) {
            this.setProperty("noBackground", !this.backgroundCheck.getSelection());
        } else if (event.widget == this.borderCheck) {
            this.setProperty("border", this.borderCheck.getSelection());
        } else if (event.widget == this.showPlusCheck) {
            this.setProperty("plusVisible", this.showPlusCheck.getSelection());
        } else if (event.widget == this.showMinusCheck) {
            this.setProperty("minusVisible", this.showMinusCheck.getSelection());
        } else if (event.widget == this.landscapeRadio || event.widget == this.portraitRadio) {
            Button selectedButton = this.landscapeRadio.getSelection() ? this.landscapeRadio : this.portraitRadio;
            this.getSettings().put("orientation", ((Integer)selectedButton.getData()).intValue());
            this.refreshWidthHeightPages();
            this.update("orientation");
        } else if (event.widget instanceof Text && this.inputControls != null && this.inputControls.containsValue(event.widget)) {
            Text input = (Text)event.widget;
            if (event.type == 15) {
                input.selectAll();
            } else if (event.type == 1) {
                if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000001)) {
                    this.stepValue(input, 1);
                } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000002)) {
                    this.stepValue(input, -1);
                }
            } else if (event.type == 14 || event.type == 24) {
                if (this.updating) {
                    return;
                }
                int caretPosition = input.getCaretPosition();
                this.modifyingText = true;
                String key = (String)event.widget.getData();
                if (key.equals("headerText") || key.equals("footerText")) {
                    String oldValue = this.getString(key, key.equals("headerText") ? "" : "");
                    String newValue = input.getText();
                    if ("".equals(oldValue) && !"".equals(newValue) || !"".equals(oldValue) && "".equals(newValue)) {
                        this.getSettings().put(key, input.getText());
                        this.refreshWidthHeightPages();
                        this.update(key);
                        this.generatePreview(false);
                    } else {
                        this.setProperty(key, input.getText());
                    }
                } else {
                    try {
                        double value = Double.parseDouble(input.getText());
                        this.setMargin(key, value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                this.modifyingText = false;
                caretPosition = Math.min(caretPosition, input.getText().length());
                input.setSelection(caretPosition);
            }
        } else if (event.widget == this.unitChooser) {
            int index = this.unitChooser.getSelectionIndex();
            if (index < 0 || index >= PrintConstants.UNITS.size()) {
                index = 0;
            }
            this.setProperty("marginUnit", PrintConstants.UNITS.get(index));
        } else if (event.widget == this.pagesChooser) {
            int index = this.pagesChooser.getSelectionIndex();
            this.setProperty("multiPages", index == 1);
        } else if (event.widget == this.widthPages) {
            boolean locked = this.getBoolean("aspectRatioLocked");
            if (!this.isRefreshingPages) {
                if (locked) {
                    this.isRefreshingPages = true;
                    this.getSettings().put("fillHeight", false);
                    int heightPageNumber = this.getHeightPageByWidth(this.page, this.sourceMindMap, this.getSettings(), this.widthPages.getSelection());
                    this.heightPages.setSelection(heightPageNumber);
                    this.setProperty("widthPages", this.widthPages.getSelection());
                    this.isRefreshingPages = false;
                } else {
                    this.getSettings().put("fillHeight", false);
                    this.setProperty("widthPages", this.widthPages.getSelection());
                }
            } else {
                this.getSettings().put("widthPages", this.widthPages.getSelection());
            }
        } else if (event.widget == this.heightPages) {
            boolean locked = this.getBoolean("aspectRatioLocked");
            if (!this.isRefreshingPages) {
                if (locked) {
                    this.isRefreshingPages = true;
                    this.getSettings().put("fillHeight", true);
                    this.widthPages.setSelection(this.getWidthPageByHeight(this.page, this.sourceMindMap, this.getSettings(), this.heightPages.getSelection()));
                    this.setProperty("heightPages", this.heightPages.getSelection());
                    this.isRefreshingPages = false;
                } else {
                    this.getSettings().put("fillHeight", true);
                    this.setProperty("heightPages", this.heightPages.getSelection());
                }
            } else {
                this.getSettings().put("heightPages", this.heightPages.getSelection());
            }
        } else if (event.widget == this.pageLockCheck) {
            boolean locked = this.pageLockCheck.getSelection();
            this.getSettings().put("aspectRatioLocked", locked);
            this.refreshWidthHeightPages();
            this.update("aspectRatioLocked");
        }
    }

    private void stepValue(Text input, int stepFactor) {
        double value;
        try {
            value = Double.parseDouble(input.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        String[] parts = MultipageSetupDialog.split1000(value);
        int integer = Integer.parseInt(parts[0], 10);
        if ((integer += this.getStep() * stepFactor) < 100) {
            integer = 100;
        }
        value = MultipageSetupDialog.join1000(String.valueOf(integer), parts[1]);
        this.setMargin((String)input.getData(), value);
    }

    private int getStep() {
        if ("milliter".equals(this.getString("marginUnit", "inch"))) {
            return 500;
        }
        return 100;
    }

    private void refreshWidthHeightPages() {
        boolean locked = this.getBoolean("aspectRatioLocked");
        if (locked) {
            boolean fillWidth = !this.getSettings().getBoolean("fillHeight");
            this.isRefreshingPages = true;
            if (fillWidth) {
                this.heightPages.setSelection(this.getHeightPageByWidth(this.page, this.sourceMindMap, this.getSettings(), this.widthPages.getSelection()));
            } else {
                this.widthPages.setSelection(this.getWidthPageByHeight(this.page, this.sourceMindMap, this.getSettings(), this.heightPages.getSelection()));
            }
            this.isRefreshingPages = false;
        }
    }

    private void setMargin(String key, double value) {
        if ("milliter".equals(this.getString("marginUnit", "inch"))) {
            value = UnitConvertor.mm2inch(value);
        }
        this.getSettings().put(key, value);
        this.refreshWidthHeightPages();
        this.update(key);
    }

    private void update(String key) {
        boolean hideDetail;
        if (this.updating) {
            return;
        }
        boolean hideDetailChanged = key == null || "hideDetails".equals(key);
        boolean contentChanged = key == null || "contentWholeWorkbook".equals(key);
        boolean backgroundChanged = key == null || "noBackground".equals(key);
        boolean borderChanged = key == null || "border".equals(key);
        boolean showPlusMinusIconsChanged = key == null || "plusVisible".equals(key) || "minusVisible".equals(key);
        boolean orientationChanged = key == null || "orientation".equals(key);
        boolean unitChanged = key == null || "marginUnit".equals(key);
        boolean marginChanged = key == null || unitChanged || "leftMargin".equals(key) || "rightMargin".equals(key) || "topMargin".endsWith(key) || "bottomMargin".equals(key);
        boolean headerChanged = key == null || "headerAlign".equals(key) || "headerFont".equals(key) || "headerText".equals(key);
        boolean footerChanged = key == null || "footerAlign".equals(key) || "footerFont".equals(key) || "footerText".equals(key);
        boolean pagesChanged = key == null || "multiPages".equals(key);
        boolean widthPagesChanged = key == null || "widthPages".equals(key);
        boolean heightPagesChanged = key == null || "heightPages".equals(key);
        boolean buttonLockChanged = key == null || "aspectRatioLocked".equals(key);
        this.updating = true;
        if (hideDetailChanged) {
            hideDetail = this.getBoolean("hideDetails");
            this.hideDetailsButton.setText(hideDetail ? MindMapMessages.MultipageSetupDialog_ShowDetails : MindMapMessages.MultipageSetupDialog_HideDetails);
            for (Control control : this.hideControls) {
                control.setVisible(!hideDetail);
                ((GridData)control.getLayoutData()).exclude = hideDetail;
            }
        }
        if (contentChanged) {
            this.currentMapRadio.setSelection(!this.getBoolean("contentWholeWorkbook"));
            this.wholeWorkbookRadio.setSelection(this.getBoolean("contentWholeWorkbook"));
        }
        if (backgroundChanged) {
            boolean showBackground = !this.getBoolean("noBackground");
            this.getImageCreator().setSourceImageValid(false);
            if (this.backgroundCheck != null && !this.backgroundCheck.isDisposed()) {
                this.backgroundCheck.setSelection(showBackground);
            }
        }
        if (borderChanged) {
            boolean showBorder = this.getBoolean("border");
            this.borderCheck.setSelection(showBorder);
            this.viewer.setBorderVisible(showBorder);
        }
        if (showPlusMinusIconsChanged) {
            boolean plusVisible = this.getBoolean(this.settings, "plusVisible", true);
            boolean minusVisible = this.getBoolean(this.settings, "minusVisible", true);
            this.getImageCreator().setPlusVisible(plusVisible);
            this.getImageCreator().setMinusVisible(minusVisible);
            this.getImageCreator().setSourceImageValid(false);
        }
        if (orientationChanged) {
            this.updateOrientation();
        }
        if (unitChanged && this.unitChooser != null && !this.unitChooser.isDisposed()) {
            int index = PrintConstants.UNITS.indexOf(this.getString("marginUnit", "inch"));
            if (index < 0 || index >= this.unitChooser.getItemCount()) {
                index = 0;
            }
            this.unitChooser.select(index);
        }
        if (marginChanged) {
            if (key == null || unitChanged) {
                this.updateMargins("leftMargin", "rightMargin", "topMargin", "bottomMargin");
            } else {
                this.updateMargins(key);
            }
        }
        if (headerChanged) {
            this.updateHFSectionAndPreview("headerText", "", "headerAlign", "center", 2, "headerFont");
        }
        if (footerChanged) {
            this.updateHFSectionAndPreview("footerText", "", "footerAlign", "right", 4, "footerFont");
        }
        if (pagesChanged) {
            boolean multiPages = this.getBoolean("multiPages");
            this.pagesChooser.select(multiPages ? 1 : 0);
            if (this.viewer != null && !multiPages) {
                this.viewer.setPageNumberVisible(false);
            }
            this.multipageComposite.setVisible(multiPages);
            ((GridData)this.multipageComposite.getLayoutData()).exclude = !multiPages;
            this.contentSectionLabel.setEnabled(!multiPages);
            Control[] controlArray = this.contentSectionComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setEnabled(!multiPages);
                ++n2;
            }
            if (multiPages) {
                this.currentMapRadio.setSelection(true);
                this.wholeWorkbookRadio.setSelection(false);
            } else {
                this.currentMapRadio.setSelection(!this.getBoolean("contentWholeWorkbook"));
                this.wholeWorkbookRadio.setSelection(this.getBoolean("contentWholeWorkbook"));
            }
            this.getShell().pack();
            this.getShell().layout(true, true);
        }
        if (buttonLockChanged) {
            boolean isButtonLocked = this.getBoolean("aspectRatioLocked");
            this.pageLockCheck.setSelection(isButtonLocked);
        }
        if (hideDetailChanged || orientationChanged) {
            int prefWidth;
            boolean landscape;
            hideDetail = this.getBoolean("hideDetails");
            int orientation = this.getInteger("orientation", 2);
            boolean bl = landscape = orientation != 1;
            int n = hideDetail ? (landscape ? 299 : 211) : (prefWidth = landscape ? 289 : 204);
            int prefHeight = hideDetail ? (landscape ? 211 : 299) : (landscape ? 204 : 289);
            this.viewer.updateBackgroundImageComposite(!hideDetail, landscape);
            this.viewer.updateBackgroundImage();
            this.viewer.setPrefSize(new org.eclipse.swt.graphics.Point(prefWidth, prefHeight));
        }
        if (key == null) {
            this.initWidthHeightPages();
        }
        if (key == null) {
            this.generatePreview(false);
        } else if (backgroundChanged || showPlusMinusIconsChanged || orientationChanged || marginChanged || pagesChanged || widthPagesChanged || heightPagesChanged || buttonLockChanged) {
            this.generatePreview(true);
        }
        this.updating = false;
    }

    private void initWidthHeightPages() {
        boolean locked = this.getBoolean("aspectRatioLocked");
        boolean fillWidth = !this.getBoolean("fillHeight");
        int widthPageNumber = this.getInteger("widthPages", 1);
        int heightPageNumber = this.getInteger("heightPages", 1);
        if (locked) {
            if (fillWidth) {
                this.widthPages.setSelection(widthPageNumber);
            } else {
                this.heightPages.setSelection(heightPageNumber);
            }
        } else {
            this.widthPages.setSelection(widthPageNumber);
            this.heightPages.setSelection(heightPageNumber);
        }
    }

    private void updateHFSectionAndPreview(String textKey, String defaultText, String alignKey, String defaultAlign, int defaultDraw2DAlign, String fontKey) {
        Text input;
        String text = this.getString(textKey, defaultText);
        String alignValue = this.getString(alignKey, defaultAlign);
        IAction[] alignActions = this.getActions(alignKey);
        if (alignActions != null) {
            IAction[] iActionArray = alignActions;
            int n = alignActions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                action.setChecked(((AlignAction)action).value.equals(alignValue));
                ++n2;
            }
        }
        if (!this.modifyingText && this.inputControls != null && (input = this.inputControls.get(textKey)) != null && !input.isDisposed()) {
            input.setText(text);
        }
        String fontValue = this.getString(fontKey, null);
        Font font = null;
        if (fontValue != null) {
            font = FontUtils.getFont((String)fontValue);
        }
        if (font == null) {
            font = Display.getCurrent().getSystemFont();
        }
        if (this.viewer != null) {
            if ("headerText".equals(textKey)) {
                this.viewer.updateHeaderPreview(text, alignValue, defaultDraw2DAlign, fontValue);
            } else if ("footerText".equals(textKey)) {
                this.viewer.updateFooterPreview(text, alignValue, defaultDraw2DAlign, fontValue);
            }
        }
    }

    private void updateMargins(String ... keys) {
        if (!this.modifyingText && this.inputControls != null) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                Text text = this.inputControls.get(key);
                if (text != null && !text.isDisposed()) {
                    text.setText(this.getMarginText(key));
                }
                ++n2;
            }
        }
    }

    private String getMarginText(String key) {
        double value = this.getDouble(key, 0.2);
        if ("milliter".equals(this.getString("marginUnit", "inch"))) {
            value = UnitConvertor.inch2mm(value);
        }
        return String.valueOf(value);
    }

    private void updateOrientation() {
        int orientation = this.getInteger("orientation", 2);
        boolean landscape = orientation != 1;
        this.landscapeRadio.setSelection(landscape);
        this.portraitRadio.setSelection(!landscape);
    }

    private void setProperty(String key, String value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    private void setProperty(String key, int value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    private void setProperty(String key, boolean value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    private String getString(String key, String defaultValue) {
        String value = this.getSettings().get(key);
        return value == null ? defaultValue : value;
    }

    private boolean getBoolean(String key) {
        return this.getSettings().getBoolean(key);
    }

    private double getDouble(String key, double defaultValue) {
        try {
            return this.getSettings().getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private int getInteger(String key, int defaultValue) {
        try {
            return this.getSettings().getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private void generatePreview(boolean hasDelay) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.updateViewer(null, PreviewState.Generating, false, null);
            this.viewer.setFeedbackVisible(false);
        }
        this.disposePreview();
        this.generatePreviewJob = new GeneratePreviewJob();
        if (this.getSettings() instanceof DialogSettingsDecorator) {
            ((DialogSettingsDecorator)this.getSettings()).setDirty(false);
        }
        if (hasDelay) {
            this.generatePreviewJob.schedule(1000L);
        } else {
            this.generatePreviewJob.schedule();
        }
    }

    private void disposePreview() {
        this.cancel();
    }

    private void cancel() {
        if (this.generatePreviewJob != null) {
            this.generatePreviewJob.cancel();
            this.generatePreviewJob = null;
        }
    }

    private void asyncUpdateViewer(Display display, final Image image, final PreviewState state, final boolean largeImage, final Point origin) {
        if (Thread.currentThread() != display.getThread()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MultipageSetupDialog.this.updateViewer(image, state, largeImage, origin);
                }
            });
        } else {
            this.updateViewer(image, state, largeImage, origin);
        }
    }

    private void updateViewer(Image image, PreviewState state, boolean largeImage, Point origin) {
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        if (image != null && origin != null) {
            this.viewer.setImage(image, origin.x, origin.y);
        } else {
            this.viewer.setImage(image);
        }
        this.viewer.setTitle(state.getTitle(image, largeImage));
        this.viewer.setTitlePlacement(state.getTitlePlacement());
        state.setColor(this.viewer.getControl());
        this.viewer.initPreviewImageRatio();
    }

    private void createPreviewImage(boolean multiPages) {
        this.previewImageCreator = this.getImageCreator();
        this.viewer.setImageBorderBounds(this.getImageBorderBounds(this.page, this.sourceMindMap, this.getSettings()));
        this.previewImageCreator.releaseResource();
        Image wholeImage = null;
        Image[] singleImages = null;
        if (multiPages) {
            wholeImage = this.previewImageCreator.createPrintPreviewRoughImage(this.viewer.getPrefWidth(), this.viewer.getPrefHeight());
            singleImages = this.previewImageCreator.getSingleImages();
        } else {
            Image singleImage = this.previewImageCreator.createPrintPreviewSingleImage();
            singleImages = new Image[]{singleImage};
        }
        this.viewer.setWholeImage(wholeImage);
        this.viewer.setSingleImages(singleImages);
    }

    private PrintMultipagePreviewImageCreator getImageCreator() {
        if (this.previewImageCreator == null) {
            this.previewImageCreator = this.createImageCreator(this.display);
        }
        return this.previewImageCreator;
    }

    private PrintMultipagePreviewImageCreator createImageCreator(Display display) {
        PrintMultipagePreviewImageCreator exporter = new PrintMultipagePreviewImageCreator(display, this.page, this.sourceMindMap, this.getSettings());
        return exporter;
    }

    public boolean close() {
        if (this.previewImageCreator != null) {
            this.previewImageCreator.dispose();
            this.previewImageCreator = null;
        }
        return super.close();
    }

    private int getHeightPageByWidth(IGraphicalEditorPage page, IMindMap mindmap, IDialogSettings settings, int widthPages) {
        Rectangle sheetFigureBounds = PrintMultipageUtils.getSheetFigureBounds(page, mindmap);
        int sourceWidth = sheetFigureBounds.width;
        int sourceHeight = sheetFigureBounds.height;
        int leftMarginPixel = PrintConstants.toPixel(this.getDouble("leftMargin", 0.2));
        int rightMarginPixel = PrintConstants.toPixel(this.getDouble("rightMargin", 0.2));
        int topMarginPixel = PrintConstants.toPixel(this.getDouble("topMargin", 0.2));
        int bottomMarginPixel = PrintConstants.toPixel(this.getDouble("bottomMargin", 0.2));
        int headerHeight = PrintUtils.getHeaderHeight(settings, 120);
        int footerHeight = PrintUtils.getBottomHeight(settings, 120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel - headerHeight - footerHeight;
        double ratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
        int usefulPerPageHeightByRatio = (int)((double)usefulPerPageHeight / ratio);
        int heightPages = sourceHeight / usefulPerPageHeightByRatio;
        heightPages = sourceHeight % usefulPerPageHeightByRatio == 0 ? heightPages : heightPages + 1;
        return heightPages;
    }

    private int getWidthPageByHeight(IGraphicalEditorPage page, IMindMap mindmap, IDialogSettings settings, int heightPages) {
        Rectangle sheetFigureBounds = PrintMultipageUtils.getSheetFigureBounds(page, mindmap);
        int sourceWidth = sheetFigureBounds.width;
        int sourceHeight = sheetFigureBounds.height;
        int leftMarginPixel = PrintConstants.toPixel(this.getDouble("leftMargin", 0.2));
        int rightMarginPixel = PrintConstants.toPixel(this.getDouble("rightMargin", 0.2));
        int topMarginPixel = PrintConstants.toPixel(this.getDouble("topMargin", 0.2));
        int bottomMarginPixel = PrintConstants.toPixel(this.getDouble("bottomMargin", 0.2));
        int headerHeight = PrintUtils.getHeaderHeight(settings, 120);
        int footerHeight = PrintUtils.getBottomHeight(settings, 120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel - headerHeight - footerHeight;
        double ratio = (double)usefulPerPageHeight * (double)heightPages / (double)sourceHeight;
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / ratio);
        int widthPages = sourceWidth / usefulPerPageWidthByRatio;
        widthPages = sourceWidth % usefulPerPageWidthByRatio == 0 ? widthPages : widthPages + 1;
        return widthPages;
    }

    private org.eclipse.swt.graphics.Rectangle getImageBorderBounds(IGraphicalEditorPage page, IMindMap mindmap, IDialogSettings settings) {
        double ratio;
        Rectangle sheetFigureBounds = PrintMultipageUtils.getSheetFigureBounds(page, mindmap);
        int sourceWidth = sheetFigureBounds.width;
        int sourceHeight = sheetFigureBounds.height;
        int leftMarginPixel = PrintConstants.toPixel(this.getDouble("leftMargin", 0.2));
        int rightMarginPixel = PrintConstants.toPixel(this.getDouble("rightMargin", 0.2));
        int topMarginPixel = PrintConstants.toPixel(this.getDouble("topMargin", 0.2));
        int bottomMarginPixel = PrintConstants.toPixel(this.getDouble("bottomMargin", 0.2));
        int headerHeight = PrintUtils.getHeaderHeight(settings, 120);
        int footerHeight = PrintUtils.getBottomHeight(settings, 120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel - headerHeight - footerHeight;
        boolean multiPages = this.getBoolean("multiPages");
        if (multiPages) {
            boolean fullWidth;
            int widthPages = this.getInteger("widthPages", 1);
            int heightPages = this.getInteger("heightPages", 1);
            boolean isAspectRatio = settings.getBoolean("aspectRatioLocked");
            boolean bl = fullWidth = !settings.getBoolean("fillHeight");
            if (!isAspectRatio) {
                double fillWidthRatio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
                double fillHeightRatio = (double)usefulPerPageHeight * (double)heightPages / (double)sourceHeight;
                fullWidth = fillWidthRatio <= fillHeightRatio;
            }
            ratio = fullWidth ? (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth : (double)usefulPerPageHeight * (double)heightPages / (double)sourceHeight;
        } else {
            double widthRatio = (double)usefulPerPageWidth / (double)sourceWidth;
            double heightRatio = (double)usefulPerPageHeight / (double)sourceHeight;
            ratio = Math.min(widthRatio, heightRatio);
        }
        int leftMarginByRatio = (int)((double)leftMarginPixel / ratio);
        int topMarginByRation = (int)((double)(topMarginPixel + headerHeight) / ratio);
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / ratio);
        int usefulPerPageHeightByRatio = (int)((double)usefulPerPageHeight / ratio);
        return new org.eclipse.swt.graphics.Rectangle(leftMarginByRatio, topMarginByRation + 1, usefulPerPageWidthByRatio, usefulPerPageHeightByRatio);
    }

    private static String[] split1000(double value) {
        String repr = String.valueOf(String.valueOf(value)) + "000";
        int dotIndex = repr.indexOf(".");
        if (dotIndex < 0) {
            return new String[]{repr, ""};
        }
        return new String[]{String.valueOf(repr.substring(0, dotIndex)) + repr.substring(dotIndex + 1, dotIndex + 4), repr.substring(dotIndex + 4)};
    }

    private static double join1000(String prefix, String suffix) {
        prefix = "000" + prefix;
        String mid = prefix.substring(prefix.length() - 3);
        prefix = prefix.substring(0, prefix.length() - 3);
        return Double.parseDouble(String.valueOf(prefix) + "." + mid + suffix);
    }

    private class AlignAction
    extends Action {
        private String key;
        private String value;

        public AlignAction(String key, String value) {
            super(null, 2);
            this.key = key;
            this.value = value;
            if ("left".equals(value)) {
                this.setText(DialogMessages.PageSetupDialog_AlignLeft_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignLeft_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_left.png", true));
            } else if ("center".equals(value)) {
                this.setText(DialogMessages.PageSetupDialog_AlignCenter_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignCenter_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_center.png", true));
            } else {
                this.setText(DialogMessages.PageSetupDialog_AlignRight_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignRight_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_right.png", true));
            }
        }

        public void run() {
            MultipageSetupDialog.this.setProperty(this.key, this.value);
        }
    }

    private class FontAction
    extends Action {
        private String key;

        public FontAction(String key) {
            this.key = key;
            this.setText(DialogMessages.PageSetupDialog_Font_text);
            this.setToolTipText(DialogMessages.PageSetupDialog_Font_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("text_font.png", true));
        }

        public void run() {
            FontDialog dialog = new FontDialog(MultipageSetupDialog.this.getShell());
            dialog.setEffectsVisible(false);
            String string = MultipageSetupDialog.this.getString(this.key, null);
            if (string == null) {
                dialog.setFontList(JFaceResources.getDefaultFontDescriptor().getFontData());
            } else {
                dialog.setFontList(FontUtils.toFontData((String)string));
            }
            FontData open = dialog.open();
            if (open == null) {
                return;
            }
            MultipageSetupDialog.this.getSettings().put(this.key, FontUtils.toString((FontData[])dialog.getFontList()));
            MultipageSetupDialog.this.refreshWidthHeightPages();
            MultipageSetupDialog.this.update(this.key);
            MultipageSetupDialog.this.generatePreview(true);
        }
    }

    private class GeneratePreviewJob
    extends Job {
        public GeneratePreviewJob() {
            super(MindMapMessages.MultipageSetupDialog_GeneratePreview);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (MultipageSetupDialog.this.settings instanceof DialogSettingsDecorator && ((DialogSettingsDecorator)MultipageSetupDialog.this.settings).isDirty()) {
                return new Status(8, "org.xmind.ui", MindMapMessages.MultipageSetupDialog_GeneratingPreview);
            }
            monitor.beginTask(null, 100);
            monitor.worked(50);
            MultipageSetupDialog.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MultipageSetupDialog.this.asyncUpdateViewer(MultipageSetupDialog.this.display, null, PreviewState.Showing, false, null);
                    boolean multiPages = MultipageSetupDialog.this.getBoolean("multiPages");
                    MultipageSetupDialog.this.createPreviewImage(multiPages);
                    if (multiPages) {
                        MultipageSetupDialog.this.viewer.setImageIndex(0);
                    } else {
                        MultipageSetupDialog.this.viewer.setImageIndex(1);
                        MultipageSetupDialog.this.viewer.disableImageButtons();
                        MultipageSetupDialog.this.viewer.setPageNumberVisible(false);
                    }
                    MultipageSetupDialog.this.viewer.initPreviewImageRatio();
                    if (!MultipageSetupDialog.this.getImageCreator().checkImage()) {
                        MultipageSetupDialog.this.asyncUpdateViewer(MultipageSetupDialog.this.display, null, PreviewState.Error, false, null);
                    }
                }
            });
            monitor.worked(50);
            if (MultipageSetupDialog.this.generatePreviewJob == this) {
                MultipageSetupDialog.this.generatePreviewJob = null;
            }
            monitor.done();
            return new Status(0, "org.xmind.ui", MindMapMessages.MultipageSetupDialog_GeneratedPreview);
        }
    }

    private static enum PreviewState {
        Showing(null, 16, 132096){

            @Override
            public String getTitle(Image image, boolean largeImage) {
                if (image == null || image.isDisposed()) {
                    return super.getTitle(image, largeImage);
                }
                org.eclipse.swt.graphics.Rectangle r = image.getBounds();
                return String.format("%d x %d", r.width, r.height);
            }
        }
        ,
        Generating(MindMapMessages.MultipageSetupDialog_GeneratingPreview, 16, 0),
        Error(String.valueOf(MindMapMessages.MultipageSetupDialog_FaildGenerate) + MindMapMessages.MultipageSetupDialog_PrintDirectly, 4, 0){

            @Override
            public String getTitle(Image image, boolean largeImage) {
                return PreviewState.makeErrorMessage(super.getTitle(image, largeImage), largeImage);
            }
        };

        private int colorId;
        private String title;
        private int titlePlacement;

        private static String makeErrorMessage(String originalMessage, boolean largeImage) {
            if (largeImage) {
                return String.valueOf(originalMessage) + " " + MindMapMessages.MultipageSetupDialog_ImageTooLarge;
            }
            return originalMessage;
        }

        private PreviewState(String title, int colorId, int titlePlacement) {
            this.title = title;
            this.colorId = colorId;
            this.titlePlacement = titlePlacement;
        }

        public String getTitle(Image image, boolean largeImage) {
            return this.title;
        }

        public void setColor(Control control) {
            control.setForeground(control.getDisplay().getSystemColor(this.colorId));
        }

        public int getTitlePlacement() {
            return this.titlePlacement;
        }
    }
}

