/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.outline.resource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.ui.internal.outline.resource.AbstractIndexResource;
import org.xmind.ui.internal.outline.resource.IAssigneeResource;
import org.xmind.ui.mindmap.IWorkbookRef;

public class AssigneeResourceForWorkbook
extends AbstractIndexResource
implements IAssigneeResource {
    private IWorkbookRef workbookRef;
    private Set<String> assignees = new HashSet<String>();
    private Map<String, Set<ITopic>> assigneeToTopics = new HashMap<String, Set<ITopic>>();

    public AssigneeResourceForWorkbook(IWorkbookRef workbookRef) {
        Assert.isNotNull((Object)workbookRef);
        this.workbookRef = workbookRef;
        this.init(false);
    }

    private void init(boolean update) {
        if (update) {
            this.assignees.clear();
            this.assigneeToTopics.clear();
        }
        this.collectResourceForWorkbook(this.workbookRef);
    }

    @Override
    public Object getSource() {
        return this.workbookRef;
    }

    @Override
    public void reset(Object source, boolean update) {
        Assert.isNotNull((Object)source);
        this.workbookRef = (IWorkbookRef)source;
        this.init(update);
    }

    @Override
    public Set<String> getAssignees() {
        return this.assignees;
    }

    @Override
    public Set<ITopic> getTopics(String assignee) {
        return this.assigneeToTopics.get(assignee);
    }

    @Override
    protected void collectResourceForTopic(ITopic topic) {
        ITopicExtension ext = topic.getExtension("org.xmind.ui.taskInfo");
        if (ext == null) {
            return;
        }
        ITopicExtensionElement content = ext.getContent();
        List children = content.getChildren("assigned-to");
        if (!children.isEmpty()) {
            for (ITopicExtensionElement element : children) {
                Set<ITopic> assignedTopics;
                String assignee = element.getTextContent();
                if (this.assigneeToTopics.containsKey(assignee)) {
                    assignedTopics = this.assigneeToTopics.get(assignee);
                    if (assignedTopics == null) {
                        assignedTopics = new HashSet<ITopic>();
                        this.assigneeToTopics.put(assignee, assignedTopics);
                    }
                    assignedTopics.add(topic);
                    continue;
                }
                this.assignees.add(assignee);
                assignedTopics = new HashSet<ITopic>();
                assignedTopics.add(topic);
                this.assigneeToTopics.put(assignee, assignedTopics);
            }
        }
    }
}

