/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.layers;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IOriginBased;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.ui.internal.layers.BaseLayer;

public class ContentsLayer
extends BaseLayer
implements IOriginBased {
    private IFigure contents = null;
    private ContentsHook contentsHook = null;
    private Point origin = null;
    private IFigure topLeft = null;
    private IFigure bottomRight = null;
    private int margin = 0;
    private boolean centered;
    private boolean constrained;

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        if (centered == this.centered) {
            return;
        }
        this.centered = centered;
        this.revalidate();
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean constrained) {
        if (constrained == this.constrained) {
            return;
        }
        this.constrained = constrained;
        this.revalidate();
    }

    public void addCorners() {
        if (this.topLeft == null || this.topLeft.getParent() != this) {
            this.topLeft = new Figure();
            this.topLeft.setSize(1, 1);
            this.add(this.topLeft);
        }
        if (this.bottomRight == null || this.bottomRight.getParent() != this) {
            this.bottomRight = new Figure();
            this.bottomRight.setSize(1, 1);
            this.add(this.bottomRight);
        }
    }

    public void removeCorners() {
        if (this.topLeft != null) {
            this.remove(this.topLeft);
            this.topLeft = null;
        }
        if (this.bottomRight != null) {
            this.remove(this.bottomRight);
            this.bottomRight = null;
        }
    }

    public IFigure getContents() {
        return this.contents;
    }

    public void setContents(IFigure fig) {
        if (fig == this.contents) {
            return;
        }
        if (this.contents != null) {
            this.unhookContents(this.contents);
            this.remove(this.contents);
        }
        this.contents = fig;
        if (this.contents != null) {
            this.add(this.contents, 0);
            this.hookContents(this.contents);
        }
    }

    protected void hookContents(IFigure contents) {
        if (contents instanceof FreeformFigure) {
            if (this.contentsHook == null) {
                this.contentsHook = new ContentsHook();
            }
            ((FreeformFigure)contents).addFreeformListener((FreeformListener)this.contentsHook);
        }
    }

    protected void unhookContents(IFigure contents) {
        if (contents instanceof FreeformFigure && this.contentsHook != null) {
            ((FreeformFigure)contents).removeFreeformListener((FreeformListener)this.contentsHook);
        }
    }

    public Point getOrigin() {
        if (this.origin == null) {
            this.origin = this.calculateOrigin();
        }
        return this.origin;
    }

    protected Point calculateOrigin() {
        if (this.centered) {
            Rectangle area;
            if ((this.topLeft == null || this.bottomRight == null) && this.contents != null && (area = this.getViewportClientArea((IFigure)this)) != null) {
                area = area.getCopy().scale(1.0 / this.getScale((IFigure)this, 1.0));
                Point p = new Point(area.x + area.width / 2, area.y + area.height / 2);
                return p;
            }
        } else if (this.constrained) {
            if (this.contents instanceof IReferencedFigure) {
                Insets ins = ((IReferencedFigure)this.contents).getReferenceDescription();
                Rectangle area = this.getViewportClientArea((IFigure)this);
                area = area == null ? this.getBounds() : area.getCopy().scale(1.0 / this.getScale((IFigure)this, 1.0));
                return new Point(area.x + (area.width - ins.left - ins.right) / 2 + ins.left, area.y + (area.height - ins.top - ins.bottom) / 2 + ins.top);
            }
            return this.contents.getBounds().getLocation();
        }
        return new Point();
    }

    private double getScale(IFigure figure, double scale) {
        IFigure parent = figure.getParent();
        if (parent instanceof ScalableFigure) {
            scale *= ((ScalableFigure)parent).getScale();
        }
        if (parent != null) {
            scale = this.getScale(parent, scale);
        }
        return scale;
    }

    private Rectangle getViewportClientArea(IFigure figure) {
        IFigure parent = figure.getParent();
        if (parent instanceof Viewport) {
            return parent.getClientArea();
        }
        if (parent != null) {
            return this.getViewportClientArea(parent);
        }
        return null;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        if (margin == this.margin) {
            return;
        }
        this.margin = margin;
        this.revalidate();
    }

    protected void layout() {
        boolean hasCorners;
        boolean bl = hasCorners = this.topLeft != null && this.bottomRight != null;
        if (this.contents != null) {
            this.layoutContents(hasCorners);
        }
        if (hasCorners) {
            this.layoutCorner();
        }
    }

    protected void layoutContents(boolean hasCorners) {
        if (this.constrained) {
            Dimension size = this.contents.getPreferredSize();
            Rectangle area = this.getViewportClientArea((IFigure)this);
            area = area == null ? this.getBounds() : area.getCopy().scale(1.0 / this.getScale((IFigure)this, 1.0));
            Rectangle contentBounds = new Rectangle(area.x + (area.width - size.width) / 2, area.y + (area.height - size.height) / 2, size.width, size.height);
            if (this.contents instanceof FreeformFigure) {
                ((FreeformFigure)this.contents).setFreeformBounds(contentBounds);
            } else {
                this.contents.setBounds(contentBounds);
            }
        } else {
            Insets ins;
            Point o = this.getOrigin();
            if (this.contents instanceof IReferencedFigure) {
                ins = ((IReferencedFigure)this.contents).getReferenceDescription();
            } else {
                Dimension size = this.contents.getPreferredSize();
                ins = new Insets(size.height - size.height / 2, size.width - size.width / 2, size.height / 2, size.width / 2);
            }
            Rectangle r = new Rectangle(o.x - ins.left, o.y - ins.top, ins.getWidth(), ins.getHeight());
            this.contents.setBounds(r);
        }
    }

    protected void layoutCorner() {
        Rectangle area;
        Point origin = this.getOrigin();
        if (this.contents != null && (area = this.getViewportClientArea((IFigure)this)) != null) {
            area = area.getCopy().scale(1.0 / this.getScale((IFigure)this, 1.0));
            Insets ins = this.getContentsReferenceDescription(true);
            int left = origin.x - Math.max(ins.left, area.width);
            int top = origin.y - Math.max(ins.top, area.height);
            int right = origin.x + Math.max(ins.right, area.width);
            int bottom = origin.y + Math.max(ins.bottom, area.height);
            this.topLeft.setLocation(new Point(left, top));
            this.bottomRight.setLocation(new Point(right - 1, bottom - 1));
            return;
        }
        this.topLeft.setLocation(origin);
        this.bottomRight.setLocation(origin);
    }

    protected Insets getContentsReferenceDescription(boolean hasCorners) {
        Insets ins = new Insets(this.getMargin());
        if (this.contents instanceof IReferencedFigure) {
            ins.add(((IReferencedFigure)this.contents).getReferenceDescription());
        } else {
            Dimension cSize = this.contents.getPreferredSize();
            ins.right += cSize.width / 2;
            ins.bottom += cSize.height / 2;
            ins.left += cSize.width - cSize.width / 2;
            ins.top += cSize.height - cSize.height / 2;
        }
        return ins;
    }

    public void invalidate() {
        super.invalidate();
        this.origin = null;
    }

    private class ContentsHook
    implements FreeformListener {
        private ContentsHook() {
        }

        public void notifyFreeformExtentChanged() {
            ContentsLayer.this.repaint();
        }
    }
}

