/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.wizards.ISaveWizard;

public class SaveWizardManager
implements IRegistryEventListener {
    private List<SaveWizardDescriptor> wizards = null;
    private IExtensionRegistry registry = null;

    public List<SaveWizardDescriptor> getWizards() {
        this.ensureLoaded();
        return Collections.unmodifiableList(this.wizards);
    }

    private synchronized void ensureLoaded() {
        if (this.wizards != null) {
            return;
        }
        this.wizards = new ArrayList<SaveWizardDescriptor>();
        this.registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = this.registry.getExtensionPoint("org.xmind.ui", "saveWizards");
        if (extPoint == null) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.mindmap", "Extension point 'org.xmind.ui.saveWizards' not found."));
            return;
        }
        this.registry.addListener((IRegistryEventListener)this, extPoint.getUniqueIdentifier());
        this.readExtensions(extPoint.getExtensions());
    }

    private void readExtensions(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("saveWizard".equals(element.getName())) {
                    String id = element.getAttribute("id");
                    String clazz = element.getAttribute("class");
                    if (id == null || id.length() <= 0 || clazz == null || clazz.length() <= 0) {
                        MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.mindmap", "Invalid save wizard extension in " + ext.getUniqueIdentifier()));
                    } else {
                        this.wizards.add(new SaveWizardDescriptor(id, element));
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public synchronized void dispose() {
        if (this.wizards != null) {
            SaveWizardDescriptor[] ws = this.wizards.toArray(new SaveWizardDescriptor[this.wizards.size()]);
            this.wizards = null;
            SaveWizardDescriptor[] saveWizardDescriptorArray = ws;
            int n = ws.length;
            int n2 = 0;
            while (n2 < n) {
                SaveWizardDescriptor w = saveWizardDescriptorArray[n2];
                w.dispose();
                ++n2;
            }
        }
    }

    public void added(IExtension[] extensions) {
        this.readExtensions(extensions);
    }

    public void removed(IExtension[] extensions) {
        if (this.wizards != null) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                SaveWizardDescriptor[] ws;
                IExtension ext = iExtensionArray[n2];
                SaveWizardDescriptor[] saveWizardDescriptorArray = ws = this.wizards.toArray(new SaveWizardDescriptor[this.wizards.size()]);
                int n3 = ws.length;
                int n4 = 0;
                while (n4 < n3) {
                    SaveWizardDescriptor w = saveWizardDescriptorArray[n4];
                    if (w.isFromExtension(ext)) {
                        this.wizards.remove(w);
                        w.dispose();
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public static class SaveWizardDescriptor {
        private String id;
        private IConfigurationElement element;
        private ISaveWizard wizard = null;

        private SaveWizardDescriptor(String id, IConfigurationElement element) {
            this.id = id;
            this.element = element;
        }

        public String getId() {
            return this.id;
        }

        public ISaveWizard getWizard() {
            if (this.wizard == null && this.element != null) {
                try {
                    this.wizard = (ISaveWizard)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.mindmap", "Failed to create save wizard from class: " + this.element.getDeclaringExtension().getNamespaceIdentifier() + "/" + this.element.getAttribute("class"), (Throwable)e));
                    return null;
                }
            }
            return this.wizard;
        }

        private void dispose() {
            this.element = null;
            this.wizard = null;
        }

        private boolean isFromExtension(IExtension ext) {
            return this.element != null && ext != null && ext.equals((Object)this.element.getDeclaringExtension());
        }

        public String getName() {
            String name = this.element.getAttribute("name");
            return name == null ? "" : name;
        }
    }
}

