/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.RGB;
import org.xmind.gef.draw2d.DecoratedShapeFigure;
import org.xmind.gef.draw2d.decoration.IShapeDecorationEx;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.decorations.IInfoDecoration;
import org.xmind.ui.internal.decorations.RectangleInfoDecration;
import org.xmind.ui.internal.mindmap.InfoPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.style.StyleUtils;

public class InformationDecorator
extends Decorator {
    private static final InformationDecorator instance = new InformationDecorator();
    private static final int H_MARGIN = 5;
    private static final int V_MARGIN = 5;
    private static final int LINEWIDTH = 1;

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        if (part instanceof InfoPart) {
            figure.setVisible(((InfoPart)part).hasActions());
        }
        if (figure instanceof DecoratedShapeFigure) {
            DecoratedShapeFigure fig = (DecoratedShapeFigure)figure;
            IShapeDecorationEx decoration = fig.getDecoration();
            IInfoDecoration shape = null;
            if (decoration instanceof IInfoDecoration) {
                shape = (IInfoDecoration)decoration;
            }
            if (shape == null) {
                shape = new RectangleInfoDecration();
            }
            shape.setLeftMargin(figure, 5);
            shape.setTopMargin(figure, 5);
            shape.setRightMargin(figure, 5);
            shape.setBottomMargin(figure, 5);
            shape.setLineColor(figure, new LocalResourceManager(JFaceResources.getResources()).createColor(new RGB(248, 227, 137)));
            shape.setFillColor(figure, StyleUtils.getColor(this.getSheetPart(part), StyleUtils.getStyleSelector(this.getSheetPart(part)), "yellowBoxFillColor", shape.getId(), "#fff8b6"));
            shape.setLineAlpha(figure, 255);
            shape.setLineWidth(figure, 1);
            shape.setLineStyle(figure, 1);
            fig.setDecoration((IShapeDecorationEx)shape);
        }
    }

    private ISheetPart getSheetPart(IGraphicalPart part) {
        if (part instanceof ISheetPart) {
            return (ISheetPart)part;
        }
        IPart parentPart = part.getParent();
        while (parentPart != null && !(parentPart instanceof ISheetPart)) {
            parentPart = parentPart.getParent();
        }
        return (ISheetPart)parentPart;
    }

    public static InformationDecorator getInstance() {
        return instance;
    }
}

