/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Font;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.mindmap.InfoItemContentPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class InfoItemContentDecorator
extends Decorator {
    private static final InfoItemContentDecorator instance = new InfoItemContentDecorator();

    public void activate(IGraphicalPart part, IFigure figure) {
        super.activate(part, figure);
        figure.setForegroundColor(ColorUtils.getColor((String)"#333333"));
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        ITopicPart topicPart = null;
        if (part instanceof InfoItemContentPart) {
            topicPart = ((InfoItemContentPart)part).getTopicPart();
            if (topicPart != null) {
                figure.setFont(FontUtils.getNewHeight((Font)JFaceResources.getDefaultFont(), (int)(Util.isMac() ? 10 : 8)));
            } else {
                figure.setFont(JFaceResources.getDefaultFont());
            }
        }
        if (figure instanceof RotatableWrapLabel) {
            RotatableWrapLabel itemFigure = (RotatableWrapLabel)figure;
            if (part instanceof InfoItemContentPart) {
                itemFigure.setAbbreviated(true);
                itemFigure.setSingleLine(true);
                if (topicPart != null) {
                    this.setPrefWidth(itemFigure, topicPart);
                }
                InfoItemContentPart item = (InfoItemContentPart)part;
                itemFigure.setText(item.getContent());
            }
        }
    }

    private void setPrefWidth(final RotatableWrapLabel itemFigure, ITopicPart topicPart) {
        final IFigure figure = topicPart.getFigure();
        figure.getUpdateManager().runWithUpdate(new Runnable(){

            @Override
            public void run() {
                itemFigure.setPrefWidth(Math.abs((int)((double)((figure.getSize().width + figure.getClientArea().width) / 2) * 1.1 - 10.0)));
            }
        });
    }

    public static InfoItemContentDecorator getInstance() {
        return instance;
    }
}

