/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.vector.pdf;

import java.awt.Dimension;
import java.awt.Insets;
import org.xmind.ui.internal.exports.vector.pdf.Messages;

public class PDFMapConstants {
    private PDFMapConstants() {
    }

    public static final Dimension getSize(String size, String orientation) {
        Dimension d = PageSize.getSize(size);
        if (Orientation.Portrait.name().equals(orientation)) {
            return d;
        }
        return new Dimension(d.height, d.width);
    }

    public static final Insets getMargins(String name, String orientation) {
        Insets margins = PageMargins.getMargins(name);
        if (Orientation.Portrait.name().equals(orientation)) {
            return margins;
        }
        return new Insets(margins.left, margins.bottom, margins.right, margins.top);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        Landscape(Messages.PDFMapExportWizard_Orientation_Landscape),
        Portrait(Messages.PDFMapExportWizard_Orientation_Portrait);

        private String description;

        private Orientation(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageMargins {
        Small(Messages.PDFMapExportWizard_PageMargin_Small, 20, 20, 20, 20),
        Medium(Messages.PDFMapExportWizard_PageMargin_Medium, 30, 30, 30, 30),
        Large(Messages.PDFMapExportWizard_PageMargin_Large, 40, 40, 40, 40);

        private String name;
        private int top;
        private int left;
        private int bottom;
        private int right;

        private PageMargins(String name, int top, int left, int bottom, int right) {
            this.name = name;
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        public String getName() {
            return this.name;
        }

        public int getTop() {
            return this.top;
        }

        public int getLeft() {
            return this.left;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getRight() {
            return this.right;
        }

        public static Insets getMargins(String name) {
            PageMargins[] margins;
            PageMargins[] pageMarginsArray = margins = PageMargins.values();
            int n = margins.length;
            int n2 = 0;
            while (n2 < n) {
                PageMargins m = pageMarginsArray[n2];
                if (m.name().equals(name)) {
                    return new Insets(m.getTop(), m.getLeft(), m.getBottom(), m.getRight());
                }
                ++n2;
            }
            return new Insets(Small.getTop(), Small.getLeft(), Small.getBottom(), Small.getRight());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageSize {
        Letter(Messages.PDFMapExportWizard_PageSize_Letter, 612, 792),
        Note(Messages.PDFMapExportWizard_PageSize_Note, 540, 720),
        Legal(Messages.PDFMapExportWizard_PageSize_Legal, 612, 1008),
        Tabloid(Messages.PDFMapExportWizard_PageSize_Tabloid, 792, 1224),
        Executive(Messages.PDFMapExportWizard_PageSize_Executive, 522, 756),
        Postcard(Messages.PDFMapExportWizard_PageSize_Postcard, 283, 416),
        A0("A0", 2384, 3370),
        A1("A1", 1684, 2384),
        A2("A2", 1191, 1684),
        A3("A3", 842, 1191),
        A4("A4", 595, 842),
        A5("A5", 420, 595),
        A6("A6", 297, 420),
        A7("A7", 210, 297),
        A8("A8", 148, 210),
        A9("A9", 105, 148),
        A10("A10", 73, 105),
        B0("B0", 2834, 4008),
        B1("B1", 2004, 2834),
        B2("B2", 1417, 2004),
        B3("B3", 1000, 1417),
        B4("B4", 708, 1000),
        B5("B5", 498, 708),
        B6("B6", 354, 498),
        B7("B7", 249, 354),
        B8("B8", 175, 249),
        B9("B9", 124, 175),
        B10("B10", 87, 124);

        private String name;
        private int width;
        private int height;

        private PageSize(String name, int width, int height) {
            this.name = name;
            this.width = width;
            this.height = height;
        }

        public String getName() {
            return this.name;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public static Dimension getSize(String name) {
            PageSize[] sizes;
            PageSize[] pageSizeArray = sizes = PageSize.values();
            int n = sizes.length;
            int n2 = 0;
            while (n2 < n) {
                PageSize size = pageSizeArray[n2];
                if (size.name.equals(name)) {
                    return new Dimension(size.getWidth(), size.getHeight());
                }
                ++n2;
            }
            return new Dimension(A4.getWidth(), A4.getHeight());
        }
    }
}

