/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.TaskBarFigure;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;

public class ProgressFigure
extends Figure {
    private boolean hasChild;

    public void setHasChild(boolean hasChild) {
        if (this.hasChild != hasChild) {
            this.hasChild = hasChild;
            this.repaint();
        }
    }

    public boolean getHasChild() {
        return this.hasChild;
    }

    public ProgressFigure() {
        this.setForegroundColor(Colors.progress());
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setBackgroundColor(graphics.getForegroundColor());
        Rectangle r = this.getBounds();
        if (this.hasChild) {
            this.paintStatistics(graphics);
        } else {
            graphics.fillRoundRectangle(new Rectangle(r.x, r.y + 3, r.width, r.height - 6), 2, 2);
        }
    }

    private void paintStatistics(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        Rectangle r = new Rectangle(bounds);
        r.y += 2;
        if (r.width == 0 || r.height == 0) {
            return;
        }
        int parentLength = ((TaskBarFigure)this.getParent()).getLength();
        Path path = new Path((Device)Display.getCurrent());
        try {
            float corner = 0.5f;
            path.moveTo((float)r.x - corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2) - corner);
            path.lineTo((float)(r.x + r.width) - corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2) - corner);
            if (r.width <= 6) {
                path.lineTo((float)(r.x + r.width) - corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12 - 6 + (6 - r.width)) - corner);
            } else if (r.width > parentLength - 6) {
                path.lineTo((float)(r.x + r.width) - corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12 - (parentLength - r.width)) + corner);
                path.lineTo((float)(r.x + parentLength - 6) + corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12 - 6) + corner);
                path.lineTo((float)(r.x + 6) + corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12 - 6) - corner);
            } else {
                path.lineTo((float)(r.x + r.width) - corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12 - 6) + corner);
                path.lineTo((float)(r.x + 6) + corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12 - 6) - corner);
            }
            path.lineTo((float)r.x - corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2 + 12) + corner);
            path.lineTo((float)r.x - corner, (float)(r.y + (TaskTreeItemPart.HEIGHT - 12) / 2) - corner);
            graphics.fillPath(path);
        }
        finally {
            path.dispose();
        }
    }
}

