/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.ui.gantt2.gefext.ConnectionPart;
import org.xmind.ui.gantt2.gefext.IConnectionManager;
import org.xmind.ui.gantt2.viewer.DependencyAnchorsFeedback;
import org.xmind.ui.gantt2.viewer.DependencyArrowDecoration;
import org.xmind.ui.gantt2.viewer.DependencyFigure;
import org.xmind.ui.gantt2.viewer.DependencySelectablePolicy;
import org.xmind.ui.gantt2.viewer.DependencySelectionFeedback;
import org.xmind.ui.gantt2.viewer.TaskBarPart;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.INodePart;

public class DependencyConnectionPart
extends ConnectionPart
implements ICoreEventListener,
PropertyChangeListener {
    private ICoreEventRegister eventRegister = null;

    public DependencyConnectionPart(Object model) {
        this.setModel(model);
        this.setFigure(this.createFigure());
        this.installFeedback("selectable role", new DependencySelectionFeedback());
        this.installFeedback("movable role", new DependencyAnchorsFeedback());
    }

    public Dependency getDependency() {
        return (Dependency)this.getModel();
    }

    protected void register() {
        super.register();
        this.registerModel(this.getModel());
        this.registerFigure(this.getMainFigure());
    }

    protected void unregister() {
        this.unregisterFigure(this.getMainFigure());
        this.unregisterModel(this.getModel());
        super.unregister();
    }

    protected IFigure createFigure() {
        DependencyFigure figure = new DependencyFigure();
        DependencyArrowDecoration arrow = new DependencyArrowDecoration();
        arrow.setHost(figure);
        figure.add(arrow);
        return figure;
    }

    protected void installModelListeners() {
        super.installModelListeners();
        Object m = this.getModel();
        this.eventRegister = new CoreEventRegister(m, (ICoreEventListener)this);
        this.registerCoreEvents(m, this.eventRegister);
    }

    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        register.register("type");
        register.register("task-id");
    }

    protected void sourceNodeChanged(INodePart node, INodePart oldNode) {
        super.sourceNodeChanged(node, oldNode);
        this.rehookNodePropertyChange(node, oldNode);
    }

    protected void targetNodeChanged(INodePart node, INodePart oldNode) {
        super.targetNodeChanged(node, oldNode);
        this.rehookNodePropertyChange(node, oldNode);
    }

    private void rehookNodePropertyChange(INodePart node, INodePart oldNode) {
        PropertyChangeSupport support;
        if (oldNode instanceof TaskBarPart) {
            support = ((TaskBarPart)oldNode).getTaskBar().getPropertyChangeSupport();
            support.removePropertyChangeListener("start-date", this);
            support.removePropertyChangeListener("end-date", this);
        }
        if (node instanceof TaskBarPart) {
            support = ((TaskBarPart)node).getTaskBar().getPropertyChangeSupport();
            support.addPropertyChangeListener("start-date", this);
            support.addPropertyChangeListener("end-date", this);
        }
        this.update();
    }

    protected void uninstallModelListeners() {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            this.eventRegister = null;
        }
        super.uninstallModelListeners();
    }

    protected void onActivated() {
        super.onActivated();
        this.update();
    }

    protected void updateView(Object property) {
        DependencyFigure fig = (DependencyFigure)this.getFigure();
        if (property == null || "type".equals(property)) {
            String type = this.getDependency().getType();
            if ("FS".equals(type)) {
                fig.setSourceOrientation(16);
                fig.setTargetOrientation(8);
            } else if ("FF".equals(type)) {
                fig.setSourceOrientation(16);
                fig.setTargetOrientation(16);
            } else if ("SF".equals(type)) {
                fig.setSourceOrientation(8);
                fig.setTargetOrientation(16);
            } else if ("SS".equals(type)) {
                fig.setSourceOrientation(8);
                fig.setTargetOrientation(8);
            }
        }
        if (property == null || "start-date".equals(property) || "end-date".equals(property)) {
            fig.setVisible(this.isTaskBarVisible(this.getSourceNode()) && this.isTaskBarVisible(this.getTargetNode()));
        }
    }

    private boolean isTaskBarVisible(INodePart node) {
        return node != null && node instanceof TaskBarPart && ((TaskBarPart)node).getTaskBar().hasDates() && ((TaskBarPart)node).getBarFigure().isShowing();
    }

    public void handleCoreEvent(CoreEvent event) {
        final String type = event.getType();
        if ("type".equals(type)) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DependencyConnectionPart.this.update(type);
                }
            });
        } else if ("task-id".equals(type)) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DependencyConnectionPart.this.handlePredecessorChange();
                }
            });
        }
    }

    private void handlePredecessorChange() {
        IPart predecessorPart;
        Dependency dependency = this.getDependency();
        ITopic predecessor = dependency.getPredecessor();
        if (predecessor != null && (predecessorPart = this.getSite().getViewer().getPartRegistry().getPartByModel((Object)predecessor)) != null && predecessorPart.getStatus().isActive() && predecessorPart instanceof INodePart) {
            this.changeSourceNode((INodePart)predecessorPart);
            return;
        }
        IConnectionManager cm = (IConnectionManager)this.getSite().getRoot().getAdapter(IConnectionManager.class);
        if (cm != null) {
            cm.deleteConnection(this);
            cm.addPendingSource(dependency.getTaskId(), dependency, dependency.getSuccessor().getId());
        }
    }

    private void changeSourceNode(INodePart newSource) {
        INodePart oldSource = this.getSourceNode();
        this.setSourceNode(newSource);
        if (oldSource != null) {
            oldSource.removeSourceConnection((IConnectionPart)this);
        }
        newSource.addSourceConnection((IConnectionPart)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update(evt.getPropertyName());
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        this.getRequestHandler().installEditPolicy("selectable role", (IEditPolicy)DependencySelectablePolicy.getInstance());
    }
}

