/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.Calendar;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.resources.ColorUtils;

public class DaysBackgroundFigure
extends Figure {
    private static final int DAYS_WIDTH = 25;
    private static final int DAYS_OF_WEEK_WIDTH = 26;
    private TimelineModel timelineModel;
    private Calendar currentStartCalendar;
    private Calendar currentEndCalendar;
    private boolean isWholeStart;
    private boolean isWholeEnd;
    private boolean isDaysOfWeek;
    private int height;

    public DaysBackgroundFigure(TimelineModel timelineModel, Calendar currentStartCalendar, Calendar currentEndCalendar, boolean isStartFull, boolean isEndFull, int height, boolean isDaysOfWeek) {
        this.timelineModel = timelineModel;
        this.currentStartCalendar = (Calendar)currentStartCalendar.clone();
        this.currentEndCalendar = (Calendar)currentEndCalendar.clone();
        this.isWholeStart = isStartFull;
        this.isWholeEnd = isEndFull;
        this.height = height;
        this.isDaysOfWeek = isDaysOfWeek;
    }

    protected void paintFigure(Graphics graphics) {
        int width = 25;
        if (this.isDaysOfWeek) {
            width = 26;
        }
        int startX = this.getXByCalendar(this.currentStartCalendar);
        int endX = this.getXByCalendar(this.currentEndCalendar);
        graphics.setBackgroundColor(ColorUtils.getColor((String)"#f7f7f7"));
        graphics.setForegroundColor(ColorConstants.white);
        if (this.isWholeStart && this.isWholeEnd) {
            graphics.fillRectangle(startX, 0, width, this.height);
            graphics.fillRectangle(startX + width + 1, 0, width, this.height);
        } else if (this.isWholeStart && !this.isWholeEnd) {
            if (endX - startX <= width) {
                graphics.fillRectangle(startX, 0, endX - startX, this.height);
            } else {
                graphics.fillRectangle(startX, 0, width, this.height);
                if (endX - startX > width + 1) {
                    graphics.fillRectangle(startX + width + 1, 0, endX - startX - width - 1, this.height);
                }
            }
        } else if (!this.isWholeStart && this.isWholeEnd) {
            if (endX - startX <= width) {
                graphics.fillRectangle(startX, 0, endX - startX, this.height);
            } else {
                if (endX - startX > width + 1) {
                    graphics.fillRectangle(startX, 0, endX - startX - width - 1, this.height);
                }
                graphics.fillRectangle(endX - width, 0, width, this.height);
            }
        }
    }

    private int getXByCalendar(Calendar calendar) {
        return this.timelineModel.getPixelsFromMillis(calendar.getTimeInMillis() - this.timelineModel.getOriginDate().getTimeInMillis());
    }
}

