/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.ui.gantt2.gefext.BackgroundManager;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;

public class BackgroundLineManager
extends BackgroundManager {
    private IFigure backgroundLine;
    private FigureListener listener;

    public void update() {
        if (this.backgroundLine == null) {
            this.createFigure();
        }
        IFigure titleLayer = this.host.getTitleLayer();
        Rectangle r = new Rectangle(titleLayer.getBounds());
        this.backgroundLine.setVisible(this.host.getFigure().isShowing() && this.host.isHostFigureVisible());
        this.backgroundLine.setBounds(new Rectangle(0, r.y + r.height - 1, this.host.getWidthsSupport().sum() + 1, 1));
    }

    private void createFigure() {
        this.backgroundLine = new Label();
        this.backgroundLine.setBorder((Border)new LineBorder());
        this.backgroundLine.setForegroundColor(Colors.split());
        this.getTargetLayer().add(this.backgroundLine);
        this.addFigureListener();
    }

    private void addFigureListener() {
        this.listener = new FigureListener(){

            public void figureMoved(IFigure source) {
                Rectangle r = new Rectangle(BackgroundLineManager.this.host.getTitleLayer().getBounds());
                if (BackgroundLineManager.this.backgroundLine != null && BackgroundLineManager.this.backgroundLine.isVisible()) {
                    BackgroundLineManager.this.backgroundLine.setBounds(new Rectangle(0, r.y + r.height - 1, BackgroundLineManager.this.host.getWidthsSupport().sum() + 1, 1));
                    BackgroundLineManager.this.backgroundLine.revalidate();
                }
            }
        };
        this.host.getTitleLayer().addFigureListener(this.listener);
    }

    public void dispose() {
        if (this.backgroundLine != null) {
            this.getTargetLayer().remove(this.backgroundLine);
            this.host.getTitle().removeFigureListener(this.listener);
            this.backgroundLine = null;
        }
        super.dispose();
    }

    protected Layer doGetTargetLayer() {
        return this.getRootPart(this.host).getLayer(TaskTreeViewer.LAYER_BACKGROUND_LINE);
    }
}

