/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import java.util.HashMap;
import java.util.Map;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.ui.gantt2.gefext.AbstractTracker;

public abstract class AbstractDragTracker
extends AbstractTracker {
    private Status initStatus = null;
    private Status currentStatus = null;

    public boolean handleMouseDown(MouseEvent me, IViewer viewer) {
        Status status = new Status();
        boolean started = this.captureInitialStatus(me, status);
        this.initStatus = started ? status : null;
        Status status2 = this.currentStatus = started ? new Status(status) : null;
        if (started) {
            this.applyStatus(this.currentStatus);
        }
        return started;
    }

    public boolean handleMouseUp(MouseEvent me, IViewer viewer) {
        if (this.initStatus == null) {
            return false;
        }
        boolean updated = this.updateStatus(me, this.initStatus, this.currentStatus);
        if (updated) {
            ICommandStack commandStack = this.getEditDomain().getCommandStack();
            Command command = commandStack == null ? null : this.getCommand(this.initStatus, this.currentStatus);
            this.restoreStatus(this.initStatus);
            if (commandStack != null && command != null) {
                commandStack.execute(command);
            }
            this.initStatus = null;
            this.currentStatus = null;
        }
        return updated;
    }

    public boolean handleMouseDrag(MouseDragEvent me, IViewer viewer) {
        if (this.initStatus == null) {
            return false;
        }
        boolean updated = this.updateStatus((MouseEvent)me, this.initStatus, this.currentStatus);
        if (updated) {
            this.applyStatus(this.currentStatus);
        }
        return updated;
    }

    public void deactivate() {
        if (this.initStatus != null) {
            this.restoreStatus(this.initStatus);
            this.initStatus = null;
            this.currentStatus = null;
        }
        super.deactivate();
    }

    protected Status getInitStatus() {
        return this.initStatus;
    }

    protected Status getCurrentStatus() {
        return this.currentStatus;
    }

    protected void restoreStatus(Status initStatus) {
        this.applyStatus(initStatus);
    }

    protected abstract boolean captureInitialStatus(MouseEvent var1, Status var2);

    protected abstract void applyStatus(Status var1);

    protected abstract boolean updateStatus(MouseEvent var1, Status var2, Status var3);

    protected abstract Command getCommand(Status var1, Status var2);

    protected static class Status {
        private Map<Object, Object> map;

        public Status() {
            this.map = new HashMap<Object, Object>();
        }

        public Status(Status source) {
            this.map = new HashMap<Object, Object>(source.map);
        }

        public Status set(Object key, Object value) {
            this.map.put(key, value);
            return this;
        }

        public Status set(Object key, int value) {
            this.map.put(key, value);
            return this;
        }

        public Status set(Object key, boolean value) {
            this.map.put(key, value);
            return this;
        }

        public Status putAll(Status source) {
            this.map = new HashMap<Object, Object>(source.map);
            return this;
        }

        public Status clear() {
            this.map.clear();
            return this;
        }

        public Object get(Object key) {
            return this.map.get(key);
        }

        public int getInteger(Object key, int defaultValue) {
            Object value = this.map.get(key);
            return value instanceof Integer ? (Integer)value : defaultValue;
        }

        public boolean getBoolean(Object key, boolean defaultValue) {
            Object value = this.map.get(key);
            return value instanceof Boolean ? (Boolean)value : defaultValue;
        }

        public String toString() {
            return this.map.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof Status)) {
                return false;
            }
            Status that = (Status)obj;
            return this.map.equals(that.map);
        }
    }
}

