/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.Arrays;
import org.eclipse.swt.widgets.Label;
import org.xmind.core.ISheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ISourceTool;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryEditCover;
import org.xmind.ui.internal.presentation.slide.StoryTitleEditTool;

public class StoryTitleEditor {
    private static final String TOOL_EDIT_STORY_TITLE = "org.xmind.ui.tool.editStoryTitle";
    private IGraphicalEditor editor;
    private PresentationStory story;
    private PresentationStoryEditCover cover;
    private Label source;

    public StoryTitleEditor(IGraphicalEditor editor, PresentationStory story, PresentationStoryEditCover cover) {
        this.editor = editor;
        this.story = story;
        this.cover = cover;
    }

    public void setStory(PresentationStory story) {
        this.story = story;
    }

    public void setSource(Label source) {
        this.source = source;
    }

    public void startEditing() {
        IGraphicalEditorPage page = this.editor.getActivePageInstance();
        if (page == null) {
            return;
        }
        IGraphicalViewer viewer = page.getViewer();
        if (viewer == null) {
            return;
        }
        EditDomain editDomain = page.getEditDomain();
        if (editDomain == null) {
            return;
        }
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet == null) {
            return;
        }
        IPart part = viewer.findPart((Object)sheet);
        if (part == null || !(part instanceof IGraphicalEditPart)) {
            return;
        }
        IGraphicalEditPart sourcePart = (IGraphicalEditPart)part;
        ITool tool = editDomain.getTool(TOOL_EDIT_STORY_TITLE);
        if (tool == null) {
            editDomain.installTool(TOOL_EDIT_STORY_TITLE, (ITool)new StoryTitleEditTool());
            tool = editDomain.getTool(TOOL_EDIT_STORY_TITLE);
        }
        if (tool == null) {
            return;
        }
        if (tool instanceof ISourceTool) {
            ((ISourceTool)tool).setSource(sourcePart);
        }
        editDomain.setActiveTool(TOOL_EDIT_STORY_TITLE);
        if (tool != editDomain.getActiveTool()) {
            return;
        }
        ((StoryTitleEditTool)tool).setTextEditorParameters(this.story, this.source, this.cover);
        tool.handleRequest(new Request("edit").setViewer((IViewer)viewer).setTargets(Arrays.asList(sourcePart)));
    }
}

