/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.xmind.gef.command.Command;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.slide.AddSlideCommand;
import org.xmind.ui.internal.presentation.slide.DeleteSlideCommand;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryGalleryViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationGallerySelectTool
extends GallerySelectTool {
    private IEditorPart editor;
    private boolean playMode;

    public PresentationGallerySelectTool(IEditorPart editor, boolean playMode) {
        this.editor = editor;
        this.playMode = playMode;
    }

    public boolean handleMouseUp(MouseEvent me) {
        if (this.playMode) {
            return super.handleMouseUp(me);
        }
        Shell shell = me.target.getSite().getShell();
        final List<PresentationSlide> selections = this.getSelections();
        if (!me.leftOrRight && !selections.isEmpty()) {
            Menu m = new Menu((Control)shell);
            MenuItem duplicateItem = new MenuItem(m, 8);
            duplicateItem.setText(PresentationMessages.SlideDuplicate_label);
            duplicateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (selections.isEmpty()) {
                        return;
                    }
                    PresentationStory story = ((PresentationSlide)selections.get(0)).getStory();
                    if (selections.size() == 1) {
                        PresentationSlide slide = (PresentationSlide)selections.get(0);
                        if (slide != null) {
                            int i = slide.getIndex();
                            PresentationSlide slideCopy = story.createSlide(slide);
                            AddSlideCommand cmd = new AddSlideCommand(story, slideCopy, i + 1);
                            if (PresentationGallerySelectTool.this.editor instanceof IGraphicalEditor) {
                                ((IGraphicalEditor)PresentationGallerySelectTool.this.editor).getCommandStack().execute((Command)cmd);
                            }
                        }
                    } else {
                        ArrayList<PresentationSlide> copies = new ArrayList<PresentationSlide>();
                        for (PresentationSlide s : selections) {
                            PresentationSlide copy = story.createSlide(s);
                            copies.add(copy);
                        }
                        if (!copies.isEmpty()) {
                            AddSlideCommand cmd = new AddSlideCommand(story, copies);
                            if (PresentationGallerySelectTool.this.editor instanceof IGraphicalEditor) {
                                ((IGraphicalEditor)PresentationGallerySelectTool.this.editor).getCommandStack().execute((Command)cmd);
                            }
                        }
                    }
                    PresentationGallerySelectTool.this.refresh(story);
                }
            });
            MenuItem deleteItem = new MenuItem(m, 8);
            deleteItem.setText(PresentationMessages.SlideDelete_label);
            deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!selections.isEmpty()) {
                        PresentationStory story = ((PresentationSlide)selections.get(0)).getStory();
                        DeleteSlideCommand cmd = new DeleteSlideCommand(story, selections);
                        if (PresentationGallerySelectTool.this.editor instanceof IGraphicalEditor) {
                            ((IGraphicalEditor)PresentationGallerySelectTool.this.editor).getCommandStack().execute((Command)cmd);
                            PresentationGallerySelectTool.this.refresh(story);
                        }
                    }
                }
            });
            m.setVisible(true);
        }
        return super.handleMouseUp(me);
    }

    private void refresh(PresentationStory story) {
        this.getTargetViewer().setInput(story.getSlides());
    }

    public List<PresentationSlide> getSelections() {
        if (this.getTargetViewer() instanceof PresentationStoryGalleryViewer) {
            return ((PresentationStoryGalleryViewer)this.getTargetViewer()).getSlideSelections();
        }
        return Collections.emptyList();
    }
}

