/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.gef.EditDomain;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryNavigablePolicy;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.gallery.ILabelDecorator;
import org.xmind.ui.internal.iconfinder.DecoratedContainerLayout;
import org.xmind.ui.internal.iconfinder.IconfinderActivator;
import org.xmind.ui.internal.iconfinder.IconfinderContainer;
import org.xmind.ui.internal.iconfinder.IconfinderCore;
import org.xmind.ui.internal.iconfinder.IconfinderIconTransfer;
import org.xmind.ui.internal.iconfinder.IconsetDialog;
import org.xmind.ui.internal.iconfinder.Messages;
import org.xmind.ui.internal.iconfinder.model.Icon;
import org.xmind.ui.resources.ColorUtils;

public class IconfinderViewer
extends GalleryViewer {
    public static final Object MORE_ICON = "MORE_ICON";
    private static final String Iconset_Dropdown_Image = "/image/dropdowniconset.png";
    private boolean showIconsetDialog = false;
    private boolean hasIconsetEntrance = false;
    private IconfinderContainer iconfinderContainer;
    private LocalResourceManager localResourceManager;

    public IconfinderViewer(final IconfinderContainer iconfinderContainer, Composite container) {
        this.iconfinderContainer = iconfinderContainer;
        this.initViewer();
        Control control = this.createControl(container);
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), control);
        this.createDragSource(control);
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Object element;
                ISelection selection = IconfinderViewer.this.getSelection();
                if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof Icon) {
                    Icon icon = (Icon)element;
                    if (IconfinderViewer.this.showIconsetDialog) {
                        VerifyUI20141031.getUsageDataCollector().increase(String.format("Iconfinder/SearchCount/%s", "Iconset"));
                        IconfinderViewer.this.showIconsetDialog = false;
                        IconsetDialog iconsetDialog = new IconsetDialog(IconfinderViewer.this.getControl().getShell(), iconfinderContainer, icon);
                        Point point = IconfinderViewer.this.getCanvas().toDisplay(new Point(e.x, e.y + 20));
                        iconsetDialog.open(point);
                        IconfinderCore.getInstance().requestIconsetBy(icon, iconfinderContainer.getSearchIconSessionId(), false);
                    }
                }
            }
        });
    }

    private void initViewer() {
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new IconfinderSelectTool());
        editDomain.installEditPolicy("org.xmind.ui.gallery.editPolicy.navigable", (IEditPolicy)new GalleryNavigablePolicy());
        this.setEditDomain(editDomain);
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("stretched", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 1, 1, 1, new Insets(0)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(70, 70));
        properties.set("org.xmind.ui.gallery.contentPaneMargins", (Object)new Insets(5));
        properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IconfinderViewer.this.update();
            }
        });
        this.setContentProvider(new IconfinderContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new IconfinderLabelProvider());
    }

    private void createDragSource(Control control) {
        final DragSource dragSource = new DragSource(control, 1);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dragSource.dispose();
            }
        });
        dragSource.setTransfer(new Transfer[]{IconfinderIconTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            Icon[] selectedIcons;

            public void dragStart(DragSourceEvent event) {
                this.selectedIcons = this.getSelectedIcons();
                if (this.selectedIcons.length == 0) {
                    event.doit = false;
                }
            }

            private Icon[] getSelectedIcons() {
                ArrayList<Icon> icons = new ArrayList<Icon>();
                ISelection selection = IconfinderViewer.this.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    for (Object o : ss.toList()) {
                        if (!(o instanceof Icon)) continue;
                        VerifyUI20141031.getUsageDataCollector().increase("Iconfinder/Icon/UseCount");
                        icons.add((Icon)o);
                    }
                }
                return icons.toArray(new Icon[icons.size()]);
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.selectedIcons;
            }

            public void dragFinished(DragSourceEvent event) {
                this.selectedIcons = null;
            }
        });
    }

    public void setIconsetEntrance(boolean showIconsetEntrance) {
        this.hasIconsetEntrance = showIconsetEntrance;
    }

    private boolean hasIconsetEntrance() {
        return this.hasIconsetEntrance;
    }

    protected Viewport getViewport() {
        return super.getViewport();
    }

    private class IconfinderContentProvider
    implements IStructuredContentProvider {
        private IconfinderContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List icons = (List)inputElement;
                return icons.toArray();
            }
            return null;
        }
    }

    private class IconfinderLabelProvider
    extends LabelProvider
    implements ILabelDecorator {
        private IconfinderLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof Icon) {
                Icon icon = (Icon)element;
                File iconPreviewFile = IconfinderCore.getIconPreviewFile(IconfinderViewer.this.iconfinderContainer.getSearchIconSessionId(), icon.getIconId());
                if (iconPreviewFile.exists()) {
                    URL url = null;
                    try {
                        url = iconPreviewFile.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        IconfinderActivator.log(e, "Failed to create url from file: " + iconPreviewFile.getAbsolutePath());
                    }
                    if (url != null) {
                        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                        return IconfinderViewer.this.localResourceManager.createImage(imageDescriptor);
                    }
                }
            }
            return super.getImage(element);
        }

        public IFigure decorateFigure(IFigure figure, Object element, IDecorationContext context) {
            if (!(element instanceof Icon)) {
                return this.decorateSpecialFigure(figure, element, context);
            }
            return this.decorateFrameFigure(figure, (Icon)element, context);
        }

        private IFigure decorateSpecialFigure(IFigure contentPane, Object specialModel, IDecorationContext context) {
            String loadingOrMore = IconfinderViewer.this.iconfinderContainer.isLoading() ? Messages.Iconfinder_LoadingState_label : Messages.Iconfinder_MoreIcons_label;
            Label figure = null;
            List figures = contentPane.getChildren();
            boolean needInitFigureContent = figures.isEmpty();
            if (needInitFigureContent) {
                contentPane.setLayoutManager((LayoutManager)new IconfinderFrameContentLayout(context));
                figure = new Label(loadingOrMore, null);
                contentPane.add((IFigure)figure);
            } else {
                figure = (Label)figures.get(0);
                figure.setText(loadingOrMore);
            }
            if (figure != null) {
                String colorValue = IconfinderViewer.this.iconfinderContainer.isLoading() ? "#8f8f8f" : "#4A90E2";
                Color fgColor = (Color)IconfinderViewer.this.localResourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)colorValue)));
                figure.setForegroundColor(fgColor);
            }
            return contentPane;
        }

        private IFigure decorateFrameFigure(IFigure contentPane, Icon icon, IDecorationContext context) {
            SizeableImageFigure iconsetFigure;
            SizeableImageFigure iconFigure;
            List figures = contentPane.getChildren();
            boolean needInitFigureContent = figures.isEmpty();
            if (needInitFigureContent) {
                contentPane.setLayoutManager((LayoutManager)new IconfinderFrameContentLayout(context));
                iconFigure = new SizeableImageFigure(this.getImage(icon));
                iconsetFigure = new SizeableImageFigure(this.getIconsetImage(icon));
                contentPane.add((IFigure)iconFigure);
                contentPane.add((IFigure)iconsetFigure, (Object)36);
                if (context != null) {
                    boolean imageConstrained = Boolean.TRUE.equals(context.getProperty("constrained", (Object)false));
                    boolean imageStretched = Boolean.TRUE.equals(context.getProperty("stretched", (Object)false));
                    iconFigure.setConstrained(imageConstrained);
                    iconFigure.setStretched(imageStretched);
                    Insets margins = (Insets)context.getProperty("org.xmind.ui.gallery.contentPaneMargins", (Object)new Insets());
                    iconFigure.setMargins(margins);
                }
            } else {
                iconFigure = (SizeableImageFigure)figures.get(0);
                iconsetFigure = (SizeableImageFigure)figures.get(1);
            }
            iconFigure.setImage(this.getImage(icon));
            iconsetFigure.setImage(this.getIconsetImage(icon));
            return contentPane;
        }

        private Image getIconsetImage(Icon icon) {
            ISelection selection = IconfinderViewer.this.getSelection();
            if (selection instanceof IStructuredSelection && IconfinderViewer.this.hasIconsetEntrance() && icon.equals(((IStructuredSelection)selection).getFirstElement())) {
                return (Image)JFaceResources.getResources().get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor(IconfinderViewer.Iconset_Dropdown_Image));
            }
            return null;
        }

        private class IconfinderFrameContentLayout
        extends DecoratedContainerLayout {
            private IDecorationContext context;

            public IconfinderFrameContentLayout(IDecorationContext context) {
                this.context = context;
            }

            @Override
            protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
                if (this.context != null) {
                    Insets insets = figure.getInsets();
                    Dimension contentSize = (Dimension)this.context.getProperty("org.xmind.ui.gallery.frameContentSize", null);
                    if (contentSize != null) {
                        return new Dimension(contentSize.width + insets.getWidth(), contentSize.height + insets.getHeight());
                    }
                }
                return super.calculatePreferredSize(figure, wHint, hHint);
            }
        }
    }

    private class IconfinderSelectTool
    extends GallerySelectTool {
        private static final int RIGHT_BOTTOM_IMAGE_SIZE = 20;

        private IconfinderSelectTool() {
        }

        protected boolean handleMouseDown(org.xmind.gef.event.MouseEvent me) {
            IPart target = me.target;
            Object model = target.getModel();
            if (target instanceof FramePart) {
                FramePart targetFrame = (FramePart)me.target;
                Rectangle bounds = targetFrame.getFigure().getBounds();
                int x = bounds.x + bounds.width - 20;
                int y = bounds.y + bounds.height - 20;
                Rectangle rect = new Rectangle(x, y, 20, 20);
                boolean hiting = rect.contains(this.getCursorPosition());
                if (model instanceof Icon && IconfinderViewer.this.hasIconsetEntrance() && hiting) {
                    IconfinderViewer.this.showIconsetDialog = true;
                } else if (MORE_ICON.equals(model) && !IconfinderViewer.this.iconfinderContainer.isLoading()) {
                    IconfinderViewer.this.iconfinderContainer.moreSearch();
                }
            }
            return super.handleMouseDown(me);
        }
    }
}

