/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.xmind.ui.internal.browser.BrowserPlugin;

public class BrowserImages {
    public static final String PATH_ICONS = "icons/";
    public static final String PATH_ENABLED = "icons/e/";
    public static final String PATH_DISABLED = "icons/d/";
    public static final String XMIND = "icons/xmind.16.png";
    public static final String BROWSER = "icons/browser.gif";
    public static final String BACKWARD = "backward_nav.gif";
    public static final String FORWARD = "forward_nav.gif";
    public static final String REFRESH = "refresh_nav.gif";
    public static final String STOP = "nav_stop.gif";
    public static final String GO = "nav_go.gif";
    private static Map<String, ImageDescriptor> cache = new HashMap<String, ImageDescriptor>();
    private static ImageDescriptor[] busyImages = null;

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor img = cache.get(path);
        if (img == null && (img = BrowserPlugin.imageDescriptorFromPlugin((String)"org.xmind.ui.browser", (String)path)) != null) {
            cache.put(path, img);
        }
        return img;
    }

    public static ImageDescriptor getImageDescriptor(String fileName, boolean enabled) {
        String path = String.valueOf(enabled ? PATH_ENABLED : PATH_DISABLED) + fileName;
        return BrowserImages.getImageDescriptor(path);
    }

    public static Image getImage(String path) {
        ImageRegistry reg = BrowserPlugin.getDefault().getImageRegistry();
        Image image = reg.get(path);
        if (image == null) {
            reg.put(path, BrowserImages.getImageDescriptor(path));
            image = reg.get(path);
        }
        return image;
    }

    public static Image getImage(String fileName, boolean enabled) {
        String path = String.valueOf(enabled ? PATH_ENABLED : PATH_DISABLED) + fileName;
        return BrowserImages.getImage(path);
    }

    public static ImageDescriptor[] getBusyImages() {
        if (busyImages == null) {
            busyImages = new ImageDescriptor[12];
            int i = 0;
            while (i < 12) {
                String path = String.format("icons/busy/busy_f%02d.gif", i + 1);
                BrowserImages.busyImages[i] = BrowserImages.getImageDescriptor(path);
                ++i;
            }
        }
        return busyImages;
    }
}

