/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.texteditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.texteditor.IFloatingTextEditorListener;
import org.xmind.ui.texteditor.TextEvent;
import org.xmind.ui.viewers.ICompositeProvider;
import org.xmind.ui.viewers.SWTUtils;
import org.xmind.ui.viewers.SameCompositeProvider;

public class FloatingTextEditor
extends Viewer
implements ITextOperationTarget {
    private static int DEFAULT_STYLE = 2820;
    private int style = DEFAULT_STYLE;
    private ICompositeProvider compositeProvider;
    private Composite control = null;
    private IDocument document = null;
    private ITextViewer textViewer = null;
    private IDocumentListener documentListener = null;
    private List<IFloatingTextEditorListener> textEditorListeners = null;
    private List<VerifyKeyListener> verifyKeyListeners = null;
    private TextViewerHooker textViewerHooker = null;
    private boolean closing = false;
    private Point initialLocation = null;
    private Point initialSize = null;

    public FloatingTextEditor(Composite parent) {
        this(new SameCompositeProvider(parent), DEFAULT_STYLE);
    }

    public FloatingTextEditor(Composite parent, int style) {
        this(new SameCompositeProvider(parent), style);
    }

    public FloatingTextEditor(ICompositeProvider compositeProvider) {
        this(compositeProvider, DEFAULT_STYLE);
    }

    public FloatingTextEditor(ICompositeProvider compositeProvider, int style) {
        Assert.isNotNull((Object)compositeProvider);
        this.compositeProvider = compositeProvider;
        this.style = style;
    }

    protected Composite getParentComposite() {
        return this.compositeProvider.getParent();
    }

    protected void setEditorStyle(int style) {
        this.style = style;
    }

    protected int getEditorStyle() {
        return this.style;
    }

    public boolean open() {
        return this.open(true);
    }

    public boolean open(boolean withFocus) {
        if (!this.isClosed()) {
            return true;
        }
        TextEvent e = this.createTextEvent();
        this.fireEditingAboutToStart(e);
        if (e.isCanceled()) {
            return false;
        }
        Composite parent = this.getParentComposite();
        if (parent == null) {
            return false;
        }
        if (this.isClosed()) {
            this.createControl(parent, this.getEditorStyle());
        }
        if (this.isClosed()) {
            return false;
        }
        this.control.setVisible(true);
        if (withFocus) {
            this.setFocus();
        }
        this.fireEditingStarted(this.createTextEvent());
        return true;
    }

    public void setFocus() {
        if (this.textViewer != null && !this.textViewer.getTextWidget().isDisposed()) {
            this.textViewer.getTextWidget().setFocus();
        } else if (this.control != null && !this.control.isDisposed()) {
            this.control.setFocus();
        }
    }

    public boolean close() {
        return this.close(false);
    }

    public boolean close(boolean finish) {
        if (this.isClosed() || this.closing) {
            return true;
        }
        this.closing = true;
        TextEvent e = this.createTextEvent();
        if (finish) {
            this.fireEditingAboutToFinish(e);
        } else {
            this.fireEditingAboutToCancel(e);
        }
        if (e.isCanceled()) {
            this.closing = false;
            return false;
        }
        this.hardClose(finish);
        if (finish) {
            this.fireEditingFinished(this.createTextEvent());
        } else {
            this.fireEditingCanceled(this.createTextEvent());
        }
        this.closing = false;
        return true;
    }

    protected void hardClose(boolean finish) {
        if (this.textViewer != null) {
            this.unhookTextViewer(this.textViewer);
        }
        if (this.document != null) {
            this.unhookDocument(this.document);
        }
        if (!finish) {
            this.hardCancel();
        }
        Composite parent = this.control.getParent();
        boolean wasFocused = this.isFocused();
        this.control.dispose();
        if (wasFocused && parent.getShell() == parent.getDisplay().getActiveShell()) {
            parent.setFocus();
        }
    }

    protected boolean isFocused() {
        return this.textViewer != null && !this.textViewer.getTextWidget().isDisposed() && this.textViewer.getTextWidget().isFocusControl();
    }

    protected void hardCancel() {
        if (this.document != null) {
            while (this.canDoOperation(1)) {
                this.doOperation(1);
            }
        }
    }

    protected TextEvent createTextEvent() {
        return new TextEvent((Object)this, this.getTextContents());
    }

    public String getTextContents() {
        return this.document == null ? null : this.document.get();
    }

    private void createControl(Composite parent, int style) {
        boolean border = (style & 0x800) != 0;
        this.control = this.createContainer(parent, border);
        this.textViewer = this.createTextViewer(this.control, style &= 0xFFF7F7FF);
        this.configureContainer(this.control);
        this.hookContainer(this.control);
        this.configureTextViewer(this.textViewer);
        this.hookTextViewer(this.textViewer);
        if (this.document != null) {
            this.hookDocument(this.document);
        }
    }

    private Composite createContainer(Composite parent, boolean border) {
        Composite composite = new Composite(parent, 524288);
        composite.setBackground(parent.getDisplay().getSystemColor(15));
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        if (border) {
            layout.marginWidth = 1;
            layout.marginHeight = 1;
        }
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected void configureContainer(Composite container) {
        Point size = this.getInitialSize();
        Point position = this.getInitialPosition(size);
        container.setBounds(position.x, position.y, size.x, size.y);
    }

    protected Point getInitialSize() {
        if (this.initialSize != null) {
            return this.initialSize;
        }
        return new Point(100, 20);
    }

    protected Point getInitialPosition(Point size) {
        if (this.initialLocation != null) {
            return this.initialLocation;
        }
        return new Point(0, 0);
    }

    protected void hookContainer(Composite container) {
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FloatingTextEditor.this.handleDispose(e);
            }
        });
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.document != null) {
            this.unhookDocument(this.document);
        }
        if (this.textViewer != null) {
            this.unhookTextViewer(this.textViewer);
            this.textViewer = null;
        }
        this.control = null;
    }

    protected ITextViewer createTextViewer(Composite parent, int style) {
        TextViewer viewer = new TextViewer(parent, style){

            protected int getEmptySelectionChangedEventDelay() {
                return 300;
            }

            protected StyledText createTextWidget(Composite parent, int styles) {
                StyledText styledText = new StyledText(parent, styles){

                    public void invokeAction(int action) {
                        super.invokeAction(action);
                        switch (action) {
                            case 127: {
                                Event event = new Event();
                                this.notifyListeners(24, event);
                                return;
                            }
                        }
                    }
                };
                styledText.setLeftMargin(Math.max(styledText.getLeftMargin(), 2));
                return styledText;
            }
        };
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        return viewer;
    }

    protected void configureTextViewer(ITextViewer viewer) {
        if (this.getDocument() != null) {
            viewer.setDocument(this.getDocument());
        }
        viewer.setUndoManager((IUndoManager)new TextViewerUndoManager(20));
        viewer.activatePlugins();
    }

    protected void hookTextViewer(ITextViewer viewer) {
        if (this.textViewerHooker == null) {
            this.textViewerHooker = new TextViewerHooker();
        }
        this.textViewerHooker.hook(viewer);
    }

    protected void unhookTextViewer(ITextViewer viewer) {
        if (this.textViewerHooker != null) {
            this.textViewerHooker.unhook(viewer);
            this.textViewerHooker = null;
        }
    }

    protected void handleVerifyKey(VerifyEvent event) {
        this.fireVerifyKey(event);
        if (!event.doit) {
            return;
        }
        int stateMask = event.stateMask;
        int keyCode = event.keyCode;
        if (SWTUtils.matchKey(stateMask, keyCode, SWT.MOD2, 13)) {
            if ((this.getEditorStyle() & 2) == 0) {
                event.doit = false;
            }
        } else if (SWTUtils.matchKey(stateMask, keyCode, SWT.MOD1, 122)) {
            event.doit = false;
            if (this.canDoOperation(1)) {
                this.doOperation(1);
            }
        } else if (SWTUtils.matchKey(stateMask, keyCode, SWT.MOD1, 121)) {
            event.doit = false;
            if (this.canDoOperation(2)) {
                this.doOperation(2);
            }
        }
    }

    protected void handleTraverseKey(TraverseEvent event) {
        if (event.detail == 2) {
            this.fireTraverseKey(event, event.stateMask, 27);
            if (!event.doit) {
                return;
            }
            event.doit = false;
            this.cancelEditing();
        } else if (event.detail == 4) {
            this.fireTraverseKey(event, event.stateMask, 13);
            if (!event.doit) {
                return;
            }
            if (event.stateMask == 0) {
                event.doit = false;
                this.finishEditing();
            } else if ((event.stateMask & SWT.MOD2) != 0 && (this.getEditorStyle() & 2) == 0) {
                event.doit = false;
            }
        }
    }

    protected void replaceText(int offset, int length, String text) {
        if (this.document == null) {
            return;
        }
        try {
            this.document.replace(offset, length, text);
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void finishEditing() {
        this.close(true);
    }

    protected void cancelEditing() {
        this.close(false);
    }

    protected void hookDocument(IDocument document) {
        if (this.documentListener == null) {
            this.documentListener = new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    FloatingTextEditor.this.fireTextChanged(FloatingTextEditor.this.createTextEvent());
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                    FloatingTextEditor.this.fireTextAboutToChange(FloatingTextEditor.this.createTextEvent());
                }
            };
        }
        document.addDocumentListener(this.documentListener);
    }

    protected void unhookDocument(IDocument document) {
        if (document != null && this.documentListener != null) {
            document.removeDocumentListener(this.documentListener);
            this.documentListener = null;
        }
    }

    public boolean isClosed() {
        return this.control == null || this.control.isDisposed();
    }

    public Control getControl() {
        return this.control;
    }

    public Object getInput() {
        return this.getDocument();
    }

    protected IDocument getDocument() {
        return this.document;
    }

    public ISelection getSelection() {
        if (this.textViewer instanceof ISelectionProvider) {
            return ((ISelectionProvider)this.textViewer).getSelection();
        }
        return null;
    }

    public void refresh() {
        if (this.textViewer instanceof Viewer) {
            ((Viewer)this.textViewer).refresh();
        }
    }

    public void setInput(Object input) {
        if (!(input instanceof IDocument)) {
            return;
        }
        IDocument newDocument = (IDocument)input;
        IDocument oldDocument = this.document;
        if (newDocument == oldDocument || newDocument != null && newDocument.equals(oldDocument)) {
            return;
        }
        this.document = newDocument;
        this.documentChanged(oldDocument, newDocument);
    }

    protected void documentChanged(IDocument oldDocument, IDocument newDocument) {
        if (oldDocument != null) {
            this.unhookDocument(oldDocument);
        }
        if (this.textViewer != null) {
            this.textViewer.setDocument(newDocument);
            if (newDocument != null) {
                this.hookDocument(newDocument);
            }
        }
        this.inputChanged(newDocument, oldDocument);
    }

    public void setSelection(ISelection selection) {
        if (this.textViewer instanceof ISelectionProvider) {
            ((ISelectionProvider)this.textViewer).setSelection(selection);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.textViewer instanceof Viewer) {
            ((Viewer)this.textViewer).setSelection(selection, reveal);
        }
    }

    public ITextViewer getTextViewer() {
        return this.textViewer;
    }

    public void doOperation(int operation) {
        if (this.textViewer instanceof ITextOperationTarget) {
            ((ITextOperationTarget)this.textViewer).doOperation(operation);
        }
    }

    public boolean canDoOperation(int operation) {
        if (this.textViewer instanceof ITextOperationTarget) {
            return ((ITextOperationTarget)this.textViewer).canDoOperation(operation);
        }
        return false;
    }

    public void addFloatingTextEditorListener(IFloatingTextEditorListener listener) {
        if (this.textEditorListeners == null) {
            this.textEditorListeners = new ArrayList<IFloatingTextEditorListener>();
        }
        this.textEditorListeners.add(listener);
    }

    public void removeFloatingTextEditorListener(IFloatingTextEditorListener listener) {
        if (this.textEditorListeners == null) {
            return;
        }
        this.textEditorListeners.remove(listener);
    }

    protected void fireEditingAboutToStart(TextEvent e) {
        if (this.textEditorListeners == null) {
            return;
        }
        Object[] objectArray = this.textEditorListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IFloatingTextEditorListener)l).editingAboutToStart(e);
            ++n2;
        }
    }

    protected void fireEditingStarted(TextEvent e) {
        if (this.textEditorListeners == null) {
            return;
        }
        Object[] objectArray = this.textEditorListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IFloatingTextEditorListener)l).editingStarted(e);
            ++n2;
        }
    }

    protected void fireEditingAboutToCancel(TextEvent e) {
        if (this.textEditorListeners == null) {
            return;
        }
        Object[] objectArray = this.textEditorListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IFloatingTextEditorListener)l).editingAboutToCancel(e);
            ++n2;
        }
    }

    protected void fireEditingCanceled(TextEvent e) {
        if (this.textEditorListeners == null) {
            return;
        }
        Object[] objectArray = this.textEditorListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IFloatingTextEditorListener)l).editingCanceled(e);
            ++n2;
        }
    }

    protected void fireEditingAboutToFinish(TextEvent e) {
        if (this.textEditorListeners == null) {
            return;
        }
        Object[] objectArray = this.textEditorListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IFloatingTextEditorListener)l).editingAboutToFinish(e);
            ++n2;
        }
    }

    protected void fireEditingFinished(TextEvent e) {
        if (this.textEditorListeners == null) {
            return;
        }
        Object[] objectArray = this.textEditorListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IFloatingTextEditorListener)l).editingFinished(e);
            ++n2;
        }
    }

    protected void fireTextAboutToChange(TextEvent e) {
        if (this.textEditorListeners == null) {
            return;
        }
        Object[] objectArray = this.textEditorListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IFloatingTextEditorListener)l).textAboutToChange(e);
            ++n2;
        }
    }

    protected void fireTextChanged(TextEvent e) {
        if (this.textEditorListeners == null) {
            return;
        }
        Object[] objectArray = this.textEditorListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IFloatingTextEditorListener)l).textChanged(e);
            ++n2;
        }
    }

    public void addVerifyKeyListener(VerifyKeyListener listener) {
        if (this.verifyKeyListeners == null) {
            this.verifyKeyListeners = new ArrayList<VerifyKeyListener>();
        }
        this.verifyKeyListeners.add(listener);
    }

    public void removeVerifyKeyListener(VerifyKeyListener listener) {
        if (this.verifyKeyListeners == null) {
            return;
        }
        this.verifyKeyListeners.remove(listener);
    }

    protected void fireTraverseKey(TraverseEvent te, int simState, int simKeyCode) {
        StyledText widget = (StyledText)te.widget;
        Point selection = widget.getSelection();
        Event e = new Event();
        e.character = te.character;
        e.data = te.data;
        e.display = te.display;
        e.doit = true;
        e.end = selection.y;
        e.keyCode = te.keyCode;
        e.keyLocation = te.keyLocation;
        e.start = selection.x;
        e.stateMask = te.stateMask;
        e.text = widget.getText();
        e.time = te.time;
        e.widget = te.widget;
        VerifyEvent ve = new VerifyEvent(e);
        try {
            this.handleVerifyKey(ve);
        }
        finally {
            te.doit = ve.doit;
        }
    }

    protected void fireVerifyKey(VerifyEvent e) {
        if (this.verifyKeyListeners == null) {
            return;
        }
        Object[] objectArray = this.verifyKeyListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((VerifyKeyListener)l).verifyKey(e);
            ++n2;
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        if (this.isClosed()) {
            return null;
        }
        Rectangle trim = this.textViewer.getTextWidget().computeTrim(x, y, width, height);
        trim = this.control.computeTrim(trim.x, trim.y, trim.width, trim.height);
        Layout layout = this.control.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gl = (GridLayout)layout;
            trim.x -= gl.marginWidth + gl.marginLeft;
            trim.y -= gl.marginHeight + gl.marginTop;
            trim.width += gl.marginWidth * 2 + gl.marginLeft + gl.marginRight;
            trim.height += gl.marginHeight * 2 + gl.marginTop + gl.marginBottom;
        }
        return trim;
    }

    public void replaceText(String text) {
        this.replaceText(text, false);
    }

    public void replaceText(String text, boolean select) {
        if (this.isClosed() || this.document == null) {
            return;
        }
        Point range = this.textViewer.getSelectedRange();
        try {
            this.document.replace(range.x, range.y, text);
        }
        catch (BadLocationException badLocationException) {}
        if (select) {
            this.textViewer.setSelectedRange(range.x, text.length());
        } else {
            this.textViewer.setSelectedRange(range.x + text.length(), 0);
        }
    }

    public void setInitialLocation(Point initialLocation) {
        this.initialLocation = initialLocation;
    }

    public void setInitialSize(Point initialSize) {
        this.initialSize = initialSize;
    }

    private class TextViewerHooker
    implements ISelectionChangedListener,
    VerifyKeyListener,
    TraverseListener {
        private TextViewerHooker() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            FloatingTextEditor.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)FloatingTextEditor.this, event.getSelection()));
        }

        public void verifyKey(VerifyEvent event) {
            FloatingTextEditor.this.handleVerifyKey(event);
        }

        public void keyTraversed(TraverseEvent e) {
            FloatingTextEditor.this.handleTraverseKey(e);
        }

        public void hook(ITextViewer viewer) {
            if (viewer instanceof ISelectionProvider) {
                ((ISelectionProvider)viewer).addSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (viewer instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)viewer).addPostSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (viewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)viewer).prependVerifyKeyListener((VerifyKeyListener)this);
            }
            viewer.getTextWidget().addTraverseListener((TraverseListener)this);
        }

        public void unhook(ITextViewer viewer) {
            viewer.getTextWidget().removeTraverseListener((TraverseListener)this);
            if (viewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)viewer).removeVerifyKeyListener((VerifyKeyListener)this);
            }
            if (viewer instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)viewer).removePostSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (viewer instanceof ISelectionProvider) {
                ((ISelectionProvider)viewer).removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }
}

