/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.properties;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.xmind.ui.properties.IPropertyDescriptor;
import org.xmind.ui.properties.IPropertySource;
import org.xmind.ui.properties.IPropertyTransfer;
import org.xmind.ui.properties.PropertyEditingEntry;
import org.xmind.ui.properties.PropertyEditingSection;
import org.xmind.ui.util.Chainability;
import org.xmind.ui.util.IChained;

public class PropertiesEditor
implements IInputSelectionProvider {
    public static final String COLOR_BACKGROUND = "org.xmind.ui.color.PropertiesEditor.background";
    public static final String COLOR_CATEGORY_TITLE = "org.xmind.ui.color.PropertiesEditor.categoryTitle.foreground";
    public static final String COLOR_ENTRY_FOREGROUND = "org.xmind.ui.color.PropertiesEditor.entry.foreground";
    public static final String COLOR_ENTRY_SELECTED_BACKGROUND = "org.xmind.ui.color.PropertiesEditor.entry.selected.background";
    public static final String COLOR_ENTRY_SELECTED_FOREGROUND = "org.xmind.ui.color.PropertiesEditor.entry.selected.foreground";
    public static final String FONT_CATEGORY_TITLE = "org.xmind.ui.font.PropertiesEditor.categoryTitle";
    public static final String FONT_ENTRY = "org.xmind.ui.font.PropertiesEditor.entry";
    public static final String FONT_ENTRY_SELECTED = "org.xmind.ui.font.PropertiesEditor.entry.selected";
    private ScrolledComposite container = null;
    private IPropertySource source = null;
    private Map<String, Section> sectionRegistry = new HashMap<String, Section>();
    private Map<String, PropertyEditingEntry> entryRegistry = new HashMap<String, PropertyEditingEntry>();
    private Map<String, String> colorFontOverrides = new HashMap<String, String>();
    private boolean reflowing = false;
    private Section firstSection = null;
    private Section lastSection = null;
    private PropertyEditingEntry selectedEntry = null;
    private ListenerList listeners = new ListenerList();
    private Menu popupMenu = null;
    private IPropertyTransfer transfer = null;
    private List<String> filtedDescriptorIds = new ArrayList<String>();

    public Object getInput() {
        return this.source;
    }

    public void setInput(IPropertySource source) {
        IPropertySource oldSource = this.source;
        this.source = source;
        if (oldSource != source) {
            this.refresh();
        }
    }

    public ISelection getSelection() {
        if (this.selectedEntry == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.selectedEntry);
    }

    public void setSelection(ISelection selection) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void create(Composite parent) {
        Assert.isTrue((this.container == null ? 1 : 0) != 0);
        this.container = new ScrolledComposite(parent, 768);
        this.container.setExpandHorizontal(true);
        this.container.setExpandVertical(true);
        this.container.setMinWidth(200);
        this.container.setMinHeight(40);
        this.addHorizontalScrollSupport(this.container);
        this.container.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                PropertiesEditor.this.reflow();
            }

            public void controlMoved(ControlEvent e) {
                PropertiesEditor.this.reflow();
            }
        });
        Composite contents = new Composite((Composite)this.container, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 3;
        gridLayout.marginHeight = 3;
        gridLayout.verticalSpacing = 3;
        gridLayout.horizontalSpacing = 0;
        contents.setLayout((Layout)gridLayout);
        this.container.setContent((Control)contents);
        this.initColorsFonts();
        this.refresh();
    }

    private void addHorizontalScrollSupport(final ScrolledComposite sc) {
        if (Util.isWindows()) {
            sc.addListener(38, new Listener(){

                public void handleEvent(Event event) {
                    if (!sc.isDisposed()) {
                        int offset = event.count;
                        offset = -((int)(Math.sqrt(Math.abs(offset)) * (double)offset));
                        Point origin = sc.getOrigin();
                        sc.setOrigin(origin.x + offset, origin.y);
                    }
                }
            });
        }
    }

    public void setColorFontOverrides(String id, String overridedId) {
        if (overridedId == null) {
            this.colorFontOverrides.remove(id);
        } else {
            this.colorFontOverrides.put(id, overridedId);
        }
    }

    private String getColorFontId(String id) {
        String overridedId = this.colorFontOverrides.get(id);
        if (overridedId != null) {
            return overridedId;
        }
        return id;
    }

    private Composite getContents() {
        return (Composite)this.container.getContent();
    }

    private void initColorsFonts() {
        final IPropertyChangeListener colorChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String colorId = event.getProperty();
                if (PropertiesEditor.this.getColorFontId(PropertiesEditor.COLOR_BACKGROUND).equals(colorId)) {
                    PropertiesEditor.this.updateBackgroundColor();
                } else if (PropertiesEditor.this.getColorFontId(PropertiesEditor.COLOR_CATEGORY_TITLE).equals(colorId)) {
                    PropertiesEditor.this.updateCategoryTitlesColor();
                } else if (PropertiesEditor.this.getColorFontId(PropertiesEditor.COLOR_ENTRY_FOREGROUND).equals(colorId)) {
                    PropertiesEditor.this.updateEntriesForegroundColor();
                } else if (PropertiesEditor.this.getColorFontId(PropertiesEditor.COLOR_ENTRY_SELECTED_BACKGROUND).equals(colorId)) {
                    PropertiesEditor.this.updateEntriesSelectedBackgroundColor();
                } else if (PropertiesEditor.this.getColorFontId(PropertiesEditor.COLOR_ENTRY_SELECTED_FOREGROUND).equals(colorId)) {
                    PropertiesEditor.this.updateEntriesSelectedForegroundColor();
                }
            }
        };
        final IPropertyChangeListener fontChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String fontId = event.getProperty();
                if (PropertiesEditor.this.getColorFontId(PropertiesEditor.FONT_CATEGORY_TITLE).equals(fontId)) {
                    PropertiesEditor.this.updateCategoryTitlesFont();
                } else if (PropertiesEditor.this.getColorFontId(PropertiesEditor.FONT_ENTRY).equals(fontId)) {
                    PropertiesEditor.this.updateEntriesFont();
                } else if (PropertiesEditor.this.getColorFontId(PropertiesEditor.FONT_ENTRY_SELECTED).equals(fontId)) {
                    PropertiesEditor.this.updateEntriesSelectedFont();
                }
            }
        };
        JFaceResources.getColorRegistry().addListener(colorChangeListener);
        JFaceResources.getFontRegistry().addListener(fontChangeListener);
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JFaceResources.getColorRegistry().removeListener(colorChangeListener);
                JFaceResources.getFontRegistry().removeListener(fontChangeListener);
            }
        });
        this.updateColorsFonts();
    }

    protected void updateColorsFonts() {
        this.updateBackgroundColor();
        this.updateCategoryTitlesColor();
        this.updateCategoryTitlesFont();
        this.updateEntriesForegroundColor();
        this.updateEntriesFont();
        this.updateEntriesSelectedBackgroundColor();
        this.updateEntriesSelectedForegroundColor();
        this.updateEntriesSelectedFont();
    }

    private void updateBackgroundColor() {
        Color color = JFaceResources.getColorRegistry().get(this.getColorFontId(COLOR_BACKGROUND));
        this.container.setBackground(color);
        this.getContents().setBackground(color);
        Iterator<Section> sections = this.sections();
        while (sections.hasNext()) {
            Section section = sections.next();
            if (section.section == null) continue;
            section.section.setBackground(color);
        }
    }

    private void updateCategoryTitlesColor() {
        Color color = JFaceResources.getColorRegistry().get(this.getColorFontId(COLOR_CATEGORY_TITLE));
        Iterator<Section> sections = this.sections();
        while (sections.hasNext()) {
            Section section = sections.next();
            if (section.section == null) continue;
            section.section.setTitleColor(color);
        }
    }

    private void updateEntriesForegroundColor() {
        Color color = JFaceResources.getColorRegistry().get(this.getColorFontId(COLOR_ENTRY_FOREGROUND));
        Iterator<PropertyEditingEntry> entries = this.entries();
        while (entries.hasNext()) {
            entries.next().setForeground(color);
        }
    }

    private void updateCategoryTitlesFont() {
        Font font = JFaceResources.getFontRegistry().get(this.getColorFontId(FONT_CATEGORY_TITLE));
        Iterator<Section> sections = this.sections();
        while (sections.hasNext()) {
            Section section = sections.next();
            if (section.section == null) continue;
            section.section.setTitleFont(font);
        }
    }

    private void updateEntriesFont() {
        Font font = JFaceResources.getFontRegistry().get(this.getColorFontId(FONT_ENTRY));
        Iterator<PropertyEditingEntry> entries = this.entries();
        while (entries.hasNext()) {
            entries.next().setFont(font);
        }
    }

    private void updateEntriesSelectedBackgroundColor() {
        Color color = JFaceResources.getColorRegistry().get(this.getColorFontId(COLOR_ENTRY_SELECTED_BACKGROUND));
        Iterator<PropertyEditingEntry> entries = this.entries();
        while (entries.hasNext()) {
            entries.next().setSelectedBackground(color);
        }
    }

    private void updateEntriesSelectedForegroundColor() {
        Color color = JFaceResources.getColorRegistry().get(this.getColorFontId(COLOR_ENTRY_SELECTED_FOREGROUND));
        Iterator<PropertyEditingEntry> entries = this.entries();
        while (entries.hasNext()) {
            entries.next().setSelectedForeground(color);
        }
    }

    private void updateEntriesSelectedFont() {
        Font font = JFaceResources.getFontRegistry().get(this.getColorFontId(FONT_ENTRY_SELECTED));
        Iterator<PropertyEditingEntry> entries = this.entries();
        while (entries.hasNext()) {
            entries.next().setSelectedFont(font);
        }
    }

    protected Iterator<PropertyEditingEntry> entries() {
        return Chainability.iterate(this.firstSection == null ? null : this.firstSection.firstEntry, null);
    }

    protected Iterator<Section> sections() {
        return Chainability.iterate(this.firstSection, this.lastSection);
    }

    public void setFilter(List<String> filtedDescriptorIds) {
        this.filtedDescriptorIds = filtedDescriptorIds;
    }

    public void refresh() {
        if (this.container == null || this.container.isDisposed()) {
            return;
        }
        this.container.setRedraw(false);
        try {
            Iterator<Section> sectionIt = this.sections();
            while (sectionIt.hasNext()) {
                sectionIt.next().dispose();
            }
            this.firstSection = null;
            this.lastSection = null;
            this.selectedEntry = null;
            this.sectionRegistry.clear();
            this.entryRegistry.clear();
            Control[] controls = this.getContents().getChildren();
            int i = 0;
            while (i < controls.length) {
                controls[i].dispose();
                ++i;
            }
            if (this.source != null) {
                IPropertyDescriptor[] descs = this.source.getPropertyDescriptors();
                int i2 = 0;
                while (i2 < descs.length) {
                    IPropertyDescriptor descriptor = descs[i2];
                    if (this.filtedDescriptorIds == null || !this.filtedDescriptorIds.contains(descriptor.getId())) {
                        this.addEditingEntry(descriptor);
                    }
                    ++i2;
                }
            }
            this.createSectionControls();
            this.updateColorsFonts();
            this.reflow();
        }
        finally {
            this.container.setRedraw(true);
        }
    }

    public void updateAll() {
        Iterator<PropertyEditingEntry> entries = this.entries();
        while (entries.hasNext()) {
            entries.next().update();
        }
    }

    public void update(String propertyId) {
        PropertyEditingEntry entry = this.entryRegistry.get(propertyId);
        if (entry != null) {
            entry.update();
        }
    }

    protected void addEditingEntry(IPropertyDescriptor descriptor) {
        PropertyEditingEntry entry = new PropertyEditingEntry(this, this.source, descriptor);
        this.entryRegistry.put(descriptor.getId(), entry);
        String category = descriptor.getCategory();
        Section section = this.sectionRegistry.get(category);
        if (section == null) {
            section = new Section(this, category);
            this.sectionRegistry.put(category, section);
            if (this.firstSection == null || this.lastSection == null) {
                this.firstSection = section;
            } else {
                Chainability.insertAfter(this.lastSection, section);
            }
            this.lastSection = section;
        }
        if (section.firstEntry == null || section.lastEntry == null) {
            section.firstEntry = entry;
            if (section.getPrevious() != null) {
                Chainability.insertAfter(section.getPrevious().lastEntry, entry);
            }
        } else {
            Chainability.insertAfter(section.lastEntry, entry);
        }
        section.lastEntry = entry;
    }

    private void createSectionControls() {
        if (this.firstSection == null) {
            return;
        }
        Composite parent = this.getContents();
        if (this.firstSection.getNext() == null && (this.firstSection.title == null || "".equals(this.firstSection.title))) {
            Iterator<PropertyEditingEntry> it = this.firstSection.entries();
            while (it.hasNext()) {
                PropertyEditingEntry entry = it.next();
                entry.createControl(parent);
                entry.getControl().setLayoutData((Object)this.createSectionLayoutData());
            }
        } else {
            Iterator<Section> sectionIt = this.sections();
            while (sectionIt.hasNext()) {
                Section section = sectionIt.next();
                section.create(parent);
                if (section.section == null) continue;
                section.section.getControl().setLayoutData((Object)this.createSectionLayoutData());
            }
        }
        if (this.popupMenu != null) {
            Iterator<PropertyEditingEntry> entries = this.entries();
            while (entries.hasNext()) {
                entries.next().setPopupMenu(this.popupMenu);
            }
        }
    }

    private GridData createSectionLayoutData() {
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        return gridData;
    }

    public Control getControl() {
        return this.container;
    }

    public void setFocus() {
        if (this.selectedEntry != null) {
            this.selectedEntry.setFocus();
        } else if (this.firstSection != null && this.firstSection.firstEntry != null) {
            this.firstSection.firstEntry.setFocus();
        } else if (this.container != null && !this.container.isDisposed()) {
            this.container.setFocus();
        }
    }

    public void reflow() {
        if (this.container == null || this.container.isDisposed()) {
            return;
        }
        if (this.reflowing) {
            return;
        }
        this.reflowing = true;
        this.container.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PropertiesEditor.this.container != null && !PropertiesEditor.this.container.isDisposed()) {
                        PropertiesEditor.this.container.layout(true, true);
                        PropertiesEditor.this.container.setMinHeight(((PropertiesEditor)PropertiesEditor.this).container.getContent().computeSize((int)((PropertiesEditor)PropertiesEditor.this).container.getClientArea().width, (int)-1).y);
                    }
                }
                finally {
                    PropertiesEditor.this.reflowing = false;
                }
            }
        });
    }

    public void select(String propertyId) {
        PropertyEditingEntry entry = this.entryRegistry.get(propertyId);
        if (entry != null) {
            this.select(entry);
        }
    }

    protected boolean select(PropertyEditingEntry entry) {
        if (entry == null) {
            return false;
        }
        PropertyEditingEntry oldEntry = this.selectedEntry;
        this.selectedEntry = entry;
        if (oldEntry != null) {
            oldEntry.setSelected(false);
        }
        entry.setSelected(true);
        entry.setFocus();
        this.reveal(entry.getControl());
        this.fireSelectionChanged();
        return true;
    }

    private void reveal(Control control) {
        if (this.container != null && !this.container.isDisposed()) {
            this.container.showControl(control);
        }
    }

    protected void fireSelectionChanged() {
        ISelection selection = this.getSelection();
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof ISelectionChangedListener) {
                ((ISelectionChangedListener)listener).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            }
            ++n2;
        }
    }

    public void setPopupMenu(Menu menu) {
        this.popupMenu = menu;
        Iterator<PropertyEditingEntry> entries = this.entries();
        while (entries.hasNext()) {
            entries.next().setPopupMenu(menu);
        }
        if (this.container != null && !this.container.isDisposed()) {
            this.getContents().setMenu(menu);
        }
    }

    public void dispose() {
        Iterator<Section> sectionIt = this.sections();
        while (sectionIt.hasNext()) {
            sectionIt.next().dispose();
        }
        this.sectionRegistry.clear();
        this.firstSection = null;
        this.lastSection = null;
        this.source = null;
        if (this.container != null && !this.container.isDisposed()) {
            this.container.dispose();
        }
        this.container = null;
    }

    public IPropertyTransfer getTransfer() {
        return this.transfer;
    }

    public void setTransfer(IPropertyTransfer transfer) {
        this.transfer = transfer;
    }

    private static final class Section
    implements PropertyChangeListener,
    IChained<Section> {
        private final PropertiesEditor editor;
        private final String title;
        private PropertyEditingEntry firstEntry = null;
        private PropertyEditingEntry lastEntry = null;
        private PropertyEditingSection section = null;
        private Section prev = null;
        private Section next = null;

        public Section(PropertiesEditor editor, String title) {
            this.editor = editor;
            this.title = title;
        }

        public void create(Composite parent) {
            this.section = new PropertyEditingSection(parent);
            this.section.setTitleText(this.title == null ? "" : this.title);
            this.section.getEventSupport().addPropertyChangeListener(this);
            Composite client = this.section.getClient();
            GridLayout gridLayout = new GridLayout(1, true);
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
            gridLayout.verticalSpacing = 3;
            gridLayout.horizontalSpacing = 0;
            client.setLayout((Layout)gridLayout);
            Iterator<PropertyEditingEntry> it = this.entries();
            while (it.hasNext()) {
                PropertyEditingEntry entry = it.next();
                entry.createControl(client);
                GridData gridData = new GridData(4, 4, true, false);
                gridData.widthHint = -1;
                gridData.heightHint = -1;
                entry.getControl().setLayoutData((Object)gridData);
            }
        }

        public void dispose() {
            Iterator<PropertyEditingEntry> it = this.entries();
            while (it.hasNext()) {
                it.next().dispose();
            }
            if (this.section != null) {
                this.section.getEventSupport().removePropertyChangeListener(this);
                if (this.section.getControl() != null && !this.section.getControl().isDisposed()) {
                    this.section.getControl().dispose();
                }
                this.section = null;
            }
            this.firstEntry = null;
            this.lastEntry = null;
        }

        public Iterator<PropertyEditingEntry> entries() {
            return Chainability.iterate(this.firstEntry, this.lastEntry);
        }

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            if ("expanded".equals(evt.getPropertyName())) {
                this.editor.reflow();
            }
        }

        @Override
        public Section getPrevious() {
            return this.prev;
        }

        @Override
        public Section getNext() {
            return this.next;
        }

        @Override
        public void setPrevious(Section element) {
            this.prev = element;
        }

        @Override
        public void setNext(Section element) {
            this.next = element;
        }
    }
}

