/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.statushandlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.Random;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.xmind.ui.internal.statushandlers.StatusHandlerMessages;

public class StatusDetails {
    private final StatusAdapter statusAdapter;
    private String detailsText = null;

    public StatusDetails(StatusAdapter statusAdapter) {
        this.statusAdapter = statusAdapter;
    }

    public StatusAdapter getStatusAdapter() {
        return this.statusAdapter;
    }

    public Image getImage() {
        int severity = this.statusAdapter.getStatus().getSeverity();
        int iconId = (severity & 4) != 0 ? 1 : ((severity & 2) != 0 ? 8 : 2);
        return Display.getCurrent().getSystemImage(iconId);
    }

    public String getMessage() {
        IStatus status = this.statusAdapter.getStatus();
        String message = status.getMessage();
        if (message != null && !"".equals(message)) {
            return message;
        }
        Throwable exception = StatusDetails.getRootCause(status.getException());
        if (exception != null) {
            return NLS.bind((String)StatusHandlerMessages.StatusDetails_ErrorMessage_with_RootCauseClassName_and_RootCauseMessage, (Object)exception.getClass().getName(), (Object)exception.getLocalizedMessage());
        }
        return StatusHandlerMessages.StatusDetails_SimpleErrorMessage;
    }

    public String getFullText() {
        if (this.detailsText == null) {
            this.detailsText = StatusDetails.buildDetailsText(this.statusAdapter);
        }
        return this.detailsText;
    }

    public String buildMailingURL() {
        String caseId = StatusDetails.generateCaseId();
        String subject = String.format("XMind Runtime Error Report (Case ID: %s)", caseId);
        return String.format("mailto:support@xmind.net?subject=%s&body=%s", StatusDetails.urlEncode(subject), StatusDetails.urlEncode(String.valueOf(System.getProperty("line.separator")) + this.getFullText()));
    }

    private static String buildDetailsText(StatusAdapter statusAdapter) {
        IProduct product;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        IStatus status = statusAdapter.getStatus();
        String message = status.getMessage();
        Throwable exception = status.getException();
        Long timestamp = (Long)statusAdapter.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY);
        if (message != null) {
            ps.println(message);
            ps.println();
        }
        if (exception != null) {
            exception.printStackTrace(ps);
        }
        ps.println();
        ps.printf("Severity: %s", StatusDetails.toSeverityString(status.getSeverity()));
        ps.println();
        ps.printf("Plug-in ID: %s", status.getPlugin());
        ps.println();
        ps.printf("Code: %s", status.getCode());
        ps.println();
        ps.println();
        ps.println("== Environment ==");
        ps.printf("Time: %1$tF %1$tT", timestamp);
        ps.println();
        String application = System.getProperty("eclipse.application");
        if ((application == null || "".equals(application)) && (product = Platform.getProduct()) != null) {
            application = product.getApplication();
        }
        if ("org.xmind.cathy.application".equals(application)) {
            StatusDetails.printp(ps, "XMind Distribution Pack: %s", "org.xmind.product.distribution.id");
        } else {
            ps.println("XMind Installed as Plugins");
        }
        StatusDetails.printp(ps, "XMind Build ID: %s", "org.xmind.product.buildid");
        StatusDetails.printp(ps, "Operating System: %s %s (%s)", "os.name", "os.version", "os.arch");
        StatusDetails.printp(ps, "Platform: %s.%s.%s", "osgi.os", "osgi.ws", "osgi.arch");
        StatusDetails.printp(ps, "Language: %s", "user.language");
        StatusDetails.printp(ps, "Country: %s", "user.country");
        ps.println();
        ps.println("== Product ==");
        StatusDetails.printp(ps, "Product ID: %s", "eclipse.product");
        StatusDetails.printp(ps, "Application ID: %s", "eclipse.application");
        StatusDetails.printp(ps, "Launcher: %s", "eclipse.launcher.name");
        ps.println();
        StatusDetails.printp(ps, "Command Line Arguments: %s", "eclipse.commands");
        StatusDetails.printp(ps, "VM Arguments: %s", "eclipse.vmargs");
        ps.println();
        ps.println("== Java Properties ==");
        StatusDetails.printp(ps, "Java Version: %s", "java.version");
        StatusDetails.printp(ps, "Java Vendor: %s", "java.vendor");
        StatusDetails.printp(ps, "Java Runtime: %s", "java.runtime.name");
        StatusDetails.printp(ps, "    Version: %s", "java.runtime.version");
        StatusDetails.printp(ps, "Java VM: %s", "java.vm.name");
        StatusDetails.printp(ps, "    Version: %s", "java.vm.version");
        StatusDetails.printp(ps, "    Vendor: %s", "java.vm.vendor");
        StatusDetails.printp(ps, "    Info: %s", "java.vm.info");
        ps.close();
        try {
            out.close();
        }
        catch (IOException iOException) {}
        String text = out.toString();
        String userName = System.getProperty("user.name");
        if (userName != null && !"".equals(userName.trim())) {
            text = text.replace(userName, "USERNAME");
        }
        return text;
    }

    private static void printp(PrintStream ps, String format, String ... keys) {
        Object[] values = new Object[keys.length];
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            String value = StatusDetails.getSysProp(key);
            if (value.indexOf("\n") >= 0 || value.indexOf("\r") >= 0) {
                value = value.replaceAll("\r\n|\r|\n", String.valueOf(System.getProperty("line.separator")) + " ");
            }
            values[i] = value;
            ++i;
        }
        ps.printf(format, values);
        ps.println();
    }

    private static String getSysProp(String key) {
        String value = System.getProperty(key);
        return value == null ? "" : value;
    }

    private static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private static String generateCaseId() {
        return Integer.toString(new Random().nextInt(Integer.MAX_VALUE), 36).toUpperCase();
    }

    private static String toSeverityString(int s) {
        if ((s & 4) != 0) {
            return "error";
        }
        if ((s & 2) != 0) {
            return "warning";
        }
        if ((s & 1) != 0) {
            return "info";
        }
        if ((s & 8) != 0) {
            return "cancel";
        }
        return "ok";
    }

    public static Throwable getRootCause(Throwable exception) {
        Throwable cause;
        if (exception == null) {
            return null;
        }
        if (exception instanceof InvocationTargetException) {
            return StatusDetails.getRootCause(((InvocationTargetException)exception).getCause());
        }
        if (exception instanceof CoreException && (cause = ((CoreException)exception).getStatus().getException()) != null) {
            return StatusDetails.getRootCause(cause);
        }
        return exception;
    }
}

