/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4handlers;

import javax.inject.Inject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.internal.workbench.RenderedElementUtil;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;

public class DirectToolItem
implements IAdaptable {
    @Inject
    private EModelService modelService;
    private MMenu mmenu;
    private ToolItem toolItem;

    @Execute
    public void execute(@Optional MToolItem model) {
        if (this.modelService == null || model == null) {
            return;
        }
        this.mmenu = model.getMenu();
        Object widget = model.getWidget();
        if (!(widget instanceof ToolItem)) {
            return;
        }
        this.toolItem = (ToolItem)widget;
        Rectangle itemBounds = this.toolItem.getBounds();
        Point displayAt = this.toolItem.getParent().toDisplay(itemBounds.x, itemBounds.y);
        this.showPullDownMenuAt(new Rectangle(displayAt.x, displayAt.y, itemBounds.width, itemBounds.height));
        this.showExtensionControl(new Rectangle(displayAt.x, displayAt.y, itemBounds.width, itemBounds.height));
    }

    protected void showExtensionControl(Rectangle itemBoundsToDisplay) {
    }

    protected void showPullDownMenuAt(Rectangle itemBoundsToDisplay) {
    }

    protected Menu getMenu() {
        if (this.mmenu == null || this.toolItem == null) {
            return null;
        }
        return this.getMenu(this.mmenu, this.toolItem);
    }

    private Menu getMenu(final MMenu mmenu, ToolItem toolItem) {
        Object obj = mmenu.getWidget();
        if (obj instanceof Menu) {
            return (Menu)obj;
        }
        if (RenderedElementUtil.isRenderedMenu((MUIElement)mmenu)) {
            IMenuCreator creator;
            Menu menu;
            obj = RenderedElementUtil.getContributionManager((MUIElement)mmenu);
            if (obj instanceof IContextFunction) {
                IEclipseContext lclContext = this.getContext((MUIElement)mmenu);
                obj = ((IContextFunction)obj).compute(lclContext, null);
                RenderedElementUtil.setContributionManager((MUIElement)mmenu, (Object)obj);
            }
            if (obj instanceof IMenuCreator && (menu = (creator = (IMenuCreator)obj).getMenu((Control)toolItem.getParent().getShell())) != null) {
                toolItem.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (menu != null && !menu.isDisposed()) {
                            creator.dispose();
                            mmenu.setWidget(null);
                        }
                    }
                });
                mmenu.setWidget((Object)menu);
                menu.setData("modelElement", (Object)menu);
                return menu;
            }
        } else {
            IEclipseContext lclContext = this.getContext((MUIElement)mmenu);
            IPresentationEngine engine = (IPresentationEngine)lclContext.get(IPresentationEngine.class);
            obj = engine.createGui((MUIElement)mmenu, (Object)toolItem.getParent(), lclContext);
            if (obj instanceof Menu) {
                return (Menu)obj;
            }
        }
        return null;
    }

    private IEclipseContext getContext(MUIElement part) {
        if (part instanceof MContext) {
            return ((MContext)part).getContext();
        }
        return this.getContextForParent(part);
    }

    private IEclipseContext getContextForParent(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (EModelService.class.equals(adapter)) {
            return adapter.cast(this.modelService);
        }
        if (MMenu.class.equals(adapter)) {
            return adapter.cast(this.mmenu);
        }
        if (ToolItem.class.equals(adapter)) {
            return adapter.cast(this.toolItem);
        }
        return null;
    }
}

