/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import net.xmind.core.IAccount;
import net.xmind.core.IAuthenticationListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.internal.dashboard.pages.DashboardPage;
import org.xmind.ui.internal.dashboard.pages.IDashboardContext;
import org.xmind.ui.internal.seawind.ISeawindLibraryListener;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindLibraryEvent;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.dashboard.AuthorizationPage;
import org.xmind.ui.internal.seawind.dashboard.CloudDashboardContentPage;
import org.xmind.ui.internal.seawind.dashboard.ConnectingPage;
import org.xmind.ui.internal.seawind.dashboard.FatalErrorPage;
import org.xmind.ui.internal.seawind.dashboard.UnactivatedPage;
import org.xmind.ui.viewers.SWTUtils;
import org.xmind.ui.views.IPage;
import org.xmind.ui.views.PageStack;

public class CloudDashboardPage
extends DashboardPage
implements IAdaptable,
IAuthenticationListener {
    private SeawindLibrary library = null;
    private IAccount account = null;
    private PageStack stack = null;
    private IPage authPage;
    private IPage contentPage;
    private IPage connectingPage;
    private FatalErrorPage fatalErrorPage;
    private UnactivatedPage unactivatedPage;
    private ISeawindLibraryListener libraryListener = new ISeawindLibraryListener(){

        @Override
        public void handleSeawindLibraryEvent(SeawindLibraryEvent event) {
            if (event.getType() == 1024) {
                CloudDashboardPage.this.refreshForAccountInfoChanged();
            }
        }
    };

    public void createControl(Composite parent) {
        IDashboardContext context = this.getContext();
        this.library = SeawindUIPlugin.getSeawindLibrary();
        this.library.addLibraryListener(this.libraryListener);
        this.account = this.findPrimaryAccount(context);
        if (this.account != null) {
            this.account.addAuthenticationListener((IAuthenticationListener)this);
        }
        PageStack stack = new PageStack();
        stack.createControl(parent);
        stack.getControl().setBackground(parent.getBackground());
        this.setControl(stack.getControl());
        this.stack = stack;
        this.authPage = new AuthorizationPage(this.library, this.account);
        this.authPage.createControl(stack.getStackComposite());
        CloudDashboardContentPage cloudContentPage = new CloudDashboardContentPage(context, this.library, this.account);
        this.contentPage = cloudContentPage;
        this.contentPage.createControl(stack.getStackComposite());
        this.connectingPage = new ConnectingPage(this.account);
        this.connectingPage.createControl(stack.getStackComposite());
        this.fatalErrorPage = new FatalErrorPage(this.library, this.account);
        this.fatalErrorPage.createControl(stack.getStackComposite());
        this.unactivatedPage = new UnactivatedPage(this.library, this.account);
        this.unactivatedPage.createControl(stack.getStackComposite());
        this.showPage();
    }

    public void setContext(IDashboardContext context) {
        super.setContext(context);
        context.registerAvailableCommandId("org.eclipse.ui.edit.delete");
        context.registerAvailableCommandId("org.eclipse.ui.edit.rename");
        context.registerAvailableCommandId("org.xmind.ui.command.saveWorkbookAs");
        context.registerAvailableCommandId("org.xmind.ui.command.duplicate");
        context.registerAvailableCommandId("org.xmind.ui.command.cloud.sync");
        context.registerAvailableCommandId("org.xmind.ui.command.openCloudPage");
        context.registerAvailableCommandId("org.xmind.ui.seawind.command.moveTo");
    }

    private void showPage() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        if (Display.getCurrent() == null) {
            return;
        }
        boolean hadFocus = SWTUtils.isInside((Control)this.getControl(), (Control)Display.getCurrent().getFocusControl());
        int status = this.library.getStatus();
        Object page = null;
        if (this.isAuthorized()) {
            switch (status) {
                case 1: {
                    page = this.authPage;
                    break;
                }
                case 2: {
                    page = this.connectingPage;
                    break;
                }
                case 3: {
                    page = this.unactivatedPage;
                    this.unactivatedPage.updateUserInfo();
                    break;
                }
                case 4: {
                    page = this.fatalErrorPage;
                    this.fatalErrorPage.updateUserInfo();
                    break;
                }
                case 10: 
                case 11: {
                    page = this.contentPage;
                    break;
                }
                default: {
                    page = this.authPage;
                    break;
                }
            }
        } else {
            page = this.library.isActive() ? this.contentPage : this.authPage;
        }
        this.stack.showPage(page);
        if (hadFocus) {
            this.setFocus();
        }
    }

    private boolean isAuthorized() {
        return this.account != null && this.account.isAuthenticated();
    }

    public void setFocus() {
        if (this.stack != null && this.stack.getControl() != null && !this.stack.getControl().isDisposed()) {
            this.stack.setFocus();
        }
    }

    private void refreshForAccountInfoChanged() {
        Display display;
        if (this.getControl() != null && !this.getControl().isDisposed() && (display = this.getControl().getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudDashboardPage.this.showPage();
                }
            });
        }
    }

    public void dispose() {
        if (this.account != null) {
            this.account.removeAuthenticationListener((IAuthenticationListener)this);
        }
        if (this.library != null) {
            this.library.removeLibraryListener(this.libraryListener);
        }
        super.dispose();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.contentPage != null) {
            return (T)this.contentPage.getAdapter(adapter);
        }
        return null;
    }

    private IAccount findPrimaryAccount(IDashboardContext context) {
        return (IAccount)context.getContextVariable("net.xmind.ui.primaryAccount");
    }

    public void onAuthenticated(IAccount account) {
        this.refreshForAccountInfoChanged();
    }

    public void onUnauthenticated(IAccount account) {
        this.refreshForAccountInfoChanged();
    }
}

