/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import net.xmind.core.IAccount;
import net.xmind.ui.internal.auth.AuthenticationDialog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.wizards.ISaveContext;
import org.xmind.ui.wizards.ISaveWizard;
import org.xmind.ui.wizards.SaveOptions;

public class SeawindSaveWizard
implements ISaveWizard {
    public static final String ID = "org.xmind.ui.saveWizards.seawind";

    public URI askForTargetURI(ISaveContext context, SaveOptions options) throws ISaveWizard.SaveWizardNotAvailable {
        IAccount account = (IAccount)context.getContextVariable("net.xmind.ui.primaryAccount");
        Assert.isNotNull((Object)account);
        SeawindLibrary library = SeawindUIPlugin.getSeawindLibrary();
        if (!account.isAuthenticated()) {
            Shell parentShell = (Shell)context.getContextVariable(Shell.class);
            new AuthenticationDialog(parentShell, account, null).open();
            if (!account.isAuthenticated()) {
                return null;
            }
            int ret = new WaitForSeawindConnectionDialog(parentShell).open();
            if (ret != 0) {
                throw new ISaveWizard.SaveWizardNotAvailable(SeawindMessages.SaveWizardNotAvailable_CloudNotActivated);
            }
        } else if (!library.isActive()) {
            throw new ISaveWizard.SaveWizardNotAvailable(SeawindMessages.SaveWizardNotAvailable_CloudNotActivated);
        }
        return library.createNewWorkbookRefURI(options.proposalName(), true);
    }

    public int getPriorityFor(ISaveContext context, SaveOptions options) {
        return SeawindUIPlugin.getSeawindLibrary().isActive() ? 75 : 25;
    }

    private static class WaitForSeawindConnectionDialog
    extends MessageDialog {
        private ProgressMonitorPart monitor;

        public WaitForSeawindConnectionDialog(Shell parentShell) {
            super(parentShell, SeawindMessages.WaitForCloudActivationDialog_title, null, SeawindMessages.WaitForCloudActivationDialog_message, 2, new String[]{IDialogConstants.CANCEL_LABEL}, -1);
            this.setBlockOnOpen(false);
        }

        public int open() {
            int opened = super.open();
            if (opened != 0) {
                return opened;
            }
            Button cancelButton = this.getButton(0);
            if (this.monitor == null) {
                this.monitor = new ProgressMonitorPart((Composite)this.getParentShell(), null);
            }
            this.monitor.setVisible(false);
            this.monitor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            ((GridData)this.monitor.getLayoutData()).exclude = true;
            this.monitor.attachToCancelComponent((Control)cancelButton);
            try {
                ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SeawindUIPlugin.getSeawindLibrary().waitForConnection(monitor);
                    }
                }, (boolean)true, (IProgressMonitor)this.monitor, (Display)this.getParentShell().getDisplay());
                this.setReturnCode(0);
                return 0;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.setReturnCode(1);
                return 1;
            }
            catch (InterruptedException interruptedException) {
                this.setReturnCode(1);
                return 1;
            }
            finally {
                this.monitor.removeFromCancelComponent((Control)cancelButton);
                this.close();
            }
        }
    }
}

