/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.xmind.core.AccountManager;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.xmind.core.IWorkspace;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.SecuredStorage;

public class SeawindLibraryStorage
implements IStorage {
    private static final String PATH_LIBRARY_ROOT_NORMAL = "seawind/";
    private static final String PATH_LIBRARY_ROOT_ENCRYPTED = "secret/seawind/";
    private static final String PATH_SECRET_PREF_FILE = "secret/prefs/org.xmind.ui.seawind.pref";
    private static final String PREF_KEY_FOR_SECRET_KEY = "org.xmind.ui.seawind.security.key";
    private static final String CIPHER_ALGORITHM = "AES";
    private static final String SECRET_KEY_ALGORITHM = "AES";
    private final IWorkspace workspace;
    private final boolean encryptionPreferred;
    private IStorage workingStorage;
    private final Set<IStorage> otherStorages;

    public SeawindLibraryStorage(IWorkspace workspace, boolean encryptionPreferred) {
        if (workspace == null) {
            throw new IllegalArgumentException("workspace is null");
        }
        this.workspace = workspace;
        this.encryptionPreferred = encryptionPreferred;
        this.workingStorage = null;
        this.otherStorages = new HashSet<IStorage>();
    }

    public IInputSource getInputSource() {
        this.ensureStorage();
        return this.workingStorage.getInputSource();
    }

    public IOutputTarget getOutputTarget() {
        this.ensureStorage();
        return this.workingStorage.getOutputTarget();
    }

    public String getName() {
        this.ensureStorage();
        return this.workingStorage.getName();
    }

    public String getFullPath() {
        this.ensureStorage();
        return this.workingStorage.getFullPath();
    }

    public void clear() {
        this.ensureStorage();
        this.workingStorage.clear();
        for (IStorage storage : this.otherStorages) {
            storage.clear();
        }
    }

    public void deleteEntry(String entryName) {
        this.ensureStorage();
        this.workingStorage.deleteEntry(entryName);
    }

    public void renameEntry(String entryName, String newName) {
        this.ensureStorage();
        this.workingStorage.renameEntry(entryName, newName);
    }

    private synchronized void ensureStorage() {
        if (this.workingStorage != null) {
            return;
        }
        IStorage normalStorage = this.obtainDirectoryStorageFor(PATH_LIBRARY_ROOT_NORMAL);
        IStorage secretStorage = this.obtainDirectoryStorageFor(PATH_LIBRARY_ROOT_ENCRYPTED);
        if (!this.encryptionPreferred) {
            this.workingStorage = normalStorage;
            this.otherStorages.add(secretStorage);
            this.migrateFromSecuredStorageToNormalStorage(secretStorage, normalStorage, "AES");
        } else {
            SecretKeySpec secretKey = null;
            try {
                secretKey = this.obtainSecretKey("AES", true);
            }
            catch (Exception e) {
                e.printStackTrace();
                SeawindUIPlugin.log(e, "Can not obtain secret key.");
            }
            if (secretKey == null) {
                this.workingStorage = normalStorage;
                this.otherStorages.add(secretStorage);
                SeawindUIPlugin.log("The encrypted seawind local caches will be deleted, because we couldn't obtain a secret key to decrept it.");
            } else {
                this.workingStorage = new SecuredStorage(secretStorage, "AES", secretKey);
                this.otherStorages.add(normalStorage);
                SeawindLibraryStorage.migrateFromNormalStorageToSecuredStorage(normalStorage, this.workingStorage);
            }
        }
        for (IStorage storage : this.otherStorages) {
            storage.clear();
        }
        this.obtainDirectoryStorageFor("seawind37").clear();
    }

    private IStorage obtainDirectoryStorageFor(String rootPathWithinWorkspace) {
        File rootDir = new File(this.workspace.getAbsolutePath(rootPathWithinWorkspace));
        return new DirectoryStorage(rootDir);
    }

    private SecretKeySpec obtainSecretKey(String cipherAlgorithm, boolean createsKey) {
        byte[] key;
        ISecurePreferences prefs;
        URL prefFileURL;
        Cipher testingCipher;
        try {
            testingCipher = Cipher.getInstance(cipherAlgorithm);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("The cipher algorithm is not available: " + cipherAlgorithm, e);
        }
        try {
            prefFileURL = this.getPrefFileURL();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to obtain a location to store the secret key for seawind.", e);
        }
        try {
            prefs = SecurePreferencesFactory.open((URL)prefFileURL, null);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to open the file containing the secret key for seawind: " + prefFileURL, e);
        }
        try {
            key = prefs.getByteArray(PREF_KEY_FOR_SECRET_KEY, null);
        }
        catch (StorageException e) {
            SeawindUIPlugin.log(e, "A new secret key for seawind will be generated, because we failed to decrypt an existing one from file: " + prefFileURL);
            key = null;
        }
        if (key != null) {
            try {
                testingCipher.init(1, new SecretKeySpec(key, "AES"));
            }
            catch (InvalidKeyException e) {
                SeawindUIPlugin.log(e, "A new secret key for seawind will be generated, because the existing one is inappropriate for initializing our cipher: " + cipherAlgorithm);
                key = null;
            }
        }
        if (key == null) {
            if (!createsKey) {
                return null;
            }
            try {
                key = this.generateSecretKey();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("No available SecureRandom algorithm for generating secret key for seawind", e);
            }
        }
        try {
            testingCipher.init(1, new SecretKeySpec(key, "AES"));
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("Generated secret key is still inappropriate for the given cipher: " + cipherAlgorithm, e);
        }
        try {
            prefs.putByteArray(PREF_KEY_FOR_SECRET_KEY, key, true);
        }
        catch (StorageException e) {
            throw new IllegalStateException("Failed to store the secret key for seawind", e);
        }
        try {
            prefs.flush();
        }
        catch (IOException e) {
            SeawindUIPlugin.log(e, "Failed to save secret preferences for seawind");
        }
        return new SecretKeySpec(key, "AES");
    }

    private URL getPrefFileURL() throws IOException {
        String prefFilePath = this.workspace.getAbsolutePath(PATH_SECRET_PREF_FILE);
        return new File(prefFilePath).toURL();
    }

    private byte[] generateSecretKey() throws NoSuchAlgorithmException {
        byte[] dummy = new byte[16];
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.nextBytes(dummy);
        return dummy;
    }

    private static void migrateFromNormalStorageToSecuredStorage(IStorage normalStorage, IStorage securedStorage) {
        String normalLibraryOwner = SeawindLibrary.peekLibraryUserName(normalStorage);
        String securedLibraryOwner = SeawindLibrary.peekLibraryUserName(securedStorage);
        String currentUser = (String)AccountManager.getPrimaryAccount().getProperty("user");
        if (currentUser == null) {
            if (securedLibraryOwner != null) {
                SeawindUIPlugin.log("The encrypted seawind local caches will be deleted because the user has signed out from xmind.");
            }
            if (normalLibraryOwner != null) {
                SeawindUIPlugin.log("The legacy seawind local caches will be deleted because the user has signed out from xmind.");
            }
            securedStorage.clear();
            return;
        }
        if (currentUser.equals(securedLibraryOwner)) {
            if (normalLibraryOwner != null) {
                SeawindUIPlugin.log("The legacy seawind local caches will be deleted because we should not migrate them to an encrypted storage with existing content: currentUser=" + currentUser + ", securedLibraryOwner=" + securedLibraryOwner + ", normalLibraryOwner=" + normalLibraryOwner);
            }
            return;
        }
        SeawindUIPlugin.log("The encrypted seawind local caches will be deleted because the user has signed out from it: currentUser=" + currentUser + ", securedLibraryOwner=" + securedLibraryOwner);
        securedStorage.clear();
        if (!currentUser.equals(normalLibraryOwner)) {
            if (normalLibraryOwner != null) {
                SeawindUIPlugin.log("The normal seawind local caches will be deleted because the user has signed out from it.");
            }
            return;
        }
        try {
            SeawindUIPlugin.log("Migrating seawind library to an encrypted folder.");
            FileUtils.transfer((IStorage)normalStorage, (IStorage)securedStorage);
            SeawindUIPlugin.log("Seawind library migrated to an encrypted folder.");
        }
        catch (Exception e) {
            SeawindUIPlugin.log(e, "Failed to migrate seawind library to an encrypted folder.");
        }
    }

    private void migrateFromSecuredStorageToNormalStorage(IStorage secretStorage, IStorage normalStorage, String cipherAlgorithm) {
        SecretKeySpec secretKey;
        String normalLibraryOwner = SeawindLibrary.peekLibraryUserName(normalStorage);
        String currentUser = (String)AccountManager.getPrimaryAccount().getProperty("user");
        boolean hasSecuredInfo = secretStorage.getInputSource().hasEntry("info.json");
        if (currentUser == null) {
            if (hasSecuredInfo) {
                SeawindUIPlugin.log("The encrypted seawind local caches will be deleted because the user has signed out from xmind.");
            }
            if (normalLibraryOwner != null) {
                SeawindUIPlugin.log("The legacy seawind local caches will be deleted because the user has signed out from xmind.");
            }
            normalStorage.clear();
            return;
        }
        if (currentUser.equals(normalLibraryOwner)) {
            if (hasSecuredInfo) {
                SeawindUIPlugin.log("The encrypted seawind local caches will be deleted because we should not migrate them into an unencrypted one with existing content: currentUser=" + currentUser + ", normalLibraryOwner=" + normalLibraryOwner);
            }
            return;
        }
        SeawindUIPlugin.log("The normal seawind local caches will be deleted because the user has signed out from it: currentUser=" + currentUser + ", normalLibraryOwner=" + normalLibraryOwner);
        normalStorage.clear();
        try {
            secretKey = this.obtainSecretKey(cipherAlgorithm, false);
        }
        catch (Exception e) {
            if (hasSecuredInfo) {
                SeawindUIPlugin.log(e, "The encrypted seawind local caches will be deleted because we couldn't obtain a secret key to decrypt it.");
            }
            return;
        }
        if (secretKey == null) {
            if (hasSecuredInfo) {
                SeawindUIPlugin.log("The encrypted seawind local caches will be deleted because we couldn't obtain a secret key to decrypt it.");
            }
            return;
        }
        SecuredStorage securedStorage = new SecuredStorage(secretStorage, cipherAlgorithm, secretKey);
        String securedLibraryOwner = SeawindLibrary.peekLibraryUserName(securedStorage);
        if (!currentUser.equals(securedLibraryOwner)) {
            if (securedLibraryOwner != null) {
                SeawindUIPlugin.log("The encrypted seawind local caches will be deleted because the user has signed out from it");
            }
            return;
        }
        try {
            SeawindUIPlugin.log("Migrating seawind library to a decrypted folder.");
            FileUtils.transfer((IStorage)securedStorage, (IStorage)normalStorage);
            SeawindUIPlugin.log("Seawind library migrated to a decrypted folder.");
        }
        catch (Exception e) {
            SeawindUIPlugin.log(e, "Failed to migrate seawind library to a decrypted folder.");
        }
    }
}

