/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.animation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.xmind.ui.animation.IAnimationTask;
import org.xmind.ui.util.UITimer;

public class AnimationTimer
extends UITimer {
    private List<IAnimationTask> tasks;
    private Runnable afterEffects = null;
    private boolean finishOnCanceled = true;

    public AnimationTimer(int delay, int interval, int loops, IAnimationTask task) {
        this(delay, interval, loops, Collections.singleton(task));
    }

    public AnimationTimer(int delay, int interval, int loops, Collection<IAnimationTask> tasks) {
        super(delay, interval, loops, null);
        this.tasks = new ArrayList<IAnimationTask>(tasks);
        this.setTask((ISafeRunnable)this.createMainTask());
    }

    private SafeRunnable createMainTask() {
        return new SafeRunnable(){

            public void run() throws Exception {
                AnimationTimer.this.performTasks();
            }
        };
    }

    public Runnable getAfterEffects() {
        return this.afterEffects;
    }

    public void setAfterEffects(Runnable afterEffects) {
        this.afterEffects = afterEffects;
    }

    private void doTask(IAnimationTask task) {
        task.setValue(task.getCurrentValue(this.getCurrentLoop(), this.getLoops()));
    }

    protected void doJob() {
        this.onStart();
        super.doJob();
    }

    public void cancel() {
        super.cancel();
        if (this.isValid()) {
            for (IAnimationTask task : this.tasks) {
                task.cancel();
            }
            if (this.isFinishOnCanceled()) {
                this.onFinished();
            }
        }
    }

    protected void onStart() {
        if (this.isValid()) {
            for (IAnimationTask task : this.tasks) {
                task.start();
            }
        }
    }

    protected void onFinished() {
        if (this.isValid()) {
            for (IAnimationTask task : this.tasks) {
                task.finish();
            }
            if (this.afterEffects != null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        AnimationTimer.this.afterEffects.run();
                    }
                });
            }
        }
    }

    protected void performTasks() {
        for (IAnimationTask task : this.tasks) {
            this.doTask(task);
        }
    }

    public List<IAnimationTask> getTasks() {
        return this.tasks;
    }

    public boolean isFinishOnCanceled() {
        return this.finishOnCanceled;
    }

    public void setFinishOnCanceled(boolean finishOnCanceled) {
        this.finishOnCanceled = finishOnCanceled;
    }
}

