/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.animation;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.ui.animation.AlphaAnimationTask;
import org.xmind.ui.animation.IAnimationTask;

public class AnimationTaskFactory {
    private AnimationTaskFactory() {
    }

    public static IAnimationTask createMainAlphaTask(IUseTransparency source, int start, int end) {
        return new AlphaAnimationTask((Object)source, start, end){

            @Override
            public void setValue(Object value) {
                ((IUseTransparency)this.getSource()).setMainAlpha(((Integer)value).intValue());
            }

            @Override
            public void start() {
                super.start();
                if (this.getSource() instanceof IFigure) {
                    ((IFigure)this.getSource()).setVisible(true);
                }
            }
        };
    }

    public static IAnimationTask createSubAlphaTask(IUseTransparency source, int start, int end) {
        return new AlphaAnimationTask((Object)source, start, end){

            @Override
            public void setValue(Object value) {
                ((IUseTransparency)this.getSource()).setSubAlpha(((Integer)value).intValue());
            }

            @Override
            public void start() {
                super.start();
                if (this.getSource() instanceof IFigure) {
                    ((IFigure)this.getSource()).setVisible(true);
                }
            }
        };
    }

    public static IAnimationTask createDecorationAlphaTask(IDecoration source, final IFigure hostingFigure, int start, int end) {
        return new AlphaAnimationTask(source, start, end){

            @Override
            public void setValue(Object value) {
                ((IDecoration)this.getSource()).setAlpha(hostingFigure, ((Integer)value).intValue());
            }

            @Override
            public void start() {
                super.start();
                ((IDecoration)this.getSource()).setVisible(hostingFigure, true);
            }
        };
    }
}

