/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.command;

import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.ICommandHandler;
import org.xmind.core.command.ICommandService;
import org.xmind.core.command.IReturnValueConsumer;
import org.xmind.core.command.ReturnValue;
import org.xmind.core.command.binary.IBinaryStore;
import org.xmind.core.internal.command.Logger;
import org.xmind.core.internal.command.Messages;
import org.xmind.core.internal.command.XMindCommandHandlerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMindCommandService
implements ICommandService {
    private static final String[] NO_MATCH_GROUPS = new String[0];

    XMindCommandService() {
    }

    @Override
    public IStatus execute(IProgressMonitor monitor, ICommand command, IReturnValueConsumer returnValueConsumer) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(null, 100);
        monitor.subTask(NLS.bind((String)Messages.XMindCommandService_ExcutingCommand, (Object)command));
        SubProgressMonitor executeMonitor = new SubProgressMonitor(monitor, 90);
        IStatus returnValue = this.executeCommand((IProgressMonitor)executeMonitor, command);
        if (!executeMonitor.isCanceled()) {
            executeMonitor.done();
        }
        try {
            monitor.subTask(Messages.XMindCommandService_ConsumingValue);
            SubProgressMonitor consumeMonitor = new SubProgressMonitor(monitor, 10);
            this.consumeCommand((IProgressMonitor)consumeMonitor, command, returnValue, returnValueConsumer);
            if (!consumeMonitor.isCanceled()) {
                consumeMonitor.done();
            }
            if (!monitor.isCanceled()) {
                monitor.done();
            }
            IStatus iStatus = returnValue;
            return iStatus;
        }
        finally {
            Object value;
            if (returnValue != null && returnValue instanceof ReturnValue && (value = ((ReturnValue)returnValue).getValue()) instanceof IBinaryStore) {
                ((IBinaryStore)value).clear();
            }
        }
    }

    private IStatus executeCommand(IProgressMonitor monitor, ICommand command) {
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.XMindCommandService_SearchHandler_Message);
        List<XMindCommandHandlerRegistry.CommandHandlerDescriptor> handlerDescriptors = XMindCommandHandlerRegistry.getInstance().findMatchedHandlerDescriptors(command);
        if (handlerDescriptors.isEmpty()) {
            monitor.done();
            return new Status(2, "org.xmind.core.command", 10001, NLS.bind((String)Messages.XMindCommandService_SearchHandlersError_Message, (Object)command), null);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(10);
        monitor.subTask(NLS.bind((String)Messages.XMindCommandService_HandingCommand_Message, (Object)command));
        SubProgressMonitor handlersMonitor = new SubProgressMonitor(monitor, 80);
        IStatus returnValue = this.handleCommand(handlersMonitor, command, handlerDescriptors);
        if (returnValue != null && !returnValue.isOK() && returnValue.getSeverity() != 8) {
            Logger.log(returnValue);
        } else if (returnValue == null) {
            Logger.log("Command not handled: " + command, null);
            returnValue = new Status(2, "org.xmind.core.command", 10002, NLS.bind((String)Messages.XMindCommandService_CommandHandledError_Message, (Object)command), null);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        handlersMonitor.done();
        monitor.done();
        return returnValue;
    }

    protected IStatus handleCommand(SubProgressMonitor monitor, ICommand command, List<XMindCommandHandlerRegistry.CommandHandlerDescriptor> handlerDescriptors) {
        IStatus returnValue = null;
        try {
            monitor.beginTask(null, handlerDescriptors.size());
            for (XMindCommandHandlerRegistry.CommandHandlerDescriptor handlerDescriptor : handlerDescriptors) {
                ICommandHandler handler = handlerDescriptor.getHandler();
                if (handler == null) continue;
                SubProgressMonitor handlerMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 1);
                returnValue = handler.execute((IProgressMonitor)handlerMonitor, command, this.getMatchGroups(handlerDescriptor, command));
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                handlerMonitor.done();
                if (returnValue == null) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            return new Status(4, "org.xmind.core.command", NLS.bind((String)Messages.XMindCommandService_InvokingCommandError_Message, (Object)e.toString()), e);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return returnValue;
    }

    private String[] getMatchGroups(XMindCommandHandlerRegistry.CommandHandlerDescriptor handlerDescriptor, ICommand command) {
        Matcher matcher = handlerDescriptor.match(command.getCommandName());
        if (!matcher.find()) {
            return NO_MATCH_GROUPS;
        }
        int total = matcher.groupCount();
        if (total <= 0) {
            return NO_MATCH_GROUPS;
        }
        String[] groups = new String[total];
        int i = 0;
        while (i < total) {
            groups[i] = matcher.group(i + 1);
            ++i;
        }
        return groups;
    }

    private void consumeCommand(IProgressMonitor monitor, ICommand command, IStatus returnValue, IReturnValueConsumer returnValueConsumer) {
        if (returnValueConsumer != null) {
            try {
                IStatus consumed = returnValueConsumer.consumeReturnValue(monitor, returnValue);
                if (!monitor.isCanceled() && consumed != null && !consumed.isOK() && consumed.getSeverity() != 8) {
                    Logger.log(consumed);
                }
            }
            catch (Throwable e) {
                Logger.log("Error occurred while consuming return value.", e);
            }
        }
    }
}

