/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicPath;
import org.xmind.core.IWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicCompartor
implements Comparator<ITopic> {
    private List<String> TOPIC_TYPES = Arrays.asList("root", "attached", "detached", "summary", "callout");

    @Override
    public int compare(ITopic t1, ITopic t2) {
        ISheet s2;
        if (t1 == null && t2 == null) {
            return -10000;
        }
        if (t1 == null) {
            return 10000;
        }
        if (t2 == null) {
            return -10000;
        }
        if (t1.equals(t2)) {
            return 0;
        }
        ITopicPath p1 = t1.getPath();
        ITopicPath p2 = t2.getPath();
        IWorkbook workbook = p1.getWorkbook();
        if (workbook == null || !workbook.equals(p2.getWorkbook())) {
            return -1000;
        }
        ISheet s1 = p1.getSheet();
        if (!s1.equals(s2 = p2.getSheet())) {
            return s1.getIndex() - s2.getIndex();
        }
        List<ITopic> tl1 = p1.toTopicList();
        List<ITopic> tl2 = p2.toTopicList();
        int total = Math.max(tl1.size(), tl2.size());
        int i = 0;
        while (i < total) {
            ITopic c2;
            ITopic c1 = i < tl1.size() ? tl1.get(i) : null;
            ITopic iTopic = c2 = i < tl2.size() ? tl2.get(i) : null;
            if (c1 == null) {
                return -100;
            }
            if (c2 == null) {
                return 100;
            }
            if (!c1.equals(c2)) {
                String type2;
                String type1 = c1.getType();
                if (!type1.equals(type2 = c2.getType())) {
                    return this.TOPIC_TYPES.indexOf(type1) - this.TOPIC_TYPES.indexOf(type2);
                }
                return c1.getIndex() - c2.getIndex();
            }
            ++i;
        }
        return 0;
    }
}

