/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class TransparentCornerLabel
extends Label {
    private int alpha = 255;
    private Dimension corner = new Dimension(0, 0);

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setCornerDimensions(Dimension d) {
        this.corner.width = d.width;
        this.corner.height = d.height;
    }

    public void setCornerDimensions(int value) {
        this.corner.width = value;
        this.corner.height = value;
    }

    public Dimension getCornerDimensions() {
        return this.corner.getCopy();
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setAlpha(this.alpha);
        if (this.isOpaque()) {
            graphics.fillRoundRectangle(this.getBounds(), this.corner.width, this.corner.height);
            if (this.getBorder() instanceof AbstractBackground) {
                ((AbstractBackground)this.getBorder()).paintBackground((IFigure)this, graphics, NO_INSETS);
            }
        }
        Rectangle bounds = this.getBounds();
        graphics.translate(bounds.x, bounds.y);
        if (this.getIcon() != null) {
            graphics.drawImage(this.getIcon(), this.getIconLocation());
        }
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            graphics.drawText(this.getSubStringText(), this.getTextLocation());
            graphics.translate(-1, -1);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
        }
        graphics.drawText(this.getSubStringText(), this.getTextLocation());
        graphics.translate(-bounds.x, -bounds.y);
    }
}

