/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.styleeditor.StyleEditorMessages;
import org.xmind.ui.internal.views.StyleFigure;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.FloatingTextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedStylesViewer2
extends GalleryViewer
implements ICoreEventListener {
    public static final Object ADD_STYLE = "ADD_STYLE";
    private ICoreEventRegister register;
    private String styleType;

    public AdvancedStylesViewer2(String styleType) {
        this.styleType = styleType;
        this.setPartFactory(new AdvancedStylePartFactory(this.getPartFactory()));
        this.setContentProvider(new AdvancedStyleContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new AdvancedStyleLabelProvider());
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 3, 1, 1, new Insets(5)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(64, 64));
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_TOP);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new StyleSelectTool());
        editDomain.installTool("edit tool", (ITool)new StyleNameEditTool());
        this.setEditDomain(editDomain);
        ICoreEventSupport ces = (ICoreEventSupport)MindMapUI.getResourceManager().getUserStyleSheet().getAdapter(ICoreEventSupport.class);
        if (ces != null) {
            this.register = new CoreEventRegister((ICoreEventListener)this);
            this.register.setNextSupport(ces);
            this.register.register("styleAdd");
            this.register.register("styleRemove");
            this.register.register("name");
        }
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.register != null) {
            this.register.unregisterAll();
        }
        super.handleDispose(event);
    }

    public void handleCoreEvent(final CoreEvent event) {
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        final String type = event.getType();
        c.getDisplay().syncExec(new Runnable(){

            public void run() {
                if ("name".equals(type)) {
                    AdvancedStylesViewer2.this.refresh();
                } else {
                    Object target;
                    AdvancedStylesViewer2.this.setInput(AdvancedStylesViewer2.this.getStylesViewerInput());
                    if ("styleAdd".equals(type) && (target = event.getTarget()) instanceof IStyle) {
                        AdvancedStylesViewer2.this.setSelection((ISelection)new StructuredSelection(target), true);
                    }
                }
            }
        });
    }

    private Object getStylesViewerInput() {
        IResourceManager resourceManager = MindMapUI.getResourceManager();
        IStyleSheet systemStyleSheet = resourceManager.getSystemStyleSheet();
        Set systemStyles = systemStyleSheet.getStyles("automatic-styles");
        HashSet<IStyle> removingSysStyles = new HashSet<IStyle>();
        for (IStyle style : systemStyles) {
            if (this.styleType.equals(style.getType())) continue;
            removingSysStyles.add(style);
        }
        systemStyles.removeAll(removingSysStyles);
        IStyleSheet userStyleSheet = resourceManager.getUserStyleSheet();
        Set userStyles = userStyleSheet.getAllStyles();
        HashSet<IStyle> removingUserStyles = new HashSet<IStyle>();
        for (IStyle style : userStyles) {
            if (this.styleType.equals(style.getType())) continue;
            removingUserStyles.add(style);
        }
        userStyles.removeAll(removingUserStyles);
        ArrayList<Object> input = new ArrayList<Object>(systemStyles.size() + userStyles.size() + 1);
        input.add(ADD_STYLE);
        input.addAll(this.getReversed(userStyles));
        input.addAll(systemStyles);
        return input;
    }

    private List<Object> getReversed(Collection<?> sourceList) {
        LinkedList<Object> targetList = new LinkedList<Object>();
        for (Object item : sourceList) {
            targetList.add(0, item);
        }
        return targetList;
    }

    public void startEditing(IStyle style) {
        EditDomain domain = this.getEditDomain();
        ITool tool = domain.getDefaultTool();
        ((GallerySelectTool)tool).getStatus().setStatus(1, true);
        domain.handleRequest("edit", (IViewer)this);
    }

    private static class AdvancedStyleContentProvider
    implements IStructuredContentProvider {
        private AdvancedStyleContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }
    }

    private static class AdvancedStyleLabelProvider
    extends LabelProvider {
        private AdvancedStyleLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IStyle) {
                IStyle style = (IStyle)element;
                return style.getName();
            }
            if (element instanceof String) {
                return StyleEditorMessages.AdvancedStylesViewer_NewStyle_text;
            }
            return super.getText(element);
        }
    }

    private static class AdvancedStylePart
    extends GraphicalEditPart {
        public AdvancedStylePart(Object style) {
            this.setModel(style);
        }

        public IStyle getStyle() {
            if (super.getModel() == ADD_STYLE) {
                return null;
            }
            return (IStyle)super.getModel();
        }

        protected IFigure createFigure() {
            if (super.getModel() == ADD_STYLE) {
                return new StyleADDFigure();
            }
            return new StyleFigure();
        }

        protected void updateView() {
            super.updateView();
            if (super.getModel() == ADD_STYLE) {
                this.getFigure().setPreferredSize(new Dimension(64, 64));
                return;
            }
            ((StyleFigure)this.getFigure()).setStyle(this.getStyle());
            Properties properties = ((GalleryViewer)this.getSite().getViewer()).getProperties();
            Dimension size = (Dimension)properties.get("org.xmind.ui.gallery.frameContentSize");
            if (size != null) {
                this.getFigure().setPreferredSize(size);
            }
        }

        protected void register() {
            IStyle style = this.getStyle();
            if (style != null) {
                this.registerModel(style.getId());
            } else {
                this.registerModel(ADD_STYLE);
            }
            super.register();
        }

        protected void unregister() {
            super.unregister();
            IStyle style = this.getStyle();
            if (style != null) {
                this.unregisterModel(style.getId());
            } else {
                this.unregisterModel(ADD_STYLE);
            }
        }
    }

    private static class AdvancedStylePartFactory
    implements IPartFactory {
        private IPartFactory factory;

        public AdvancedStylePartFactory(IPartFactory factory) {
            this.factory = factory;
        }

        public IPart createPart(IPart context, Object model) {
            if (context instanceof FramePart && model instanceof IStyle) {
                return new AdvancedStylePart((IStyle)model);
            }
            if (context instanceof FramePart && model == ADD_STYLE) {
                return new AdvancedStylePart(ADD_STYLE);
            }
            return this.factory.createPart(context, model);
        }
    }

    private static class StyleADDFigure
    extends Figure {
        private StyleADDFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.setAntialias(1);
            graphics.setTextAntialias(1);
            Rectangle r = this.getClientArea(new Rectangle());
            graphics.setBackgroundColor(new Color(null, 192, 192, 192));
            int[] points = new int[]{r.x + r.width * 7 / 32, r.y + r.height * 7 / 16, r.x + r.width * 7 / 16, r.y + r.height * 7 / 16, r.x + r.width * 7 / 16, r.y + r.height * 7 / 32, r.x + r.width * 9 / 16, r.y + r.height * 7 / 32, r.x + r.width * 9 / 16, r.y + r.height * 7 / 16, r.x + r.width * 25 / 32, r.y + r.height * 7 / 16, r.x + r.width * 25 / 32, r.y + r.height * 9 / 16, r.x + r.width * 9 / 16, r.y + r.height * 9 / 16, r.x + r.width * 9 / 16, r.y + r.height * 25 / 32, r.x + r.width * 7 / 16, r.y + r.height * 25 / 32, r.x + r.width * 7 / 16, r.y + r.height * 9 / 16, r.x + r.width * 7 / 32, r.y + r.height * 9 / 16, r.x + r.width * 7 / 32, r.y + r.height * 7 / 16};
            graphics.fillPolygon(points);
        }
    }

    private static class StyleNameEditTool
    extends GalleryEditTool {
        private StyleNameEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((IStyle)source.getModel()).getName());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            ((IStyle)source.getModel()).setName(document.get());
            MindMapUI.getResourceManager().saveUserStyleSheet();
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            this.getHelper().setPrefWidth(70);
        }
    }

    private static class StyleSelectTool
    extends GallerySelectTool {
        private StyleSelectTool() {
        }

        protected boolean isTitleEditable(IPart p) {
            Object model = p.getModel();
            if (!(model instanceof IStyle)) {
                return false;
            }
            return ((IStyle)model).getOwnedStyleSheet() != MindMapUI.getResourceManager().getSystemStyleSheet();
        }
    }
}

