/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.Property;
import org.xmind.ui.internal.handlers.MindMapHandlerUtil;
import org.xmind.ui.internal.styleeditor.StyleEditModel;
import org.xmind.ui.internal.styleeditor.StyleEditorMessages;
import org.xmind.ui.mindmap.MindMapUI;

public class DuplicateStyleHandler
extends AbstractHandler {
    private boolean enable = true;

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final List duplicatableStyles = MindMapHandlerUtil.findStyles((ExecutionEvent)event);
        if (duplicatableStyles.isEmpty()) {
            return null;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                ArrayList<IStyle> newStyles = new ArrayList<IStyle>(duplicatableStyles.size());
                for (IStyle styleDuplicated : duplicatableStyles) {
                    if ("theme".equals(styleDuplicated.getType())) {
                        newStyles.add(DuplicateStyleHandler.this.duplicateTheme(styleDuplicated));
                        continue;
                    }
                    newStyles.add(DuplicateStyleHandler.this.duplicateStyle(styleDuplicated));
                }
                IWorkbenchSite activeSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
                if (activeSite == null) {
                    return;
                }
                ISelectionProvider selectionProvider = activeSite.getSelectionProvider();
                if (selectionProvider == null) {
                    return;
                }
                selectionProvider.setSelection((ISelection)new StructuredSelection(newStyles));
            }
        });
        return null;
    }

    private IStyle duplicateStyle(IStyle styleDuplicated) {
        IStyleSheet styleSheet = MindMapUI.getResourceManager().getUserStyleSheet();
        IStyle style = styleSheet.createStyle(styleDuplicated.getType());
        StyleEditModel.load(MindMapUI.getResourceManager().toResourceURI((Object)styleDuplicated), styleDuplicated.getName()).writeStyle(style);
        style.setName(NLS.bind((String)StyleEditorMessages.DuplicateStyleHandler_NewName, (Object)styleDuplicated.getName()));
        styleSheet.addStyle(style, "normal-styles");
        MindMapUI.getResourceManager().saveUserStyleSheet();
        return style;
    }

    private IStyle duplicateTheme(IStyle styleDuplicated) {
        IStyleSheet styleSheet = MindMapUI.getResourceManager().getUserThemeSheet();
        IStyle themeCreated = styleSheet.createStyle(styleDuplicated.getType());
        themeCreated.setName(NLS.bind((String)StyleEditorMessages.DuplicateStyleHandler_NewName, (Object)styleDuplicated.getName()));
        Iterator defaultStyles = styleDuplicated.defaultStyles();
        while (defaultStyles.hasNext()) {
            Property p = (Property)defaultStyles.next();
            IStyle defaultStyle = styleDuplicated.getDefaultStyle(p.key);
            if (defaultStyle == null) continue;
            IStyle styleCreated = styleSheet.createStyle(this.transformStyleFamilyToStyleType(p.key));
            Iterator ps = defaultStyle.properties();
            while (ps.hasNext()) {
                Property next = (Property)ps.next();
                styleCreated.setProperty(next.key, next.value);
            }
            themeCreated.setDefaultStyleId(p.key, styleCreated.getId());
            styleSheet.addStyle(styleCreated, "automatic-styles");
        }
        styleSheet.addStyle(themeCreated, "master-styles");
        MindMapUI.getResourceManager().saveUserThemeSheet();
        return themeCreated;
    }

    private String transformStyleFamilyToStyleType(String family) {
        if ("centralTopic".equals(family) || "mainTopic".equals(family) || "subTopic".equals(family) || "summaryTopic".equals(family) || "floatingTopic".equals(family) || "calloutTopic".equals(family)) {
            return "topic";
        }
        if ("relationship".equals(family)) {
            return "relationship";
        }
        if ("boundary".equals(family)) {
            return "boundary";
        }
        if ("map".equals(family)) {
            return "map";
        }
        if ("summary".equals(family)) {
            return "summary";
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setBaseEnabled(boolean state) {
        this.enable = state;
        super.setBaseEnabled(state);
    }
}

