/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.index.resource;

import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.index.resource.AZResourceForSheet;
import org.xmind.ui.internal.index.resource.AZResourceForWorkbook;
import org.xmind.ui.internal.index.resource.AssigneeResourceForSheet;
import org.xmind.ui.internal.index.resource.AssigneeResourceForWorkbook;
import org.xmind.ui.internal.index.resource.IAZResource;
import org.xmind.ui.internal.index.resource.IIndexResource;
import org.xmind.ui.internal.index.resource.ITaskDateResource;
import org.xmind.ui.internal.index.resource.LabelResourceForSheet;
import org.xmind.ui.internal.index.resource.LabelResourceForWorkbook;
import org.xmind.ui.internal.index.resource.MarkerResourceForSheet;
import org.xmind.ui.internal.index.resource.MarkerResourceForWorkbook;
import org.xmind.ui.internal.index.resource.TaskDateResourceForSheet;
import org.xmind.ui.internal.index.resource.TaskDateResourceForWorkbook;

public class IndexResources {
    private IIndexResource markerResourceForWorkbook;
    private IIndexResource markerResourceForSheet;
    private IIndexResource labelResourceForWorkbook;
    private IIndexResource labelResourceForSheet;
    private IIndexResource assigneeResourceForWorkbook;
    private IIndexResource assigneeResourceForSheet;
    private ITaskDateResource taskDateResourceForWorkbook;
    private ITaskDateResource taskDateResourceForSheet;
    private IAZResource azResourceForWorkbook;
    private IAZResource azResourceForSheet;

    public IIndexResource getResourceForSheet(ISheet sheet, int indexType, boolean forceUpdate) {
        IIndexResource resource = null;
        if (sheet != null) {
            switch (indexType) {
                case 1: {
                    resource = this.getMarkerResourceForSheet(sheet, forceUpdate);
                    break;
                }
                case 2: {
                    resource = this.getLabelResourceForSheet(sheet, forceUpdate);
                    break;
                }
                case 16: {
                    resource = this.getAssigneeResourceForSheet(sheet, forceUpdate);
                    break;
                }
                case 4: {
                    resource = this.getTaskDateResourceForSheet(sheet, indexType, forceUpdate);
                    break;
                }
                case 8: {
                    resource = this.getTaskDateResourceForSheet(sheet, indexType, forceUpdate);
                    break;
                }
                case 32: {
                    resource = this.getAZResourceForSheet(sheet, true, forceUpdate);
                    break;
                }
                case 64: {
                    resource = this.getAZResourceForSheet(sheet, false, forceUpdate);
                }
            }
        }
        return resource;
    }

    public IIndexResource getResourceForWorkbook(IWorkbook workbook, int indexType, boolean forceUpdate) {
        IIndexResource resource = null;
        if (workbook != null) {
            switch (indexType) {
                case 1: {
                    resource = this.getMarkerResourceForWorkbook(workbook, forceUpdate);
                    break;
                }
                case 2: {
                    resource = this.getLabelResourceForWorkbook(workbook, forceUpdate);
                    break;
                }
                case 16: {
                    resource = this.getAssigneeResourceForWorkbook(workbook, forceUpdate);
                    break;
                }
                case 4: {
                    resource = this.getTaskDateResourceForWorkbook(workbook, indexType, forceUpdate);
                    break;
                }
                case 8: {
                    resource = this.getTaskDateResourceForWorkbook(workbook, indexType, forceUpdate);
                    break;
                }
                case 32: {
                    resource = this.getAZResourceForWorkbook(workbook, true, forceUpdate);
                    break;
                }
                case 64: {
                    resource = this.getAZResourceForWorkbook(workbook, false, forceUpdate);
                }
            }
        }
        return resource;
    }

    private IIndexResource getMarkerResourceForWorkbook(IWorkbook workbook, boolean forceUpdate) {
        if (this.markerResourceForWorkbook != null && forceUpdate) {
            this.markerResourceForWorkbook.reset(workbook, true);
        }
        if (this.markerResourceForWorkbook == null) {
            this.markerResourceForWorkbook = new MarkerResourceForWorkbook(workbook);
        }
        return this.markerResourceForWorkbook;
    }

    private IIndexResource getMarkerResourceForSheet(ISheet sheet, boolean forceUpdate) {
        if (this.markerResourceForSheet != null && forceUpdate) {
            this.markerResourceForSheet.reset(sheet, true);
        }
        if (this.markerResourceForSheet == null) {
            this.markerResourceForSheet = new MarkerResourceForSheet(sheet);
        }
        return this.markerResourceForSheet;
    }

    private IIndexResource getLabelResourceForSheet(ISheet sheet, boolean forceUpdate) {
        if (this.labelResourceForSheet != null && forceUpdate) {
            this.labelResourceForSheet.reset(sheet, true);
        }
        if (this.labelResourceForSheet == null) {
            this.labelResourceForSheet = new LabelResourceForSheet(sheet);
        }
        return this.labelResourceForSheet;
    }

    private IIndexResource getLabelResourceForWorkbook(IWorkbook workbook, boolean forceUpdate) {
        if (this.labelResourceForWorkbook != null && forceUpdate) {
            this.labelResourceForWorkbook.reset(workbook, true);
        }
        if (this.labelResourceForWorkbook == null) {
            this.labelResourceForWorkbook = new LabelResourceForWorkbook(workbook);
        }
        return this.labelResourceForWorkbook;
    }

    private IIndexResource getAssigneeResourceForSheet(ISheet sheet, boolean forceUpdate) {
        if (this.assigneeResourceForSheet != null && forceUpdate) {
            this.assigneeResourceForSheet.reset(sheet, true);
        }
        if (this.assigneeResourceForSheet == null) {
            this.assigneeResourceForSheet = new AssigneeResourceForSheet(sheet);
        }
        return this.assigneeResourceForSheet;
    }

    private IIndexResource getAssigneeResourceForWorkbook(IWorkbook workbook, boolean forceUpdate) {
        if (this.assigneeResourceForWorkbook != null && forceUpdate) {
            this.assigneeResourceForWorkbook.reset(workbook, true);
        }
        if (this.assigneeResourceForWorkbook == null) {
            this.assigneeResourceForWorkbook = new AssigneeResourceForWorkbook(workbook);
        }
        return this.assigneeResourceForWorkbook;
    }

    private IIndexResource getTaskDateResourceForSheet(ISheet sheet, int taskDateType, boolean forceUpdate) {
        if (this.taskDateResourceForSheet != null && forceUpdate) {
            this.taskDateResourceForSheet.reset(sheet, forceUpdate);
        }
        if (this.taskDateResourceForSheet == null) {
            this.taskDateResourceForSheet = new TaskDateResourceForSheet(sheet, taskDateType);
        }
        this.taskDateResourceForSheet.setTaskDateResourceType(taskDateType);
        return this.taskDateResourceForSheet;
    }

    private IIndexResource getTaskDateResourceForWorkbook(IWorkbook workbook, int taskDateType, boolean forceUpdate) {
        if (this.taskDateResourceForWorkbook != null && forceUpdate) {
            this.taskDateResourceForWorkbook.reset(workbook, forceUpdate);
        }
        if (this.taskDateResourceForWorkbook == null) {
            this.taskDateResourceForWorkbook = new TaskDateResourceForWorkbook(workbook, taskDateType);
        }
        this.taskDateResourceForWorkbook.setTaskDateResourceType(taskDateType);
        return this.taskDateResourceForWorkbook;
    }

    private IIndexResource getAZResourceForSheet(ISheet sheet, boolean isPositiveSequence, boolean forceUpdate) {
        if (this.azResourceForSheet != null && forceUpdate) {
            this.azResourceForSheet.reset(sheet, true);
        }
        if (this.azResourceForSheet == null) {
            this.azResourceForSheet = new AZResourceForSheet(sheet);
        }
        this.azResourceForSheet.setSequence(isPositiveSequence);
        return this.azResourceForSheet;
    }

    private IIndexResource getAZResourceForWorkbook(IWorkbook workbook, boolean isPositiveSequence, boolean forceUpdate) {
        if (this.azResourceForWorkbook != null && forceUpdate) {
            this.azResourceForWorkbook.reset(workbook, true);
        }
        if (this.azResourceForWorkbook == null) {
            this.azResourceForWorkbook = new AZResourceForWorkbook(workbook);
        }
        this.azResourceForWorkbook.setSequence(isPositiveSequence);
        return this.azResourceForWorkbook;
    }
}

