/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.engine.currency.CurrencyPair;
import org.yccheok.jstock.file.GUIBundleWrapper;
import org.yccheok.jstock.file.Statement;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.portfolio.Activity;
import org.yccheok.jstock.portfolio.ActivitySummary;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.DecimalPlace;
import org.yccheok.jstock.portfolio.Deposit;
import org.yccheok.jstock.portfolio.DepositSummary;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.DividendSummary;
import org.yccheok.jstock.portfolio.PortfolioInfo;
import org.yccheok.jstock.portfolio.PortfolioRealTimeInfo;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;

public class Utils {
    private static final ThreadLocal<NumberFormat> unitsNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.####");
        }
    };
    private static final ThreadLocal<NumberFormat> twoDecimalPlaceCurrencyNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.00");
        }
    };
    private static final ThreadLocal<NumberFormat> threeDecimalPlaceCurrencyNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.00#");
        }
    };
    private static final ThreadLocal<NumberFormat> fourDecimalPlaceCurrencyNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.00##");
        }
    };
    private static final ThreadLocal<NumberFormat> quantityNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.###");
        }
    };
    private static final ThreadLocal<NumberFormat> exchangeRateNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.######");
        }
    };
    private static final ThreadLocal<NumberFormat> editThreeCurrencyNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            DecimalFormat decimalFormat = new DecimalFormat("0.###");
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            return decimalFormat;
        }
    };
    private static final double EPSILON = 1.0E-8;
    private static final Log log = LogFactory.getLog(Utils.class);

    private Utils() {
    }

    @Deprecated
    public static Pair<HashMap<Code, Double>, Long> getCSVStockPrices() {
        File stockPricesFile = new File(Utils.getStockPricesFilepath());
        HashMap<Code, Double> stockPrices = new HashMap<Code, Double>();
        Statements statements = Statements.newInstanceFromCSVFile(stockPricesFile);
        if (statements.getType() == Statement.Type.StockPrice) {
            GUIBundleWrapper guiBundleWrapper = statements.getGUIBundleWrapper();
            int ei = statements.size();
            for (int i = 0; i < ei; ++i) {
                Statement statement = statements.get(i);
                String codeStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                Double price = statement.getValueAsDouble(guiBundleWrapper.getString("MainFrame_Last"));
                if (codeStr == null || price == null) continue;
                Code code = Code.newInstance(codeStr);
                stockPrices.put(code, price);
            }
        }
        long _timestamp = 0L;
        try {
            _timestamp = Long.parseLong(statements.getMetadatas().get("timestamp"));
        }
        catch (NumberFormatException ex) {
            log.error(null, (Throwable)ex);
        }
        return Pair.create(stockPrices, _timestamp);
    }

    public static boolean shouldConvertPenceToPound(Country country) {
        Currency stockCurrency = country.stockCurrency;
        return Utils.shouldConvertPenceToPound(stockCurrency);
    }

    public static boolean shouldConvertPenceToPound(PortfolioRealTimeInfo portfolioRealTimeInfo, Code code) {
        Currency stockCurrency = Utils.getStockCurrency(portfolioRealTimeInfo, code);
        return Utils.shouldConvertPenceToPound(stockCurrency);
    }

    public static boolean shouldConvertPenceToPound(Currency currency) {
        if (currency == null) {
            return false;
        }
        return currency.isGBX() || currency.isZAC() || currency.isILA();
    }

    public static Currency getLocalCurrency() {
        Currency localCurrency;
        Country country;
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        boolean currencyExchangeEnable = jStockOptions.isCurrencyExchangeEnable(country = jStockOptions.getCountry());
        if (currencyExchangeEnable) {
            Country localCountry = jStockOptions.getLocalCurrencyCountry(country);
            localCurrency = localCountry.localCurrency;
        } else {
            localCurrency = null;
        }
        return localCurrency;
    }

    public static Currency getStockCurrency(PortfolioRealTimeInfo portfolioRealTimeInfo, Code code) {
        Currency stockCurrency;
        Currency c = portfolioRealTimeInfo.currencies.get(code);
        if (c == null) {
            Country stockCountry = org.yccheok.jstock.engine.Utils.toCountry(code);
            stockCurrency = stockCountry.stockCurrency;
        } else {
            stockCurrency = c;
        }
        return stockCurrency;
    }

    public static double getExchangeRate(PortfolioRealTimeInfo portfolioRealTimeInfo, Currency localCurrency, Currency stockCurrency) {
        Double rate;
        if (localCurrency == null) {
            if (stockCurrency.isGBX() || stockCurrency.isZAC()) {
                return 0.01;
            }
            return 1.0;
        }
        double exchangeRate = stockCurrency.equals(localCurrency) ? 1.0 : ((rate = portfolioRealTimeInfo.exchangeRates.get(CurrencyPair.create(stockCurrency, localCurrency))) != null ? rate : (stockCurrency.isGBX() || stockCurrency.isZAC() ? 0.01 : 1.0));
        return exchangeRate;
    }

    public static double getExchangeRate(PortfolioRealTimeInfo portfolioRealTimeInfo, Currency localCurrency, Code code) {
        Currency stockCurrency = Utils.getStockCurrency(portfolioRealTimeInfo, code);
        return Utils.getExchangeRate(portfolioRealTimeInfo, localCurrency, stockCurrency);
    }

    public static Dividend getLatestDividend(DividendSummary dividendSummary, Code code) {
        Dividend latestDividend = null;
        int ei = dividendSummary.size();
        for (int i = 0; i < ei; ++i) {
            Dividend dividend = (Dividend)dividendSummary.get(i);
            if (!(dividend.amount > 0.0) || !dividend.stockInfo.code.equals(code)) continue;
            if (latestDividend == null) {
                latestDividend = dividend;
                continue;
            }
            if (latestDividend.date.compareTo(dividend.date) >= 0) continue;
            latestDividend = dividend;
        }
        return latestDividend;
    }

    public static String replaceCSVLineFeedToSystemLineFeed(String string) {
        String CSVLineFeed = "\n";
        String systemLineFeed = System.getProperty("line.separator");
        return string.replaceAll("\n", systemLineFeed);
    }

    public static String toExchangeRate(Object value) {
        return exchangeRateNumberFormat.get().format(value);
    }

    public static String toExchangeRate(double value) {
        return exchangeRateNumberFormat.get().format(value);
    }

    public static String toQuantity(Object value) {
        return quantityNumberFormat.get().format(value);
    }

    public static String toQuantity(double value) {
        return quantityNumberFormat.get().format(value);
    }

    public static String toCurrency(DecimalPlace decimalPlace, Object value) {
        if (decimalPlace == DecimalPlace.Two) {
            return twoDecimalPlaceCurrencyNumberFormat.get().format(value);
        }
        if (decimalPlace == DecimalPlace.Three) {
            return threeDecimalPlaceCurrencyNumberFormat.get().format(value);
        }
        assert (decimalPlace == DecimalPlace.Four);
        return fourDecimalPlaceCurrencyNumberFormat.get().format(value);
    }

    public static String toCurrency(DecimalPlace decimalPlace, double value) {
        if (decimalPlace == DecimalPlace.Two) {
            return twoDecimalPlaceCurrencyNumberFormat.get().format(value);
        }
        if (decimalPlace == DecimalPlace.Three) {
            return threeDecimalPlaceCurrencyNumberFormat.get().format(value);
        }
        assert (decimalPlace == DecimalPlace.Four);
        return fourDecimalPlaceCurrencyNumberFormat.get().format(value);
    }

    public static String toCurrencyWithSymbol(DecimalPlace decimalPlace, Object value) {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        Country country = jStockOptions.getCountry();
        return jStockOptions.getCurrencySymbol(country) + Utils.toCurrency(decimalPlace, value);
    }

    public static String toCurrencyWithSymbol(DecimalPlace decimalPlace, double value) {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        Country country = jStockOptions.getCountry();
        return jStockOptions.getCurrencySymbol(country) + Utils.toCurrency(decimalPlace, value);
    }

    public static boolean isTransactionWithEqualStockCode(Transaction t0, Transaction t1) {
        Code c0 = t0.getStockInfo().code;
        Code c1 = t1.getStockInfo().code;
        return c0.equals(c1);
    }

    public static String getPortfolioDirectory(String name) {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return Utils.getPortfolioDirectory(jStockOptions.getCountry(), name);
    }

    public static String getPortfolioDirectory(Country country, String name) {
        return org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "portfolios" + File.separator + name + File.separator;
    }

    private static String getPortfolioRealTimeInfoFilepath(Country country, String name) {
        String portfolioDirectory = Utils.getPortfolioDirectory(country, name);
        return portfolioDirectory + "portfolio-real-time-info.json";
    }

    private static String getPortfolioRealTimeInfoFilepath(String name) {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return Utils.getPortfolioRealTimeInfoFilepath(jStockOptions.getCountry(), name);
    }

    public static String getPortfolioRealTimeInfoFilepath() {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return Utils.getPortfolioRealTimeInfoFilepath(jStockOptions.getPortfolioName());
    }

    @Deprecated
    private static String getStockPricesFilepath(Country country, String name) {
        String portfolioDirectory = Utils.getPortfolioDirectory(country, name);
        return Utils.getStockPricesFilepathViaDirectory(portfolioDirectory);
    }

    @Deprecated
    public static String getStockPricesFilepathViaDirectory(String portfolioDirectory) {
        return portfolioDirectory + "stockprices.csv";
    }

    @Deprecated
    private static String getStockPricesFilepath(String name) {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return Utils.getStockPricesFilepath(jStockOptions.getCountry(), name);
    }

    @Deprecated
    public static String getStockPricesFilepath() {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return Utils.getStockPricesFilepath(jStockOptions.getPortfolioName());
    }

    public static boolean createEmptyPortfolio(String name) {
        String directory = Utils.getPortfolioDirectory(name);
        File portfolioRealTimeInfoFile = new File(Utils.getPortfolioRealTimeInfoFilepath(name));
        File stockPricesFile = new File(Utils.getStockPricesFilepath(name));
        if (portfolioRealTimeInfoFile.exists() || stockPricesFile.exists()) {
            return false;
        }
        if (!org.yccheok.jstock.gui.Utils.createCompleteDirectoryHierarchyIfDoesNotExist(directory)) {
            return false;
        }
        PortfolioRealTimeInfo portfolioRealTimeInfo = new PortfolioRealTimeInfo();
        return portfolioRealTimeInfo.save(portfolioRealTimeInfoFile);
    }

    public static String getPortfolioDirectory() {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return Utils.getPortfolioDirectory(jStockOptions.getPortfolioName());
    }

    private static boolean isCSVPortfolioDirectory(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        String[] files = file.list();
        List<String> list = Arrays.asList(files);
        return list.contains("stockprices.csv") || list.contains("portfolio-real-time-info.json");
    }

    private static boolean isPortfolioDirectory(File file) {
        return Utils.isCSVPortfolioDirectory(file);
    }

    public static String toUnits(Object value) {
        return unitsNumberFormat.get().format(value);
    }

    public static String toUnits(double value) {
        return unitsNumberFormat.get().format(value);
    }

    public static List<String> getPortfolioDirectories() {
        List<String> names = Utils.getPortfolioNames();
        ArrayList<String> directories = new ArrayList<String>();
        for (String name : names) {
            directories.add(Utils.getPortfolioDirectory(name));
        }
        return directories;
    }

    public static List<PortfolioInfo> getPortfolioInfos() {
        ArrayList<PortfolioInfo> portfolioInfos = new ArrayList<PortfolioInfo>();
        for (Country country : Country.values()) {
            File file = new File(org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "portfolios" + File.separator);
            File[] children = file.listFiles();
            if (children == null) continue;
            File[] fileArray = children;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                PortfolioInfo portfolioInfo;
                PortfolioRealTimeInfo portfolioRealTimeInfo = new PortfolioRealTimeInfo();
                File child = fileArray[i];
                File portfolioRealTimeInfoFile = new File(child, "portfolio-real-time-info.json");
                if (portfolioRealTimeInfo.load(portfolioRealTimeInfoFile)) {
                    int lines = portfolioRealTimeInfo.stockPrices.size();
                    if (lines > 0) {
                        PortfolioInfo portfolioInfo2 = PortfolioInfo.newInstance(country, child.getName(), lines);
                        portfolioInfos.add(portfolioInfo2);
                        continue;
                    }
                } else {
                    File stockPricesFile = new File(child, "stockprices.csv");
                    int lines = org.yccheok.jstock.gui.Utils.numOfLines(stockPricesFile, true);
                    if (--lines > 0) {
                        portfolioInfo = PortfolioInfo.newInstance(country, child.getName(), lines);
                        portfolioInfos.add(portfolioInfo);
                        continue;
                    }
                }
                File sellPortfolioFile = new File(child, "sellportfolio.csv");
                int lines = org.yccheok.jstock.gui.Utils.numOfLines(sellPortfolioFile, true);
                if (--lines > 0) {
                    portfolioInfo = PortfolioInfo.newInstance(country, child.getName(), lines);
                    portfolioInfos.add(portfolioInfo);
                    continue;
                }
                File dividendFile = new File(child, "dividendsummary.csv");
                lines = org.yccheok.jstock.gui.Utils.numOfLines(dividendFile, true);
                if (--lines > 0) {
                    PortfolioInfo portfolioInfo3 = PortfolioInfo.newInstance(country, child.getName(), lines);
                    portfolioInfos.add(portfolioInfo3);
                    continue;
                }
                File depositFile = new File(child, "depositsummary.csv");
                lines = org.yccheok.jstock.gui.Utils.numOfLines(depositFile, true);
                if (--lines <= 0) continue;
                PortfolioInfo portfolioInfo4 = PortfolioInfo.newInstance(country, child.getName(), lines);
                portfolioInfos.add(portfolioInfo4);
            }
        }
        return portfolioInfos;
    }

    public static ActivitySummary toActivitySummary(List<TransactionSummary> transactionSummaries, DividendSummary dividendSummary) {
        ActivitySummary activitySummary = new ActivitySummary();
        boolean isFeeCalculationEnabled = JStock.instance().getJStockOptions().isFeeCalculationEnabled();
        for (TransactionSummary transactionSummary : transactionSummaries) {
            int count = transactionSummary.getChildCount();
            for (int i = 0; i < count; ++i) {
                Transaction transaction = (Transaction)transactionSummary.getChildAt(i);
                Contract.Type type = transaction.getType();
                StockInfo stockInfo = transaction.getStockInfo();
                if (type == Contract.Type.Buy) {
                    Activity activity = new Activity.Builder(Activity.Type.Buy, isFeeCalculationEnabled ? transaction.getNetTotal() : transaction.getTotal()).put(Activity.Param.StockInfo, stockInfo).put(Activity.Param.Quantity, transaction.getQuantity()).build();
                    activitySummary.add(transaction.getDate(), activity);
                    continue;
                }
                if (type == Contract.Type.Sell) {
                    Activity activity0 = new Activity.Builder(Activity.Type.Buy, isFeeCalculationEnabled ? transaction.getNetReferenceTotal() : transaction.getReferenceTotal()).put(Activity.Param.StockInfo, stockInfo).put(Activity.Param.Quantity, transaction.getQuantity()).build();
                    Activity activity1 = new Activity.Builder(Activity.Type.Sell, isFeeCalculationEnabled ? transaction.getNetTotal() : transaction.getTotal()).put(Activity.Param.StockInfo, stockInfo).put(Activity.Param.Quantity, transaction.getQuantity()).build();
                    activitySummary.add(transaction.getDate(), activity0);
                    activitySummary.add(transaction.getDate(), activity1);
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported contract type " + (Object)((Object)type));
            }
        }
        int count = dividendSummary.size();
        for (int i = 0; i < count; ++i) {
            Dividend dividend = (Dividend)dividendSummary.get(i);
            Activity activity = new Activity.Builder(Activity.Type.Dividend, dividend.amount).put(Activity.Param.StockInfo, dividend.stockInfo).build();
            activitySummary.add(dividend.date, activity);
        }
        activitySummary.ensureSorted();
        return activitySummary;
    }

    public static List<String> getPortfolioNames() {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return Utils.getPortfolioNames(jStockOptions.getCountry());
    }

    public static List<String> getPortfolioNames(Country country) {
        ArrayList<String> portfolioNames = new ArrayList<String>();
        File file = new File(org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "portfolios" + File.separator);
        File[] children = file.listFiles();
        if (children == null) {
            return portfolioNames;
        }
        for (File child : children) {
            if (!Utils.isPortfolioDirectory(child)) continue;
            portfolioNames.add(child.getName());
        }
        Collections.sort(portfolioNames);
        return portfolioNames;
    }

    public static String getDefaultPortfolioName() {
        return "My Portfolio";
    }

    public static void removeMeaninglessRecords(DividendSummary dividendSummary) {
        for (int i = 0; i < dividendSummary.size(); ++i) {
            Dividend dividend = (Dividend)dividendSummary.get(i);
            if (!(dividend.amount <= 0.0) && dividend.stockInfo.code.toString().length() > 0) continue;
            dividendSummary.remove(dividend);
            --i;
        }
    }

    public static void removeMeaninglessRecords(DepositSummary depositSummary) {
        for (int i = 0; i < depositSummary.size(); ++i) {
            Deposit deposit = (Deposit)depositSummary.get(i);
            if (!Utils.essentiallyEqual(deposit.getAmount(), 0.0)) continue;
            depositSummary.remove(deposit);
            --i;
        }
    }

    public static double getTotalDeposit(DepositSummary cashSummary) {
        int size = cashSummary.size();
        double totalDeposit = 0.0;
        for (int i = 0; i < size; ++i) {
            Deposit deposit = (Deposit)cashSummary.get(i);
            double amount = deposit.getAmount();
            if (!Utils.definitelyGreaterThan(amount, 0.0)) continue;
            totalDeposit += amount;
        }
        return totalDeposit;
    }

    public static String toEditCurrency(DecimalPlace decimalPlace, double value) {
        if (decimalPlace == DecimalPlace.Two) {
            throw new UnsupportedOperationException();
        }
        if (decimalPlace == DecimalPlace.Three) {
            return editThreeCurrencyNumberFormat.get().format(value);
        }
        throw new UnsupportedOperationException();
    }

    public static double getTotalWithdraw(DepositSummary cashSummary) {
        int size = cashSummary.size();
        double totalWidthdraw = 0.0;
        for (int i = 0; i < size; ++i) {
            Deposit withdraw = (Deposit)cashSummary.get(i);
            double amount = withdraw.getAmount();
            if (!Utils.definitelyLesserThan(amount, 0.0)) continue;
            totalWidthdraw += amount;
        }
        return totalWidthdraw;
    }

    public static boolean essentiallyEqual(double a, double b) {
        return Math.abs(a - b) <= (Math.abs(a) > Math.abs(b) ? Math.abs(b) : Math.abs(a)) * 1.0E-8;
    }

    public static boolean definitelyGreaterThan(double a, double b) {
        return a - b > (Math.abs(a) < Math.abs(b) ? Math.abs(b) : Math.abs(a)) * 1.0E-8;
    }

    public static boolean definitelyLesserThan(double a, double b) {
        return b - a > (Math.abs(a) < Math.abs(b) ? Math.abs(b) : Math.abs(a)) * 1.0E-8;
    }
}

