/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.jdesktop.swingx.JXStatusBar;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.gui.Icons;

public class MyJXStatusBar
extends JXStatusBar {
    private Double prevExchangeRate = null;
    private final JLabel mainLabel = new JLabel();
    private final JLabel exchangeRateLabel;
    private final JLabel countryLabel;
    private final JLabel imageLabel;
    private final JProgressBar progressBar = new JProgressBar();

    public MyJXStatusBar() {
        this.progressBar.setStringPainted(false);
        this.exchangeRateLabel = new JLabel();
        this.countryLabel = new JLabel();
        this.imageLabel = new JLabel();
        this.exchangeRateLabel.setHorizontalAlignment(0);
        this.countryLabel.setHorizontalAlignment(0);
        this.imageLabel.setHorizontalAlignment(0);
        JXStatusBar.Constraint c1 = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
        JXStatusBar.Constraint c2 = new JXStatusBar.Constraint(100);
        JXStatusBar.Constraint c3 = new JXStatusBar.Constraint(50);
        JXStatusBar.Constraint c4 = new JXStatusBar.Constraint(50);
        JXStatusBar.Constraint c5 = new JXStatusBar.Constraint(50);
        this.add(this.mainLabel, c1);
        this.add(this.progressBar, c2);
        this.add(this.exchangeRateLabel, c3);
        this.add(this.countryLabel, c4);
        this.add(this.imageLabel, c5);
    }

    public MyJXStatusBar setMainMessage(String mainMessage) {
        this.mainLabel.setText(mainMessage);
        return this;
    }

    public MyJXStatusBar setImageIcon(ImageIcon imageIcon, String imageIconToolTipText) {
        this.imageLabel.setIcon(imageIcon);
        this.imageLabel.setToolTipText(imageIconToolTipText);
        return this;
    }

    public MyJXStatusBar setCountryIcon(ImageIcon imageIcon, String imageIconToolTipText) {
        this.countryLabel.setIcon(imageIcon);
        this.countryLabel.setToolTipText(imageIconToolTipText);
        return this;
    }

    public void addImageLabelMouseListener(MouseListener l) {
        this.imageLabel.addMouseListener(l);
    }

    public void addCountryLabelMouseListener(MouseListener l) {
        this.countryLabel.addMouseListener(l);
    }

    public void addExchangeRateLabelMouseListener(MouseListener l) {
        this.exchangeRateLabel.addMouseListener(l);
    }

    public MyJXStatusBar setProgressBar(boolean newValue) {
        this.progressBar.setIndeterminate(newValue);
        this.progressBar.setVisible(newValue);
        return this;
    }

    public MyJXStatusBar setExchangeRateToolTipText(String text) {
        this.exchangeRateLabel.setToolTipText(text);
        return this;
    }

    public MyJXStatusBar setExchangeRateVisible(boolean visible) {
        if (visible) {
            if (!this.exchangeRateLabel.isVisible()) {
                JXStatusBar.Constraint c = new JXStatusBar.Constraint(50);
                this.add(this.exchangeRateLabel, c, 2);
                this.exchangeRateLabel.setVisible(true);
                this.revalidate();
                this.repaint();
            }
        } else if (this.exchangeRateLabel.isVisible()) {
            this.remove(this.exchangeRateLabel);
            this.exchangeRateLabel.setVisible(false);
            this.revalidate();
            this.repaint();
        }
        return this;
    }

    public MyJXStatusBar setExchangeRate(Double exchangeRate) {
        if (exchangeRate == null) {
            this.exchangeRateLabel.setText("");
            this.exchangeRateLabel.setIcon(null);
        } else {
            this.exchangeRateLabel.setText(org.yccheok.jstock.portfolio.Utils.toExchangeRate(exchangeRate));
            if (this.prevExchangeRate != null) {
                boolean reverse = Utils.isFallBelowAndRiseAboveColorReverse();
                if (exchangeRate > this.prevExchangeRate) {
                    if (reverse) {
                        this.exchangeRateLabel.setIcon(Icons.RED_UP);
                    } else {
                        this.exchangeRateLabel.setIcon(Icons.GREEN_UP);
                    }
                } else if (exchangeRate < this.prevExchangeRate) {
                    if (reverse) {
                        this.exchangeRateLabel.setIcon(Icons.GREEN_DOWN);
                    } else {
                        this.exchangeRateLabel.setIcon(Icons.RED_DOWN);
                    }
                }
            }
        }
        this.prevExchangeRate = exchangeRate;
        return this;
    }
}

