/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import java.util.ArrayList;
import java.util.List;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.portfolio.AbstractSummary;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.PortfolioRealTimeInfo;
import org.yccheok.jstock.portfolio.Utils;

public class DividendSummary
extends AbstractSummary<Dividend> {
    private transient double total = 0.0;
    private volatile transient boolean needEvaluation = false;
    private List<Dividend> dividends = new ArrayList<Dividend>();

    public DividendSummary() {
    }

    public DividendSummary(DividendSummary dividendSummary) {
        int size = dividendSummary.size();
        for (int i = 0; i < size; ++i) {
            this.add(new Dividend((Dividend)dividendSummary.get(i)));
        }
    }

    public double getTotal() {
        double tmp = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            tmp += ((Dividend)this.get((int)i)).amount;
        }
        return tmp;
    }

    public double getTotal(PortfolioRealTimeInfo portfolioRealTimeInfo, Currency localCurrency) {
        double tmp = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Dividend dividend = (Dividend)this.get(i);
            double exchangeRate = Utils.getExchangeRate(portfolioRealTimeInfo, localCurrency, dividend.stockInfo.code);
            Currency stockCurrency = Utils.getStockCurrency(portfolioRealTimeInfo, dividend.stockInfo.code);
            if (stockCurrency.isGBX() || stockCurrency.isZAC()) {
                tmp += dividend.amount * exchangeRate * 100.0;
                continue;
            }
            tmp += dividend.amount * exchangeRate;
        }
        return tmp;
    }

    public double getTotal(Stock stock) {
        double tmp = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Dividend dividend = (Dividend)this.get(i);
            if (!dividend.stockInfo.code.equals(stock.code)) continue;
            tmp += dividend.amount;
        }
        return tmp;
    }

    public boolean isRenameOk(StockInfo newStockInfo) {
        Code newCode = newStockInfo.code;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Dividend dividend = (Dividend)this.get(i);
            if (!dividend.stockInfo.code.equals(newCode)) continue;
            return false;
        }
        return true;
    }

    public void rename(StockInfo newStockInfo, StockInfo oldStockInfo) {
        Code oldCode = oldStockInfo.code;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Dividend dividend = (Dividend)this.get(i);
            if (!dividend.stockInfo.code.equals(oldCode)) continue;
            Dividend newDividend = dividend.setStockInfo(newStockInfo);
            this.remove(i);
            this.add(i, newDividend);
        }
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        for (Dividend dividen : this.dividends) {
            this.add(dividen);
        }
        return this;
    }
}

