/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.blobsallad;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Timer;
import java.util.TimerTask;
import org.yccheok.blobsallad.BlobCollective;
import org.yccheok.blobsallad.Environment;
import org.yccheok.blobsallad.Point;
import org.yccheok.blobsallad.Vector;
import org.yccheok.blobsallad.View;

public class Controller {
    private Environment env = new Environment(0.2, 0.2, 2.6, 1.6);
    private final double scaleFactor = 200.0;
    private BlobCollective blobColl = new BlobCollective(1.0, 1.0, 200);
    private Vector gravity = new Vector(0.0, 10.0);
    private volatile boolean stopped = false;
    private Point savedMouseCoords = null;
    private Point selectOffset = null;
    private final View view = new View(this);
    private Timer timer;

    private void toggleGravity() {
        if (this.gravity.getY() > 0.0) {
            this.gravity.setY(0.0);
        } else {
            this.gravity.setY(10.0);
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public void start() {
        this.stopped = false;
        this.timeout();
    }

    public void update() {
        double dt = 0.05;
        if (this.savedMouseCoords != null && this.selectOffset != null) {
            this.blobColl.selectedBlobMoveTo(this.savedMouseCoords.getX() - this.selectOffset.getX(), this.savedMouseCoords.getY() - this.selectOffset.getY());
        }
        this.blobColl.move(dt);
        this.blobColl.sc(this.env);
        this.blobColl.setForce(this.gravity);
    }

    public void paintComponent(Graphics graphics) {
        int width = this.view.getWidth();
        int height = this.view.getHeight();
        this.env = this.env.setWidth(((double)width - 80.0) / 200.0).setHeight(((double)height - 80.0) / 200.0);
        graphics.clearRect(0, 0, this.view.getWidth(), this.view.getHeight());
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.env.draw(g2d, 200.0);
        this.blobColl.draw(g2d, 200.0);
        g2d.dispose();
    }

    public void draw() {
        this.view.repaint();
    }

    private void timeout() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                Controller.this.draw();
                Controller.this.update();
                if (Controller.this.stopped) {
                    this.cancel();
                }
            }
        }, 0L, 30L);
    }

    public Controller() {
        this.view.setDoubleBuffered(true);
        this.view.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                switch (code) {
                    case 37: {
                        Controller.this.blobColl.addForce(new Vector(-50.0, 0.0));
                        break;
                    }
                    case 38: {
                        Controller.this.blobColl.addForce(new Vector(0.0, -50.0));
                        break;
                    }
                    case 39: {
                        Controller.this.blobColl.addForce(new Vector(50.0, 0.0));
                        break;
                    }
                    case 40: {
                        Controller.this.blobColl.addForce(new Vector(0.0, 50.0));
                        break;
                    }
                    case 74: {
                        Controller.this.blobColl.join();
                        break;
                    }
                    case 72: {
                        Controller.this.blobColl.split();
                        break;
                    }
                    case 71: {
                        Controller.this.toggleGravity();
                        break;
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.view.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (Controller.this.stopped) {
                    return;
                }
                if (Controller.this.selectOffset == null) {
                    return;
                }
                Point mouseCoords = Controller.this.getMouseCoords(e);
                if (mouseCoords == null) {
                    return;
                }
                Controller.this.blobColl.selectedBlobMoveTo(mouseCoords.getX() - Controller.this.selectOffset.getX(), mouseCoords.getY() - Controller.this.selectOffset.getY());
                Controller.this.savedMouseCoords = mouseCoords;
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
        this.view.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                Controller.this.requestFocus();
            }

            public void mousePressed(MouseEvent e) {
                if (Controller.this.stopped) {
                    return;
                }
                Point mouseCoords = Controller.this.getMouseCoords(e);
                if (mouseCoords == null) {
                    return;
                }
                Controller.this.selectOffset = Controller.this.blobColl.selectBlob(mouseCoords.getX(), mouseCoords.getY());
            }

            public void mouseReleased(MouseEvent e) {
                Controller.this.blobColl.unselectBlob();
                Controller.this.savedMouseCoords = null;
                Controller.this.selectOffset = null;
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.requestFocus();
        this.start();
    }

    public Point getMouseCoords(MouseEvent e) {
        return new Point((double)e.getX() / 200.0, (double)e.getY() / 200.0);
    }

    public void requestFocus() {
        System.out.println("requestFocus");
        this.view.setFocusable(true);
        this.view.requestFocus();
        this.view.requestFocusInWindow();
    }

    public View getView() {
        return this.view;
    }
}

