/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.draw;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import netscape.javascript.JSObject;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.samples.draw.DrawFigureFactory;
import org.jhotdraw.samples.draw.DrawingPanel;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.NanoXMLDOMInput;
import org.jhotdraw.xml.NanoXMLDOMOutput;

public class DrawLiveConnectApplet
extends JApplet {
    private static final String VERSION = "7.0.8";
    private static final String NAME = "JHotDraw Draw";
    private DrawingPanel drawingPanel;
    private JToolBar jToolBar1;
    private JButton loadButton;
    private JButton saveButton;
    private ButtonGroup toolButtonGroup;

    @Override
    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        String[] lines = this.getAppletInfo().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            c.add(new JLabel(lines[i]));
        }
        new Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object construct() {
                Object result;
                block8: {
                    try {
                        if (DrawLiveConnectApplet.this.getParameter("data") != null && DrawLiveConnectApplet.this.getParameter("data").length() > 0) {
                            NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new DrawFigureFactory(), new StringReader(DrawLiveConnectApplet.this.getParameter("data")));
                            result = domi.readObject(0);
                            break block8;
                        }
                        if (DrawLiveConnectApplet.this.getParameter("datafile") != null) {
                            InputStream in = null;
                            try {
                                URL url = new URL(DrawLiveConnectApplet.this.getDocumentBase(), DrawLiveConnectApplet.this.getParameter("datafile"));
                                in = url.openConnection().getInputStream();
                                NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new DrawFigureFactory(), in);
                                result = domi.readObject(0);
                                break block8;
                            }
                            finally {
                                if (in != null) {
                                    in.close();
                                }
                            }
                        }
                        result = null;
                    }
                    catch (Throwable t) {
                        result = t;
                    }
                }
                return result;
            }

            @Override
            public void finished(Object result) {
                boolean isLiveConnect;
                Container c = DrawLiveConnectApplet.this.getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                DrawLiveConnectApplet.this.initComponents();
                if (result != null) {
                    if (result instanceof Drawing) {
                        DrawLiveConnectApplet.this.setDrawing((Drawing)result);
                    } else if (result instanceof Throwable) {
                        DrawLiveConnectApplet.this.getDrawing().add(new TextFigure(result.toString()));
                        ((Throwable)result).printStackTrace();
                    }
                }
                try {
                    Class.forName("netscape.javascript.JSObject");
                    isLiveConnect = true;
                }
                catch (Throwable t) {
                    isLiveConnect = false;
                }
                DrawLiveConnectApplet.this.loadButton.setEnabled(isLiveConnect && DrawLiveConnectApplet.this.getParameter("dataread") != null);
                DrawLiveConnectApplet.this.saveButton.setEnabled(isLiveConnect && DrawLiveConnectApplet.this.getParameter("datawrite") != null);
                if (isLiveConnect) {
                    JSObject win;
                    Object data;
                    String methodName = DrawLiveConnectApplet.this.getParameter("dataread");
                    if (methodName.indexOf(40) > 0) {
                        methodName = methodName.substring(0, methodName.indexOf(40) - 1);
                    }
                    if ((data = (win = JSObject.getWindow((Applet)DrawLiveConnectApplet.this)).call(methodName, new Object[0])) instanceof String) {
                        DrawLiveConnectApplet.this.setData((String)data);
                    }
                }
                c.validate();
            }
        }.start();
    }

    private void setDrawing(Drawing d) {
        this.drawingPanel.setDrawing(d);
    }

    private Drawing getDrawing() {
        return this.drawingPanel.getDrawing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String text) {
        if (text != null && text.length() > 0) {
            StringReader in = new StringReader(text);
            try {
                NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new DrawFigureFactory(), in);
                this.setDrawing((Drawing)domi.readObject(0));
            }
            catch (Throwable e) {
                this.getDrawing().removeAllChildren();
                TextFigure tf = new TextFigure();
                tf.setText(e.getMessage());
                tf.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
                this.getDrawing().add(tf);
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData() {
        CharArrayWriter out = new CharArrayWriter();
        try {
            NanoXMLDOMOutput domo = new NanoXMLDOMOutput(new DrawFigureFactory());
            domo.writeObject(this.getDrawing());
            domo.save(out);
        }
        catch (IOException e) {
            TextFigure tf = new TextFigure();
            tf.setText(e.getMessage());
            tf.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
            this.getDrawing().add(tf);
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return out.toString();
    }

    @Override
    public String[][] getParameterInfo() {
        return new String[][]{{"data", "String", "the data to be displayed by this applet."}, {"datafile", "URL", "an URL to a file containing the data to be displayed by this applet."}, {"dataread", "function()", "the name of a JavaScript function which can be used to read the data."}, {"datawrite", "function()", "the name of a JavaScript function which can be used to write the data."}};
    }

    @Override
    public String getAppletInfo() {
        return "JHotDraw Draw\nVersion 7.0.8\n\nCopyright 1996-2008 (c) by the authors of JHotDraw\nThis software is licensed under LGPL or\nCreative Commons 3.0 BY";
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
        this.drawingPanel = new DrawingPanel();
        this.jToolBar1 = new JToolBar();
        this.loadButton = new JButton();
        this.saveButton = new JButton();
        FormListener formListener = new FormListener();
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.jToolBar1.setFloatable(false);
        this.loadButton.setText("Laden");
        this.loadButton.addActionListener(formListener);
        this.jToolBar1.add(this.loadButton);
        this.saveButton.setText("Speichern");
        this.saveButton.addActionListener(formListener);
        this.jToolBar1.add(this.saveButton);
        this.getContentPane().add((Component)this.jToolBar1, "South");
    }

    private void save(ActionEvent evt) {
        try {
            String methodName = this.getParameter("datawrite");
            if (methodName.indexOf(40) > 0) {
                methodName = methodName.substring(0, methodName.indexOf(40) - 1);
            }
            JSObject win = JSObject.getWindow((Applet)this);
            Object result = win.call(methodName, this.getData());
        }
        catch (Throwable t) {
            TextFigure tf = new TextFigure("Fehler: " + t);
            AffineTransform tx = new AffineTransform();
            tx.translate(10.0, 20.0);
            tf.transform(tx);
            this.getDrawing().add(tf);
        }
    }

    private void load(ActionEvent evt) {
        try {
            JSObject win;
            Object result;
            String methodName = this.getParameter("dataread");
            if (methodName.indexOf(40) > 0) {
                methodName = methodName.substring(0, methodName.indexOf(40) - 1);
            }
            if ((result = (win = JSObject.getWindow((Applet)this)).call(methodName, new Object[0])) instanceof String) {
                this.setData((String)result);
            }
        }
        catch (Throwable t) {
            TextFigure tf = new TextFigure("Fehler: " + t);
            AffineTransform tx = new AffineTransform();
            tx.translate(10.0, 20.0);
            tf.transform(tx);
            this.getDrawing().add(tf);
        }
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == DrawLiveConnectApplet.this.loadButton) {
                DrawLiveConnectApplet.this.load(evt);
            } else if (evt.getSource() == DrawLiveConnectApplet.this.saveButton) {
                DrawLiveConnectApplet.this.save(evt);
            }
        }
    }
}

