/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.models;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.DefaultComboBoxModel;

public final class RecentsFilesComboModel
extends DefaultComboBoxModel {
    private final Stack<String> stack;
    private String keyProperties = null;
    private boolean autosave;
    private int maxRecentPhrasesCount;

    public RecentsFilesComboModel(String keyProperties, boolean autosave) {
        this(new Stack<String>());
        this.maxRecentPhrasesCount = AppPrefs.getProperty("maxRecentPhrasesCount", 6);
        this.keyProperties = keyProperties;
        this.autosave = autosave;
        String[] avalues = AppPrefs.getProperty(keyProperties, "").split("\\|");
        List<String> values = Arrays.asList(Arrays.copyOf(avalues, avalues.length <= this.maxRecentPhrasesCount ? avalues.length : this.maxRecentPhrasesCount));
        Collections.reverse(values);
        int counter = 0;
        for (String value : values) {
            File file = new File(value);
            if (!file.exists() || !file.isDirectory() || value.length() <= 0) continue;
            this.stack.add(0, FileUtils.getAbsolutPath(file));
            if (++counter != this.maxRecentPhrasesCount) continue;
            break;
        }
    }

    private RecentsFilesComboModel(Stack<String> v) {
        super(v);
        this.stack = v;
        this.autosave = false;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(anObject);
        this.addElement(anObject);
    }

    @Override
    public final void addElement(Object anObject) {
        if (anObject == null) {
            return;
        }
        int index = this.getIndexOf(anObject);
        if (index < 0) {
            String s = anObject.toString().trim();
            if (!("".equals(s) || "?".equals(s) || this.getNormalizedFiles(this.stack).contains(new File(s)))) {
                super.insertElementAt(anObject, 0);
                if (this.stack.size() > this.maxRecentPhrasesCount) {
                    int last = this.stack.size() - 1;
                    this.remove(last);
                    if (this.autosave) {
                        this.storeFiles();
                    }
                }
            }
            if (this.autosave) {
                this.storeFiles();
            }
        }
    }

    public void setAsMRU(Object anObject) {
        int index = this.getIndexOf(anObject);
        if (index > 0) {
            super.insertElementAt(anObject, 0);
            this.remove(index + 1);
            if (this.autosave) {
                this.storeFiles();
            }
        }
    }

    private void remove(int index) {
        this.setSelectedItem(this.getElementAt(0));
        this.stack.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public final Collection<String> getList() {
        return this.stack;
    }

    public void removeAllProperties() {
        AppPrefs.removeProperty(this.keyProperties);
    }

    private Set<File> getNormalizedFiles(Collection<String> col) {
        LinkedHashSet<File> set = new LinkedHashSet<File>(col.size());
        boolean isWindows = Utils.isWindows();
        for (String str : col) {
            File file;
            if (isWindows && !str.endsWith("\\")) {
                str = str + "\\";
            }
            if (set.contains(file = new File(str))) continue;
            set.add(file);
        }
        return set;
    }

    public void storeFiles() {
        StringBuilder builder = new StringBuilder();
        Iterator<File> it = this.getNormalizedFiles(this.stack).iterator();
        while (it.hasNext()) {
            File str = it.next();
            builder.append(FRDUtils.getAbsRelPath(str));
            if (!it.hasNext()) continue;
            builder.append("|");
        }
        AppPrefs.storeProperty(this.keyProperties, builder.toString());
    }
}

