/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public abstract class EscapedByteLookupCharset
extends Charset {
    final int[] byteToChar;
    final int[] byteToCharEscaped;
    final int[][] charToByte;
    final int[][] charToByteEscaped;
    final byte escapeByte;

    protected EscapedByteLookupCharset(String canonicalName, String[] aliases, byte escapeByte, int[] byteToChar, int[] byteToCharEscaped, int[][] charToByte, int[][] charToByteEscaped) {
        super(canonicalName, aliases);
        this.escapeByte = escapeByte;
        this.byteToChar = byteToChar;
        this.charToByte = charToByte;
        this.byteToCharEscaped = byteToCharEscaped;
        this.charToByteEscaped = charToByteEscaped;
    }

    public boolean contains(Charset charset) {
        return this.getClass().isInstance(charset);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected class Decoder
    extends CharsetDecoder {
        protected Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected Decoder(Charset charset, float averageCharsPerByte, float maxCharsPerByte) {
            super(charset, averageCharsPerByte, maxCharsPerByte);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            byte escape = EscapedByteLookupCharset.this.escapeByte;
            int[] lookup = EscapedByteLookupCharset.this.byteToChar;
            int[] lookupEscaped = EscapedByteLookupCharset.this.byteToCharEscaped;
            int remainingIn = in.remaining();
            int remainingOut = out.remaining();
            while (remainingIn-- > 0) {
                int c;
                if (remainingOut-- < 1) {
                    return CoderResult.OVERFLOW;
                }
                byte b = in.get();
                if (b == escape) {
                    if (remainingIn-- < 1) {
                        in.position(in.position() - 1);
                        return CoderResult.UNDERFLOW;
                    }
                    b = in.get();
                    c = lookupEscaped[b & 0xFF];
                } else {
                    c = lookup[b & 0xFF];
                }
                if (c == -1) {
                    in.position(in.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                out.put((char)c);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    protected class Encoder
    extends CharsetEncoder {
        protected Encoder(Charset charset) {
            super(charset, 1.0f, 2.0f);
        }

        protected Encoder(Charset charset, float averageBytesPerChar, float maxBytesPerChar) {
            super(charset, averageBytesPerChar, maxBytesPerChar);
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            byte escape = EscapedByteLookupCharset.this.escapeByte;
            int[][] lookup = EscapedByteLookupCharset.this.charToByte;
            int[][] lookupEscaped = EscapedByteLookupCharset.this.charToByteEscaped;
            int remainingIn = in.remaining();
            int remainingOut = out.remaining();
            while (remainingIn-- > 0) {
                int b;
                if (remainingOut-- < 1) {
                    return CoderResult.OVERFLOW;
                }
                char c = in.get();
                int[] table = lookup[c >> 8];
                int n = b = table == null ? -1 : table[c & 0xFF];
                if (b == -1) {
                    table = lookupEscaped[c >> 8];
                    int n2 = b = table == null ? -1 : table[c & 0xFF];
                    if (b == -1) {
                        in.position(in.position() - 1);
                        return CoderResult.unmappableForLength(1);
                    }
                    if (remainingOut-- < 1) {
                        in.position(in.position() - 1);
                        return CoderResult.OVERFLOW;
                    }
                    out.put(escape);
                }
                out.put((byte)(b & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

